/*
 * Decompiled with CFR 0.152.
 */
package net.meme20200.commandapi.wrappers;

import java.util.Objects;

public class FloatRange {
    private final float low;
    private final float high;

    public FloatRange(float low, float high) {
        this.low = low;
        this.high = high;
    }

    public static FloatRange floatRangeGreaterThanOrEq(float min) {
        return new FloatRange(min, Float.MAX_VALUE);
    }

    public static FloatRange floatRangeLessThanOrEq(float max) {
        return new FloatRange(-3.4028235E38f, max);
    }

    public float getLowerBound() {
        return this.low;
    }

    public float getUpperBound() {
        return this.high;
    }

    public boolean isInRange(float f) {
        return f >= this.low && f <= this.high;
    }

    public String toString() {
        if (this.high == Float.MAX_VALUE) {
            return this.low + "..";
        }
        if (this.low == -3.4028235E38f) {
            return ".." + this.high;
        }
        return this.low + ".." + this.high;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.high), Float.valueOf(this.low));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatRange)) {
            return false;
        }
        FloatRange other = (FloatRange)obj;
        return Float.floatToIntBits(this.high) == Float.floatToIntBits(other.high) && Float.floatToIntBits(this.low) == Float.floatToIntBits(other.low);
    }
}

