/*
 * Decompiled with CFR 0.152.
 */
package net.meme20200.commandapi.wrappers;

import java.util.function.BinaryOperator;

public enum MathOperation {
    ADD("+=", (val1, val2) -> Float.valueOf(val1.floatValue() + val2.floatValue())),
    ASSIGN("=", (val1, val2) -> val2),
    DIVIDE("/=", (val1, val2) -> Float.valueOf(val1.floatValue() / val2.floatValue())),
    MAX(">", Math::max),
    MIN("<", Math::min),
    MOD("%=", (val1, val2) -> Float.valueOf(val1.floatValue() % val2.floatValue())),
    MULTIPLY("*=", (val1, val2) -> Float.valueOf(val1.floatValue() * val2.floatValue())),
    SUBTRACT("-=", (val1, val2) -> Float.valueOf(val1.floatValue() - val2.floatValue())),
    SWAP("><", (val1, val2) -> val2);

    private String stringValue;
    private BinaryOperator<Float> application;

    private MathOperation(String stringValue, BinaryOperator<Float> application) {
        this.stringValue = stringValue;
        this.application = application;
    }

    public String toString() {
        return this.stringValue;
    }

    public static MathOperation fromString(String input) {
        for (MathOperation mathOp : MathOperation.values()) {
            if (!mathOp.stringValue.equals(input)) continue;
            return mathOp;
        }
        throw new IllegalArgumentException(input + " is not a valid MathOperation");
    }

    public int apply(int val1, int val2) {
        return (int)this.apply((float)val1, (float)val2);
    }

    public float apply(float val1, float val2) {
        return ((Float)this.application.apply(Float.valueOf(val1), Float.valueOf(val2))).floatValue();
    }
}

