/*
 * Decompiled with CFR 0.152.
 */
package teluri.mods.jlrays.light;

import java.util.Arrays;
import teluri.mods.jlrays.config.IDepthHandler;
import teluri.mods.jlrays.light.DynamicDataLayer;

public class IntDataLayer
extends DynamicDataLayer {
    protected int[] data;

    public IntDataLayer() {
    }

    public IntDataLayer(int defaultvalue) {
        super(defaultvalue);
    }

    public IntDataLayer(byte[] ndata) {
        super(ndata);
    }

    public IntDataLayer(int[] ndata) {
        this(0);
        int wantedSize = 4096;
        int receivedSize = ndata.length;
        if (receivedSize == wantedSize) {
            this.data = ndata;
        } else {
            IntDataLayer.warnForIncorrectSize(wantedSize, receivedSize);
        }
    }

    @Override
    public IntDataLayer copy() {
        return this.data == null ? new IntDataLayer(this.field_44635) : new IntDataLayer((int[])this.data.clone());
    }

    @Override
    public int getDyn(int index) {
        return this.data[index];
    }

    @Override
    public void setDyn(int index, int value) {
        this.data[index] = value;
    }

    @Override
    public boolean isEmptyDyn() {
        return this.data == null;
    }

    @Override
    public void initDyn() {
        if (this.data == null) {
            this.data = new int[4096];
            if (this.field_44635 != 0) {
                Arrays.fill(this.data, this.field_44635);
            }
        }
    }

    @Override
    public byte[] getData2() {
        byte[] rtn = new byte[16384];
        int itr = 0;
        for (int bytes4 : this.data) {
            rtn[itr + 0] = (byte)bytes4;
            rtn[itr + 1] = (byte)(bytes4 >>> 8);
            rtn[itr + 2] = (byte)(bytes4 >>> 16);
            rtn[itr + 3] = (byte)(bytes4 >>> 24);
            itr += 4;
        }
        return rtn;
    }

    @Override
    protected void initDyn(byte[] ndata) {
        this.data = new int[4096];
        for (int itr = 0; itr < this.data.length; ++itr) {
            int itr2 = itr * 4;
            int b0 = ndata[itr2 + 0] & 0xFF;
            int b1 = ndata[itr2 + 1] & 0xFF;
            int b2 = ndata[itr2 + 2] & 0xFF;
            int b3 = ndata[itr2 + 3] & 0xFF;
            this.data[itr] = b0 | b1 << 8 | b2 << 16 | b3 << 24;
        }
    }

    @Override
    protected int getNibbleCount() {
        return 8;
    }

    public static class IntDataLayerFactory
    implements IDepthHandler {
        @Override
        public DynamicDataLayer createDataLayer() {
            return new IntDataLayer();
        }

        @Override
        public DynamicDataLayer createDataLayer(byte[] data) {
            return new IntDataLayer(data);
        }

        @Override
        public DynamicDataLayer createDataLayer(int defaultval) {
            return new IntDataLayer(defaultval);
        }

        @Override
        public int getNibbleCount() {
            return 8;
        }
    }
}

