/*
 * Decompiled with CFR 0.152.
 */
package teluri.mods.jlrays.light;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import teluri.mods.jlrays.config.BlockConfig;
import teluri.mods.jlrays.config.JlrConfig;
import teluri.mods.jlrays.light.DynamicDataLayer;
import teluri.mods.jlrays.light.misc.IBlockStateProvider;
import teluri.mods.jlrays.light.misc.ILightStorage;
import teluri.mods.jlrays.light.misc.SectionUpdate;
import teluri.mods.jlrays.light.misc.TaskCache;
import teluri.mods.jlrays.light.sight.FbGbvSightEngine;
import teluri.mods.jlrays.light.sight.misc.AlphaHolder;
import teluri.mods.jlrays.light.sight.misc.ISightUpdateConsumer;
import teluri.mods.jlrays.light.sight.misc.Quadrant;
import teluri.mods.jlrays.misc.DullBlockPos;
import teluri.mods.jlrays.misc.ShinyBlockPos;
import teluri.mods.jlrays.util.MathHelper;

public class JlrBlockLightEngine {
    protected final Long2ObjectOpenHashMap<class_2680> changeMap = new Long2ObjectOpenHashMap();
    protected final Long2ObjectOpenHashMap<class_2680> sourceChangeMap = new Long2ObjectOpenHashMap();
    protected final Long2ObjectOpenHashMap<SectionUpdate> sectionChangeMap = new Long2ObjectOpenHashMap();
    protected final TaskCache.ITaskCacheFactory taskCacheFactory;
    protected final IBlockStateProvider blockStateProvider;
    protected final ILightStorage lightStorage;
    public final float distanceRatio;
    public final float correctedMinimumValue;
    public final float rangeEdgeNumber;
    public final int maxRange;
    public final int precisionMultiplier;
    public final float minValCorrector2;

    public JlrBlockLightEngine(IBlockStateProvider nBSProvider, TaskCache.ITaskCacheFactory ntaskCacheFactory, ILightStorage nLightStorage) {
        this.taskCacheFactory = ntaskCacheFactory;
        this.blockStateProvider = nBSProvider;
        this.lightStorage = nLightStorage;
        JlrConfig config = JlrConfig.LazyGet();
        this.distanceRatio = config.distanceRatio;
        this.precisionMultiplier = 1 << config.precision;
        this.correctedMinimumValue = config.minimumValue * (float)this.precisionMultiplier;
        this.minValCorrector2 = 15.001f / (15.0f - this.correctedMinimumValue);
        this.rangeEdgeNumber = 1.0f / (this.correctedMinimumValue * this.distanceRatio);
        this.maxRange = this.getRange(BlockConfig.LazyGet().maxEmission);
    }

    public void checkBlock(class_2338 pos) {
        int z;
        int y;
        int x;
        TaskCache tc;
        if (!(pos instanceof ShinyBlockPos)) {
            if (!(pos instanceof DullBlockPos)) {
                DullBlockPos.warn();
            }
            return;
        }
        ShinyBlockPos rpos = (ShinyBlockPos)pos;
        class_2680 prev = rpos.previous;
        class_2680 curr = rpos.current;
        long secpos = class_4076.method_18691((long)pos.method_10063());
        if (!this.lightStorage.storingLightForSection(secpos)) {
            return;
        }
        if (prev.method_26213() != curr.method_26213()) {
            this.sourceChangeMap.putIfAbsent(pos.method_10063(), (Object)prev);
        }
        if (JlrBlockLightEngine.getAlpha(prev, tc = this.taskCacheFactory.createWithRange(pos, 0), x = pos.method_10263(), y = pos.method_10264(), z = pos.method_10260()) != JlrBlockLightEngine.getAlpha(curr, tc, x, y, z) || prev.method_26211() || curr.method_26211()) {
            this.changeMap.putIfAbsent(pos.method_10063(), (Object)prev);
            SectionUpdate secupd = (SectionUpdate)this.sectionChangeMap.get(secpos);
            if (secupd == null) {
                secupd = new SectionUpdate(pos.method_10263(), pos.method_10264(), pos.method_10260());
                this.sectionChangeMap.put(secpos, (Object)secupd);
            } else {
                secupd.merge(pos);
            }
        }
    }

    public boolean hasLightWork() {
        return !this.changeMap.isEmpty();
    }

    public void runLightUpdates() {
        this.sectionChangeMap.long2ObjectEntrySet().parallelStream().forEach(entry -> {
            SectionUpdate secupd = (SectionUpdate)entry.getValue();
            if (secupd.isSingleBlock()) {
                Vector3i vtmp = new Vector3i(secupd.x1, secupd.y1, secupd.z1);
                this.evaluateImpactedSources(vtmp);
            } else {
                this.groupApproximateImpactedSources(secupd);
            }
        });
        this.sourceChangeMap.forEach((longpos, prev) -> {
            Vector3i vtmp = new Vector3i();
            class_2680 curr = this.blockStateProvider.get((long)longpos);
            vtmp.set(class_2338.method_10061((long)longpos), class_2338.method_10071((long)longpos), class_2338.method_10083((long)longpos));
            this.updateImpactedSource(vtmp, (class_2680)prev, curr);
        });
        TaskCache tc = this.taskCacheFactory.createWithRange(0, 0, 0, 0);
        this.changeMap.forEach((longpos, prev) -> {
            class_2680 curr = this.blockStateProvider.get((long)longpos);
            if (JlrBlockLightEngine.getAlpha(curr, tc, class_2338.method_10061((long)longpos), class_2338.method_10071((long)longpos), class_2338.method_10083((long)longpos)) == 0 && curr.method_26213() == 0) {
                this.lightStorage.setLevel((long)longpos, 0);
            }
        });
        this.changeMap.clear();
        this.changeMap.trim(512);
        this.sourceChangeMap.clear();
        this.sourceChangeMap.trim(512);
        this.sectionChangeMap.clear();
        this.sectionChangeMap.trim(512);
        this.lightStorage.onLightUpdateCompleted();
    }

    protected void evaluateImpactedSources(Vector3i pos) {
        long[] inrangepos = new long[this.changeMap.size()];
        class_2680[] inrangebs = new class_2680[this.changeMap.size()];
        int size = this.filterBlockUpdatesByRange(pos, inrangepos, inrangebs, this.maxRange);
        TaskCache preCache = this.taskCacheFactory.createWithRange(pos, this.maxRange);
        FbGbvSightEngine.forEachQuadrants(quadrant -> {
            TaskCache taskCache = preCache.shallowCopy();
            ISightUpdateConsumer scons = (source, unused1, unused2) -> {
                class_2680 blockState = taskCache.get(source);
                int sourceemit = blockState.method_26213();
                if (sourceemit != 0) {
                    float sourcerange = this.getRangeSquared(sourceemit);
                    long dist = source.distanceSquared((Vector3ic)pos);
                    if ((float)dist < sourcerange) {
                        this.syncAddSourceChange(class_2338.method_10064((int)source.x, (int)source.y, (int)source.z), blockState);
                    }
                }
            };
            if (size == 0) {
                FbGbvSightEngine.traceQuadrant(pos, this.maxRange, quadrant, taskCache, scons, true);
            } else {
                AlphaHolder.IAlphaChangeProvider caprov = this.getFastestPreviousAlphaProvider(inrangebs, inrangepos, size, taskCache);
                FbGbvSightEngine.traceChangedQuadrant(pos, this.maxRange, quadrant, caprov, scons, true);
            }
        });
    }

    private synchronized void syncAddSourceChange(long longpos, class_2680 blockState) {
        this.sourceChangeMap.putIfAbsent(longpos, (Object)blockState);
    }

    protected void groupApproximateImpactedSources(SectionUpdate secupd) {
        int sx1 = secupd.x1 - this.maxRange;
        int sy1 = secupd.y1 - this.maxRange;
        int sz1 = secupd.z1 - this.maxRange;
        int sx2 = secupd.x2 + this.maxRange;
        int sy2 = secupd.y2 + this.maxRange;
        int sz2 = secupd.z2 + this.maxRange;
        TaskCache taskCache = this.taskCacheFactory.create(sx1, sy1, sz1, sx2, sy2, sz2);
        for (int itx = sx1; itx < sx2; ++itx) {
            for (int ity = sy1; ity < sy2; ++ity) {
                for (int itz = sz1; itz < sz2; ++itz) {
                    class_2680 blockState = taskCache.getState(itx, ity, itz);
                    int sourceemit = blockState.method_26213();
                    if (sourceemit == 0) continue;
                    this.syncAddSourceChange(class_2338.method_10064((int)itx, (int)ity, (int)itz), blockState);
                }
            }
        }
    }

    protected void updateImpactedSource(Vector3i source, class_2680 oldbs, class_2680 newbs) {
        int newemit;
        int oldemit = oldbs.method_26213();
        if (oldemit != (newemit = newbs.method_26213())) {
            int change = this.getLightLevelChange(source, source, 1.0f, 1.0f, oldemit, newemit);
            this.lightStorage.addLevel(class_2338.method_10064((int)source.x, (int)source.y, (int)source.z), change);
        }
        int range = this.getRange(Math.max(oldemit, newemit));
        long[] inrangepos = new long[this.changeMap.size()];
        class_2680[] inrangebs = new class_2680[this.changeMap.size()];
        int size = this.filterBlockUpdatesByRange(source, inrangepos, inrangebs, range);
        TaskCache preCache = this.taskCacheFactory.createWithRange(source, range);
        FbGbvSightEngine.forEachQuadrants(quadrant -> {
            TaskCache taskCache = preCache.shallowCopy();
            ISightUpdateConsumer consu = (xyz, ovisi, nvisi) -> this.updateLight(source, xyz, ovisi, nvisi, oldemit, newemit, taskCache);
            if (size != 0 && (oldemit != newemit || this.isQuadrantChanged(inrangepos, size, source, (Quadrant)quadrant))) {
                AlphaHolder.IAlphaChangeProvider caprov = this.getFastestPreviousAlphaProvider(inrangebs, inrangepos, size, taskCache);
                FbGbvSightEngine.traceChangedQuadrant(source, range, quadrant, caprov, consu, false);
            } else if (oldemit != newemit) {
                FbGbvSightEngine.traceQuadrant(source, range, quadrant, taskCache, consu, false);
            }
        });
        preCache.applyAffectedCache();
    }

    public void propagateLightSources(class_1923 chunkPos) {
        this.lightStorage.method_15512(chunkPos, true);
        Vector3i tmp = new Vector3i();
        this.lightStorage.findBlockLightSources(chunkPos, (blockPos, blockState) -> {
            int emit = blockState.method_26213();
            Vector3i vpos = tmp.set(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            int change = this.getLightLevelChange(vpos, vpos, 1.0f, 1.0f, 0, emit);
            this.lightStorage.addLevel(blockPos.method_10063(), change);
            int range = this.getRange(emit);
            TaskCache preCache = this.taskCacheFactory.createWithRange((class_2338)blockPos, range);
            FbGbvSightEngine.forEachQuadrants(quadrant -> {
                TaskCache taskCache = preCache.shallowCopy();
                ISightUpdateConsumer consu = (xyz, ovisi, nvisi) -> this.updateLight(vpos, xyz, ovisi, nvisi, 0, emit, taskCache);
                FbGbvSightEngine.traceQuadrant(vpos, range, quadrant, taskCache, consu, false);
            });
            preCache.applyAffectedCache();
        });
    }

    public boolean isQuadrantChanged(long[] inrangepos, int size, Vector3i source, Quadrant quadrant) {
        Vector3i vtmp = new Vector3i();
        for (int it = 0; it < size; ++it) {
            long target = inrangepos[it];
            int x = class_2338.method_10061((long)target);
            int y = class_2338.method_10071((long)target);
            int z = class_2338.method_10083((long)target);
            int comp1 = MathHelper.sum(vtmp.set(x, y, z).sub((Vector3ic)source).mul((Vector3ic)quadrant.axis1));
            int comp2 = MathHelper.sum(vtmp.set(x, y, z).sub((Vector3ic)source).mul((Vector3ic)quadrant.axis2));
            int comp3 = MathHelper.sum(vtmp.set(x, y, z).sub((Vector3ic)source).mul((Vector3ic)quadrant.axis3));
            if (0 > comp1 || 0 > comp2 || 0 > comp3) continue;
            return true;
        }
        return false;
    }

    protected int filterBlockUpdatesByRange(Vector3i source, long[] inrangepos, class_2680[] inrangebs, int range) {
        Vector3i vtmp = new Vector3i();
        int iter = 0;
        for (Long2ObjectMap.Entry entry : this.changeMap.long2ObjectEntrySet()) {
            long epos = entry.getLongKey();
            vtmp.set(class_2338.method_10061((long)epos), class_2338.method_10071((long)epos), class_2338.method_10083((long)epos)).sub((Vector3ic)source).absolute();
            int dist = Math.max(vtmp.x, Math.max(vtmp.y, vtmp.z));
            if (dist > range || dist == 0) continue;
            inrangepos[iter] = entry.getLongKey();
            inrangebs[iter] = (class_2680)entry.getValue();
            ++iter;
        }
        return iter;
    }

    protected AlphaHolder.IAlphaChangeProvider getFastestPreviousAlphaProvider(class_2680[] oldbss, long[] targets, int size, TaskCache taskCache) {
        IBlockStateProvider bsprov = this.getFastestPreviousBlockStateProvider(oldbss, targets, size, taskCache);
        return (xyz, source, quadr, ohol, nhol) -> JlrBlockLightEngine.getAlphasChange(xyz, source, bsprov, taskCache, quadr, ohol, nhol, taskCache);
    }

    protected IBlockStateProvider getFastestPreviousBlockStateProvider(class_2680[] oldbss, long[] targets, int size, TaskCache taskCache) {
        long target = targets[0];
        class_2680 bs = oldbss[0];
        Long2ObjectOpenHashMap<class_2680> changeMap = this.changeMap;
        return switch (size) {
            case 0 -> taskCache;
            case 1 -> (x, y, z) -> JlrBlockLightEngine.getOldStateWhenOne_(x, y, z, taskCache, bs, target);
            case 2, 3, 4, 5, 6, 7, 8 -> (x, y, z) -> JlrBlockLightEngine.getOldStateWhenSome(x, y, z, taskCache, oldbss, targets, size);
            default -> (x, y, z) -> JlrBlockLightEngine.getOldStateWhenMany(x, y, z, taskCache, changeMap);
        };
    }

    public static int getAlpha(class_2680 state, TaskCache taskCache, int x, int y, int z) {
        return taskCache.getLightBlock(state, x, y, z) <= 1 ? 1 : 0;
    }

    public static AlphaHolder getAlphas(Vector3i xyz, Vector3i source, IBlockStateProvider bsprov, Quadrant quadr, AlphaHolder hol, TaskCache taskCache) {
        class_2680 state = bsprov.get(xyz);
        hol.setAll(JlrBlockLightEngine.getAlpha(state, taskCache, xyz.x, xyz.y, xyz.z));
        if (hol.block != 0.0f && JlrBlockLightEngine.isntEmptyShape(state)) {
            class_2350 d1 = 0 < quadr.axis1.x ? class_2350.field_11039 : class_2350.field_11034;
            class_2350 d2 = 0 < quadr.axis2.y ? class_2350.field_11033 : class_2350.field_11036;
            class_2350 d3 = 0 < quadr.axis3.z ? class_2350.field_11043 : class_2350.field_11035;
            class_2350 d4 = d1.method_10153();
            class_2350 d5 = d2.method_10153();
            class_2350 d6 = d3.method_10153();
            hol.f1 *= JlrBlockLightEngine.getFaceAlpha(source, state, bsprov, d1, xyz.x - quadr.axis1.x, xyz.y, xyz.z, taskCache, xyz);
            hol.f2 *= JlrBlockLightEngine.getFaceAlpha(source, state, bsprov, d2, xyz.x, xyz.y - quadr.axis2.y, xyz.z, taskCache, xyz);
            hol.f3 *= JlrBlockLightEngine.getFaceAlpha(source, state, bsprov, d3, xyz.x, xyz.y, xyz.z - quadr.axis3.z, taskCache, xyz);
            hol.f4 *= JlrBlockLightEngine.getFaceAlpha(source, state, bsprov, d4, xyz.x + quadr.axis1.x, xyz.y, xyz.z, taskCache, xyz);
            hol.f5 *= JlrBlockLightEngine.getFaceAlpha(source, state, bsprov, d5, xyz.x, xyz.y + quadr.axis2.y, xyz.z, taskCache, xyz);
            hol.f6 *= JlrBlockLightEngine.getFaceAlpha(source, state, bsprov, d6, xyz.x, xyz.y, xyz.z + quadr.axis3.z, taskCache, xyz);
        }
        return hol;
    }

    public static void getAlphasChange(Vector3i xyz, Vector3i source, IBlockStateProvider oprov, IBlockStateProvider nprov, Quadrant quadr, AlphaHolder ohol, AlphaHolder nhol, TaskCache taskCache) {
        boolean ocomplex;
        boolean same;
        class_2680 nstate = nprov.get(xyz);
        class_2680 ostate = oprov.get(xyz);
        int nalpha = JlrBlockLightEngine.getAlpha(nstate, taskCache, xyz.x, xyz.y, xyz.z);
        nhol.setAll(nalpha);
        boolean ncomplex = nhol.block != 0.0f && JlrBlockLightEngine.isntEmptyShape(nstate);
        boolean bl = same = ostate == null;
        if (same) {
            ostate = nstate;
            ocomplex = ncomplex;
            ohol.setAll(nalpha);
        } else {
            ohol.setAll(JlrBlockLightEngine.getAlpha(ostate, taskCache, xyz.x, xyz.y, xyz.z));
            boolean bl2 = ocomplex = ohol.block != 0.0f && JlrBlockLightEngine.isntEmptyShape(ostate);
        }
        if (!ocomplex && !ncomplex) {
            return;
        }
        class_2350 d1 = 0 < quadr.axis1.x ? class_2350.field_11039 : class_2350.field_11034;
        class_2350 d2 = 0 < quadr.axis2.y ? class_2350.field_11033 : class_2350.field_11036;
        class_2350 d3 = 0 < quadr.axis3.z ? class_2350.field_11043 : class_2350.field_11035;
        class_2350 d4 = d1.method_10153();
        class_2350 d5 = d2.method_10153();
        class_2350 d6 = d3.method_10153();
        int x1___ = xyz.x - quadr.axis1.x;
        int y2___ = xyz.y - quadr.axis2.y;
        int z3___ = xyz.z - quadr.axis3.z;
        int x4___ = xyz.x + quadr.axis1.x;
        int y5___ = xyz.y + quadr.axis2.y;
        int z6___ = xyz.z + quadr.axis3.z;
        if (ncomplex) {
            nhol.f1 *= JlrBlockLightEngine.getFaceAlpha(source, nstate, nprov, d1, x1___, xyz.y, xyz.z, taskCache, xyz);
            nhol.f2 *= JlrBlockLightEngine.getFaceAlpha(source, nstate, nprov, d2, xyz.x, y2___, xyz.z, taskCache, xyz);
            nhol.f3 *= JlrBlockLightEngine.getFaceAlpha(source, nstate, nprov, d3, xyz.x, xyz.y, z3___, taskCache, xyz);
            nhol.f4 *= JlrBlockLightEngine.getFaceAlpha(source, nstate, nprov, d4, x4___, xyz.y, xyz.z, taskCache, xyz);
            nhol.f5 *= JlrBlockLightEngine.getFaceAlpha(source, nstate, nprov, d5, xyz.x, y5___, xyz.z, taskCache, xyz);
            nhol.f6 *= JlrBlockLightEngine.getFaceAlpha(source, nstate, nprov, d6, xyz.x, xyz.y, z6___, taskCache, xyz);
        }
        if (same) {
            ohol.setAll(nhol);
        } else if (ocomplex) {
            ohol.f1 *= JlrBlockLightEngine.getFaceAlpha(source, ostate, oprov, d1, x1___, xyz.y, xyz.z, taskCache, xyz);
            ohol.f2 *= JlrBlockLightEngine.getFaceAlpha(source, ostate, oprov, d2, xyz.x, y2___, xyz.z, taskCache, xyz);
            ohol.f3 *= JlrBlockLightEngine.getFaceAlpha(source, ostate, oprov, d3, xyz.x, xyz.y, z3___, taskCache, xyz);
            ohol.f4 *= JlrBlockLightEngine.getFaceAlpha(source, ostate, oprov, d4, x4___, xyz.y, xyz.z, taskCache, xyz);
            ohol.f5 *= JlrBlockLightEngine.getFaceAlpha(source, ostate, oprov, d5, xyz.x, y5___, xyz.z, taskCache, xyz);
            ohol.f6 *= JlrBlockLightEngine.getFaceAlpha(source, ostate, oprov, d6, xyz.x, xyz.y, z6___, taskCache, xyz);
        }
    }

    protected static float getFaceAlpha(Vector3i source, class_2680 curstate, IBlockStateProvider bsprov, class_2350 dir, int ox, int oy, int oz, TaskCache taskCache, Vector3i xyz) {
        class_2680 otherstate = source.equals(ox, oy, oz) ? class_2246.field_10124.method_9564() : bsprov.getState(ox, oy, oz);
        return JlrBlockLightEngine.shapeOccludes(curstate, otherstate, dir, taskCache, ox, oy, oz, xyz) ? 0.0f : 1.0f;
    }

    protected static boolean isntEmptyShape(class_2680 state) {
        return state.method_26225() && state.method_26211();
    }

    public static boolean shapeOccludes(class_2680 state1, class_2680 state2, class_2350 dir, TaskCache taskCache, int ox, int oy, int oz, Vector3i xyz) {
        class_265 voxelShape = taskCache.getOcclusionShape(state1, dir, xyz.x, xyz.y, xyz.z);
        class_265 voxelShape2 = taskCache.getOcclusionShape(state2, dir.method_10153(), ox, oy, oz);
        return class_259.method_20713((class_265)voxelShape, (class_265)voxelShape2);
    }

    public static class_2680 getOldStateWhenOne_(int x, int y, int z, TaskCache taskCache, class_2680 oldbs, long target) {
        return target == class_2338.method_10064((int)x, (int)y, (int)z) ? oldbs : taskCache.getState(x, y, z);
    }

    public static class_2680 getOldStateWhenSome(int x, int y, int z, TaskCache taskCache, class_2680[] oldbss, long[] targets, int size) {
        for (int iter = 0; iter < size; ++iter) {
            if (targets[iter] != class_2338.method_10064((int)x, (int)y, (int)z)) continue;
            return oldbss[iter];
        }
        return taskCache.getState(x, y, z);
    }

    public static class_2680 getOldStateWhenMany(int x, int y, int z, TaskCache taskCache, Long2ObjectOpenHashMap<class_2680> changeMap) {
        class_2680 state = (class_2680)changeMap.get(class_2338.method_10064((int)x, (int)y, (int)z));
        return state != null ? state : taskCache.getState(x, y, z);
    }

    public void updateLight(Vector3i source, Vector3i xyz, float ovisi, float nvisi, int oldemit, int newemit, TaskCache taskCache) {
        DynamicDataLayer data = taskCache.getCachedDataLayer(xyz.x, xyz.y, xyz.z);
        if (data == null) {
            return;
        }
        int change = this.getLightLevelChange(source, xyz, ovisi, nvisi, oldemit, newemit);
        if (change != 0) {
            int lx = class_4076.method_18684((int)xyz.x);
            int ly = class_4076.method_18684((int)xyz.y);
            int lz = class_4076.method_18684((int)xyz.z);
            int index = DynamicDataLayer.getIndex(lx, ly, lz);
            data.add(index, change);
            taskCache.notifyUpdate(xyz.x, xyz.y, xyz.z);
        }
    }

    public int getLightLevelChange(Vector3i source, Vector3i xyz, float ovisi, float nvisi, int oldemit, int newemit) {
        float distinv = 1.0f / Math.max(1.0f, 1.0f - this.distanceRatio + (float)source.distanceSquared((Vector3ic)xyz) * this.distanceRatio);
        int oldlevel = this.calculateLightLevel(ovisi, distinv, oldemit);
        int newlevel = this.calculateLightLevel(nvisi, distinv, newemit);
        return -oldlevel + newlevel;
    }

    public int calculateLightLevel(float visi, float distinv, int emit) {
        return (emit *= this.precisionMultiplier) == 0 || visi == 0.0f ? 0 : class_3532.method_15340((int)((int)((visi * distinv * (float)emit - this.correctedMinimumValue) * this.minValCorrector2)), (int)0, (int)emit);
    }

    public int getRange(float emit) {
        return (int)Math.ceil(Math.sqrt(this.getRangeSquared(emit)));
    }

    public float getRangeSquared(float emit) {
        return (emit * (float)this.precisionMultiplier - this.correctedMinimumValue) * this.rangeEdgeNumber;
    }
}

