/*
 * Decompiled with CFR 0.152.
 */
package teluri.mods.jlrays.light.misc;

import java.util.function.BiConsumer;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2823;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_8527;
import net.minecraft.class_8528;
import org.joml.Vector3i;
import teluri.mods.jlrays.JustLikeRays;
import teluri.mods.jlrays.light.DynamicDataLayer;
import teluri.mods.jlrays.light.JlrBlockLightEngine;
import teluri.mods.jlrays.light.JlrLightSectionStorage;
import teluri.mods.jlrays.light.misc.IBlockStateProvider;
import teluri.mods.jlrays.light.sight.misc.AlphaHolder;
import teluri.mods.jlrays.light.sight.misc.Quadrant;

public class TaskCache
implements IBlockStateProvider,
AlphaHolder.IAlphaProvider {
    protected final int ax;
    protected final int ay;
    protected final int az;
    protected final int bx;
    protected final int by;
    protected final int bz;
    protected final int sax;
    protected final int say;
    protected final int saz;
    protected final int lenx;
    protected final int leny;
    protected final int lenz;
    protected final class_2338.class_2339 mutpos = new class_2338.class_2339();
    protected final class_2823 chunkGetter;
    protected final JlrLightSectionStorage lightStorage;
    protected final class_8527[][] chunkCache;
    protected final DynamicDataLayer[][][] lightCache;
    protected final boolean[][][] affectedCache;
    private static final class_8527 BEDROCK_GIVER = new class_8527(){

        public class_2680 method_8320(class_2338 pos) {
            return class_2246.field_9987.method_9564();
        }

        public void method_51524(BiConsumer<class_2338, class_2680> output) {
        }

        public class_2586 method_8321(class_2338 pos) {
            throw new UnsupportedOperationException();
        }

        public class_3610 method_8316(class_2338 pos) {
            throw new UnsupportedOperationException();
        }

        public int method_31605() {
            throw new UnsupportedOperationException();
        }

        public int method_31607() {
            throw new UnsupportedOperationException();
        }

        public class_8528 method_12018() {
            throw new UnsupportedOperationException();
        }
    };

    public TaskCache(int nax, int nay, int naz, int nbx, int nby, int nbz, class_2823 nchunkgetter, JlrLightSectionStorage nlightstorage) {
        this.ax = nax;
        this.ay = nay;
        this.az = naz;
        this.bx = nbx;
        this.by = nby;
        this.bz = nbz;
        this.chunkGetter = nchunkgetter;
        this.lightStorage = nlightstorage;
        this.sax = class_4076.method_18675((int)(this.ax - 1));
        this.say = class_4076.method_18675((int)(this.ay - 1));
        this.saz = class_4076.method_18675((int)(this.az - 1));
        int sbx = class_4076.method_18675((int)(this.bx + 1));
        int sby = class_4076.method_18675((int)(this.by + 1));
        int sbz = class_4076.method_18675((int)(this.bz + 1));
        this.lenx = sbx - this.sax + 1;
        this.leny = sby - this.say + 1;
        this.lenz = sbz - this.saz + 1;
        this.chunkCache = new class_8527[this.lenx][this.lenz];
        this.lightCache = new DynamicDataLayer[this.lenx][this.leny][this.lenz];
        this.affectedCache = new boolean[this.lenx + 2][this.leny + 2][this.lenz + 2];
        for (int itx = this.sax; itx <= sbx; ++itx) {
            for (int itz = this.saz; itz <= sbz; ++itz) {
                class_8527 chunk = this.chunkGetter.method_12246(itx, itz);
                this.chunkCache[itx - this.sax][itz - this.saz] = chunk != null ? chunk : BEDROCK_GIVER;
                for (int ity = this.say; ity <= sby; ++ity) {
                    this.lightCache[itx - this.sax][ity - this.say][itz - this.saz] = this.lightStorage.getDataLayerForCaching(itx, ity, itz);
                }
            }
        }
    }

    private TaskCache(TaskCache prev) {
        this.ax = prev.ax;
        this.ay = prev.ay;
        this.az = prev.az;
        this.bx = prev.bx;
        this.by = prev.by;
        this.bz = prev.bz;
        this.chunkGetter = prev.chunkGetter;
        this.lightStorage = prev.lightStorage;
        this.sax = prev.sax;
        this.say = prev.say;
        this.saz = prev.saz;
        this.lenx = prev.lenx;
        this.leny = prev.leny;
        this.lenz = prev.lenz;
        this.chunkCache = prev.chunkCache;
        this.lightCache = prev.lightCache;
        this.affectedCache = prev.affectedCache;
    }

    public TaskCache shallowCopy() {
        return new TaskCache(this);
    }

    @Override
    public class_2680 getState(int x, int y, int z) {
        return this.getCachedChunk(x, z).method_8320((class_2338)this.mutpos.method_10103(x, y, z));
    }

    public class_8527 getCachedChunk(int x, int z) {
        int sx = class_4076.method_18675((int)x);
        int sz = class_4076.method_18675((int)z);
        return this.getCachedChunkFromSectionPos(sx, sz);
    }

    public class_8527 getCachedChunkFromSectionPos(int sx, int sz) {
        if ((sx -= this.sax) < 0 || this.lenx <= sx || (sz -= this.saz) < 0 || this.lenz <= sz) {
            JustLikeRays.LOGGER.info("chunk cache oob at s:" + sx + "," + sz + " sa:" + this.sax + "," + this.saz + " len:" + this.lenx + "," + this.lenz);
            class_8527 chunk = this.chunkGetter.method_12246(sx + this.sax, sz + this.saz);
            return chunk == null ? BEDROCK_GIVER : chunk;
        }
        return this.chunkCache[sx][sz];
    }

    public DynamicDataLayer getCachedDataLayer(int x, int y, int z) {
        int sx = class_4076.method_18675((int)x);
        int sy = class_4076.method_18675((int)y);
        int sz = class_4076.method_18675((int)z);
        return this.getCachedDataLayerFromSectionPos(sx, sy, sz);
    }

    public DynamicDataLayer getCachedDataLayerFromSectionPos(int sx, int sy, int sz) {
        return this.lightCache[sx - this.sax][sy - this.say][sz - this.saz];
    }

    public void notifyUpdate(int x, int y, int z) {
        int sx1 = class_4076.method_18675((int)(x - 1)) - this.sax + 1;
        int sy1 = class_4076.method_18675((int)(y - 1)) - this.say + 1;
        int sz1 = class_4076.method_18675((int)(z - 1)) - this.saz + 1;
        int sx2 = class_4076.method_18675((int)(x + 1)) - this.sax + 1;
        int sy2 = class_4076.method_18675((int)(y + 1)) - this.say + 1;
        int sz2 = class_4076.method_18675((int)(z + 1)) - this.saz + 1;
        if (sx1 == sx2 && sy1 == sy2 && sz1 == sz2) {
            this.affectedCache[sx1][sy1][sz1] = true;
        } else {
            for (int itx = sx1; itx <= sx2; ++itx) {
                for (int ity = sy1; ity <= sy2; ++ity) {
                    for (int itz = sz1; itz <= sz2; ++itz) {
                        this.affectedCache[itx][ity][itz] = true;
                    }
                }
            }
        }
    }

    public void applyAffectedCache() {
        this.lightStorage.syncUsing(() -> {
            for (int itx = this.sax; itx <= this.sax + this.lenx; ++itx) {
                for (int ity = this.say; ity <= this.say + this.leny; ++ity) {
                    for (int itz = this.saz; itz <= this.saz + this.lenz; ++itz) {
                        if (!this.affectedCache[itx - this.sax + 1][ity - this.say + 1][itz - this.saz + 1]) continue;
                        this.lightStorage.notifySingleSectionUpdate(itx, ity, itz);
                    }
                }
            }
        });
    }

    @Override
    public AlphaHolder getAlphas(Vector3i xyz, Vector3i source, Quadrant quadr, AlphaHolder hol) {
        return JlrBlockLightEngine.getAlphas(xyz, source, this, quadr, hol);
    }

    public void findBlockLightSources(class_1923 chunkPos, BiConsumer<class_2338, class_2680> consumer) {
        this.getCachedChunk(chunkPos.field_9181, chunkPos.field_9180).method_51524(consumer);
    }

    @FunctionalInterface
    public static interface ITaskCacheFactory {
        public TaskCache create(int var1, int var2, int var3, int var4, int var5, int var6);

        default public TaskCache createWithRange(int x, int y, int z, int range) {
            return this.create(x - range, y - range, z - range, x + range, y + range, z + range);
        }

        default public TaskCache createWithRange(Vector3i xyz, int range) {
            return this.createWithRange(xyz.x, xyz.y, xyz.z, range);
        }

        default public TaskCache createWithRange(class_2338 xyz, int range) {
            return this.createWithRange(xyz.method_10263(), xyz.method_10264(), xyz.method_10260(), range);
        }

        default public TaskCache createWithQuadrant(int x, int y, int z, int range, Quadrant quadrant) {
            int x2 = x + quadrant.axis1.x * range;
            int y2 = y + quadrant.axis2.y * range;
            int z2 = z + quadrant.axis3.z * range;
            return this.create(Math.min(x, x2), Math.min(y, y2), Math.min(z, z2), Math.max(x, x2), Math.max(y, y2), Math.max(z, z2));
        }

        default public TaskCache createWithQuadrant(Vector3i xyz, int range, Quadrant quadrant) {
            return this.createWithQuadrant(xyz.x, xyz.y, xyz.z, range, quadrant);
        }
    }
}

