/*
 * Decompiled with CFR 0.152.
 */
package teluri.mods.jlrays.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.class_4970;
import teluri.mods.jlrays.JustLikeRays;
import teluri.mods.jlrays.config.LightPropertiesPatch;

public class BlockConfig {
    private static BlockConfig settings = null;
    public final HashMap<String, ArrayList<Consumer<class_4970.class_4971>>> blockstates = new HashMap();
    protected boolean late = false;
    public float maxEmission = 0.0f;

    public static BlockConfig LazyGet() {
        return settings == null ? (settings = new BlockConfig()) : settings;
    }

    public BlockConfig() {
        this.addDefaultPatches();
    }

    private void addDefaultPatches() {
        this.on("block.minecraft.lava").addLightPatch((bs, bsep) -> bsep.setLightBlock(bs.method_26227().method_15771() ? 15 : 0));
    }

    public float getMaxEmission() {
        return this.maxEmission;
    }

    public void notifyInitCache() {
        this.late = true;
    }

    public Builder on(String ... keys) {
        return new Builder(keys);
    }

    public class Builder {
        final String[] keys;

        public Builder(String[] nkeys) {
            this.keys = nkeys;
        }

        public void addPatch(Consumer<class_4970.class_4971> bsmod) {
            if (BlockConfig.this.late) {
                JustLikeRays.LOGGER.warn("config modified after blockstates init started, consider using an entrypoint of type \"jlr-config\"");
            }
            for (String key : this.keys) {
                BlockConfig.this.blockstates.computeIfAbsent(key, v -> new ArrayList()).add(bsmod);
            }
        }

        public void addLightPatch(LightPropertiesPatch bsmod) {
            this.addPatch(bsmod);
        }
    }
}

