/*
 * Decompiled with CFR 0.152.
 */
package teluri.mods.jlrays.light.sight;

import java.util.function.Consumer;
import java.util.stream.Stream;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import teluri.mods.jlrays.light.sight.misc.AlphaHolder;
import teluri.mods.jlrays.light.sight.misc.ISightUpdateConsumer;
import teluri.mods.jlrays.light.sight.misc.Quadrant;

public class FbGbvSightEngine {
    private static final int[] SIGNS = new int[]{1, -1};
    private static final Vector3i X = new Vector3i(1, 0, 0);
    private static final Vector3i Y = new Vector3i(0, 1, 0);
    private static final Vector3i Z = new Vector3i(0, 0, 1);
    public static final Quadrant[] QUADRANTS = new Quadrant[8];
    public static final float UNPOINTLIGHT_FIX = 0.5f;

    public static float interpolate(float val1, float w1, float val2, float w2, float val3, float w3) {
        return (val1 * w1 + val2 * w2 + val3 * w3) / (w1 + w2 + w3);
    }

    public static boolean isNotDuplicatedEdge(Quadrant quadr, int itr1, int itr2, int itr3) {
        return !(itr1 == 0 && 0 > quadr.axis1.x || itr2 == 0 && 0 > quadr.axis2.y || itr3 == 0 && 0 > quadr.axis3.z);
    }

    public static float facesToVolumeValue(float val1, float w1, float val2, float w2, float val3, float w3) {
        return FbGbvSightEngine.interpolate(val1, w1, val2, w2, val3, w3);
    }

    public static void forEachQuadrants(Consumer<Quadrant> step) {
        ((Stream)Stream.of(QUADRANTS).parallel()).forEach(step);
    }

    public static void traceQuadrant(Vector3i origin, int range, Quadrant quadr, AlphaHolder.IAlphaProvider aprov, ISightUpdateConsumer scons, boolean scout) {
        Vector3i vit1 = new Vector3i();
        Vector3i vit2 = new Vector3i();
        Vector3i xyz = new Vector3i();
        AlphaHolder ahol = new AlphaHolder();
        range = Math.max(1, range);
        int size = range + 2;
        float[] vbuffer = new float[size * size * 3];
        int[] lRowVis = new int[size];
        vbuffer[0] = 1.0f;
        vbuffer[1 + size * 3] = 1.0f;
        vbuffer[5] = 1.0f;
        for (int itr1 = 0; itr1 < range; ++itr1) {
            vit1.set((Vector3ic)quadr.axis1).mul(itr1).add((Vector3ic)origin);
            for (int itr2 = 0; itr2 < range; ++itr2) {
                int rowVis;
                vit2.set((Vector3ic)quadr.axis2).mul(itr2).add((Vector3ic)vit1);
                for (int itr3 = rowVis = itr1 + itr2 - 1 >>> 31; itr3 < range; ++itr3) {
                    int index = (itr2 * size + itr3) * 3;
                    float face1 = vbuffer[index + 0];
                    float face2 = vbuffer[index + 1];
                    float face3 = vbuffer[index + 2];
                    if (face1 == 0.0f && face2 == 0.0f && face3 == 0.0f) {
                        vbuffer[index + 1 + size * 3] = 0.0f;
                        vbuffer[index + 2 + 3] = 0.0f;
                        if (lRowVis[itr2 + 1] > itr3 || lRowVis[itr2] > itr3) continue;
                        break;
                    }
                    xyz.set((Vector3ic)quadr.axis3).mul(itr3).add((Vector3ic)vit2);
                    AlphaHolder alpha = aprov.getAlphas(xyz, origin, quadr, ahol);
                    if (alpha.block != 0.0f) {
                        rowVis = itr3;
                    }
                    face1 *= alpha.f1;
                    face2 *= alpha.f2;
                    face3 *= alpha.f3;
                    if (FbGbvSightEngine.isNotDuplicatedEdge(quadr, itr1, itr2, itr3)) {
                        if (scout) {
                            scons.consume(xyz, 1.0f, 1.0f);
                        } else if (alpha.block != 0.0f) {
                            float voxelvisi = FbGbvSightEngine.facesToVolumeValue(face1, itr1, face2, itr2, face3, itr3);
                            scons.consume(xyz, voxelvisi, voxelvisi);
                        }
                    }
                    float f4w1 = Math.max(0.0f, (float)(itr1 - Math.max(itr2, itr3)) + 0.5f);
                    float f5w2 = Math.max(0.0f, (float)(itr2 - Math.max(itr1, itr3)) + 0.5f);
                    float f6w3 = Math.max(0.0f, (float)(itr3 - Math.max(itr1, itr2)) + 0.5f);
                    FbGbvSightEngine.applyFaces456(vbuffer, alpha, index, size, face1, face2, face3, itr1, itr2, itr3, f4w1, f5w2, f6w3);
                }
                lRowVis[itr2 + 1] = rowVis;
            }
        }
    }

    private static void applyFaces456(float[] vbuffer, AlphaHolder alpha, int index, int size, float face1, float face2, float face3, int itr1, int itr2, int itr3, float f4w1, float f5w2, float f6w3) {
        float face4 = 0.0f;
        float face5 = 0.0f;
        float face6 = 0.0f;
        if (alpha.block != 0.0f) {
            face4 = FbGbvSightEngine.interpolate(face1, f4w1, face2, itr2, face3, itr3) * alpha.f4;
            face5 = FbGbvSightEngine.interpolate(face1, itr1, face2, f5w2, face3, itr3) * alpha.f5;
            face6 = FbGbvSightEngine.interpolate(face1, itr1, face2, itr2, face3, f6w3) * alpha.f6;
        }
        vbuffer[index + 0] = face4;
        vbuffer[index + 1 + size * 3] = face5;
        vbuffer[index + 2 + 3] = face6;
    }

    public static void traceChangedQuadrant(Vector3i origin, int range, Quadrant quadr, AlphaHolder.IAlphaChangeProvider aprov, ISightUpdateConsumer sucons, boolean scout) {
        Vector3i vit1 = new Vector3i();
        Vector3i vit2 = new Vector3i();
        Vector3i xyz = new Vector3i();
        AlphaHolder oahol = new AlphaHolder();
        AlphaHolder nahol = new AlphaHolder();
        range = Math.max(1, range);
        int size = range + 2;
        float[] ovbuffer = new float[size * size * 3];
        float[] nvbuffer = new float[size * size * 3];
        int[] lRowsVis = new int[size];
        nvbuffer[0] = 1.0f;
        ovbuffer[0] = 1.0f;
        nvbuffer[1 + size * 3] = 1.0f;
        ovbuffer[1 + size * 3] = 1.0f;
        nvbuffer[5] = 1.0f;
        ovbuffer[5] = 1.0f;
        for (int itr1 = 0; itr1 < range; ++itr1) {
            vit1.set((Vector3ic)quadr.axis1).mul(itr1).add((Vector3ic)origin);
            for (int itr2 = 0; itr2 < range; ++itr2) {
                int rowVis;
                vit2.set((Vector3ic)quadr.axis2).mul(itr2).add((Vector3ic)vit1);
                for (int itr3 = rowVis = itr1 + itr2 - 1 >>> 31; itr3 < range; ++itr3) {
                    int index = (itr2 * size + itr3) * 3;
                    float oface1 = ovbuffer[index + 0];
                    float oface2 = ovbuffer[index + 1];
                    float oface3 = ovbuffer[index + 2];
                    float nface1 = nvbuffer[index + 0];
                    float nface2 = nvbuffer[index + 1];
                    float nface3 = nvbuffer[index + 2];
                    if (oface1 == 0.0f && oface2 == 0.0f && oface3 == 0.0f && nface1 == 0.0f && nface2 == 0.0f && nface3 == 0.0f) {
                        ovbuffer[index + 1 + size * 3] = 0.0f;
                        ovbuffer[index + 2 + 3] = 0.0f;
                        nvbuffer[index + 1 + size * 3] = 0.0f;
                        nvbuffer[index + 2 + 3] = 0.0f;
                        if (lRowsVis[itr2 + 1] > itr3 || lRowsVis[itr2] > itr3) continue;
                        break;
                    }
                    xyz.set((Vector3ic)quadr.axis3).mul(itr3).add((Vector3ic)vit2);
                    aprov.getAlphas(xyz, origin, quadr, oahol, nahol);
                    oface1 *= oahol.f1;
                    oface2 *= oahol.f2;
                    oface3 *= oahol.f3;
                    nface1 *= nahol.f1;
                    nface2 *= nahol.f2;
                    nface3 *= nahol.f3;
                    if (oahol.block != 0.0f || nahol.block != 0.0f) {
                        rowVis = itr3;
                    }
                    if (FbGbvSightEngine.isNotDuplicatedEdge(quadr, itr1, itr2, itr3)) {
                        if (scout) {
                            sucons.consume(xyz, 1.0f, 1.0f);
                        } else if (oahol.block != 0.0f || nahol.block != 0.0f) {
                            float ovoxelvisi = FbGbvSightEngine.facesToVolumeValue(oface1, itr1, oface2, itr2, oface3, itr3);
                            float nvoxelvisi = FbGbvSightEngine.facesToVolumeValue(nface1, itr1, nface2, itr2, nface3, itr3);
                            sucons.consume(xyz, ovoxelvisi, nvoxelvisi);
                        }
                    }
                    float f4w1 = Math.max(0.0f, (float)(itr1 - Math.max(itr2, itr3)) + 0.5f);
                    float f5w2 = Math.max(0.0f, (float)(itr2 - Math.max(itr1, itr3)) + 0.5f);
                    float f6w3 = Math.max(0.0f, (float)(itr3 - Math.max(itr1, itr2)) + 0.5f);
                    FbGbvSightEngine.applyFaces456(ovbuffer, oahol, index, size, oface1, oface2, oface3, itr1, itr2, itr3, f4w1, f5w2, f6w3);
                    FbGbvSightEngine.applyFaces456(nvbuffer, nahol, index, size, nface1, nface2, nface3, itr1, itr2, itr3, f4w1, f5w2, f6w3);
                }
                lRowsVis[itr2 + 1] = rowVis;
            }
        }
    }

    static {
        int index = 0;
        for (int s1 : SIGNS) {
            for (int s2 : SIGNS) {
                for (int s3 : SIGNS) {
                    Vector3i v1 = new Vector3i((Vector3ic)X).mul(s1);
                    Vector3i v2 = new Vector3i((Vector3ic)Y).mul(s2);
                    Vector3i v3 = new Vector3i((Vector3ic)Z).mul(s3);
                    FbGbvSightEngine.QUADRANTS[index] = new Quadrant(v1, v2, v3);
                    ++index;
                }
            }
        }
    }
}

