/*
 * Decompiled with CFR 0.152.
 */
package teluri.mods.jlrays.light;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import teluri.mods.jlrays.config.IDepthHandler;
import teluri.mods.jlrays.light.DynamicDataLayer;

public class ShortDataLayer
extends DynamicDataLayer {
    protected short[] data;

    public ShortDataLayer() {
    }

    public ShortDataLayer(int defaultvalue) {
        super(defaultvalue);
    }

    public ShortDataLayer(byte[] ndata) {
        super(ndata);
    }

    public ShortDataLayer(short[] ndata) {
        this(0);
        int wantedSize = 4096;
        int receivedSize = ndata.length;
        if (receivedSize == wantedSize) {
            this.data = ndata;
        } else {
            ShortDataLayer.warnForIncorrectSize(wantedSize, receivedSize);
        }
    }

    @Override
    public ShortDataLayer copy() {
        return this.data == null ? new ShortDataLayer(this.field_44635) : new ShortDataLayer((short[])this.data.clone());
    }

    @Override
    public int getDyn(int index) {
        return this.data[index] & 0xFFFF;
    }

    @Override
    public void setDyn(int index, int value) {
        this.data[index] = (short)Math.clamp((long)value, 0, 65535);
    }

    @Override
    public boolean isEmptyDyn() {
        return this.data == null;
    }

    @Override
    public void initDyn() {
        if (this.data == null) {
            this.data = new short[4096];
            if (this.field_44635 != 0) {
                Arrays.fill(this.data, (short)this.field_44635);
            }
        }
    }

    @Override
    public byte[] getData2() {
        byte[] rtn = new byte[8192];
        int itr = 0;
        for (short bytes2 : this.data) {
            rtn[itr + 0] = (byte)bytes2;
            rtn[itr + 1] = (byte)(bytes2 >>> 8);
            itr += 2;
        }
        return rtn;
    }

    @Override
    protected void initDyn(byte[] ndata) {
        this.data = new short[4096];
        for (int itr = 0; itr < this.data.length; ++itr) {
            int itr2 = itr * 2;
            int b0 = ndata[itr2 + 0] & 0xFF;
            int b1 = ndata[itr2 + 1] & 0xFF;
            this.data[itr] = (short)(b0 | b1 << 8);
        }
    }

    @Override
    protected int getNibbleCount() {
        return 4;
    }

    public static class ShortDataLayerFactory
    implements IDepthHandler {
        private static final class_9139<ByteBuf, byte[]> SHORT_DATA_LAYER_STREAM_CODEC = class_9135.method_56895((int)8192);

        @Override
        public class_9139<ByteBuf, byte[]> getCodec() {
            return SHORT_DATA_LAYER_STREAM_CODEC;
        }

        @Override
        public DynamicDataLayer createDataLayer() {
            return new ShortDataLayer();
        }

        @Override
        public DynamicDataLayer createDataLayer(byte[] data) {
            return new ShortDataLayer(data);
        }

        @Override
        public DynamicDataLayer createDataLayer(int defaultval) {
            return new ShortDataLayer(defaultval);
        }

        @Override
        public int getNibbleCount() {
            return 4;
        }
    }
}

