/*
 * Decompiled with CFR 0.152.
 */
package teluri.mods.jlrays.light;

import net.minecraft.class_2804;
import teluri.mods.jlrays.JustLikeRays;
import teluri.mods.jlrays.config.JlrConfig;
import teluri.mods.jlrays.util.ToneMapperHelper;

public abstract class DynamicDataLayer
extends class_2804 {
    public static final int SIZE = 4096;
    public static final int HALF_SIZE = 2048;
    public final int precision;

    public DynamicDataLayer() {
        this(0);
    }

    public DynamicDataLayer(int defaultvalue) {
        super(defaultvalue);
        this.precision = JlrConfig.LazyGet().precision;
    }

    public DynamicDataLayer(byte[] ndata) {
        this(0);
        int wantedSize = 2048 * this.getNibbleCount();
        int receivedSize = ndata.length;
        if (receivedSize == wantedSize) {
            this.initDyn(ndata);
        } else {
            DynamicDataLayer.warnForIncorrectSize(wantedSize, receivedSize);
        }
    }

    public static void warnForIncorrectSize(int wanted, int length) {
        String msg = String.format("ByteDataLayer should be %d bytes not %d, defaulting to empty but something went wrong so clear world cache", wanted, length);
        JustLikeRays.LOGGER.warn(msg);
    }

    public int method_12139(int x, int y, int z) {
        return this.method_12141(DynamicDataLayer.getIndex(x, y, z));
    }

    public void method_12145(int x, int y, int z, int value) {
        this.method_12142(DynamicDataLayer.getIndex(x, y, z), value);
    }

    public void add(int x, int y, int z, int value) {
        this.add(DynamicDataLayer.getIndex(x, y, z), value);
    }

    public int method_12141(int index) {
        return this.isEmptyDyn() ? this.field_44635 : (int)ToneMapperHelper.clamp(this.getFull(index) * (float)(1 >> this.precision));
    }

    public float getFull(int x, int y, int z) {
        return this.getFull(DynamicDataLayer.getIndex(x, y, z));
    }

    public float getFull(int index) {
        return this.isEmptyDyn() ? (float)this.field_44635 : (float)this.getDyn(index);
    }

    public void method_12142(int index, int value) {
        this.initDyn();
        this.setDyn(index, value);
    }

    public byte[] method_12137() {
        this.initDyn();
        return this.getData2();
    }

    public abstract byte[] getData2();

    public abstract DynamicDataLayer copy();

    public void add(int index, int value) {
        this.initDyn();
        this.setDyn(index, value += this.getDyn(index));
    }

    public static int getIndex(int x, int y, int z) {
        return class_2804.method_12140((int)x, (int)y, (int)z);
    }

    public abstract int getDyn(int var1);

    public abstract void setDyn(int var1, int var2);

    public abstract boolean isEmptyDyn();

    public abstract void initDyn();

    protected abstract void initDyn(byte[] var1);

    protected abstract int getNibbleCount();
}

