/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.api.datapack;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.RecordBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;

public class ServantExtraData {
    private static final Map<ResourceLocation, DataType<?>> REGISTRY = new HashMap();
    public static final DataType<Float> LANCELOT_REFLECT_CHANCE = ServantExtraData.register("fateubw", "lancelot_reflect_chance", Codec.FLOAT, Float.valueOf(0.4f));
    public static final DataType<Integer> HASSAN_COPIES = ServantExtraData.register("fateubw", "hassan_copies", Codec.INT, 4);
    public static final DataType<Integer> MEDEA_CIRCLE_DURATION = ServantExtraData.register("fateubw", "medea_circle_duration", ExtraCodecs.POSITIVE_INT, 2000);
    public static final DataType<Float> MEDEA_CIRCLE_RANGE = ServantExtraData.register("fateubw", "medea_circle_range", Codec.FLOAT, Float.valueOf(24.0f));
    public static final DataType<Integer> GILLES_MONSTER_DURATION = ServantExtraData.register("fateubw", "gilles_monster_duration", ExtraCodecs.POSITIVE_INT, 6000);
    public static final DataType<Integer> GILLES_MONSTER_MAX = ServantExtraData.register("fateubw", "gilles_monster_max", ExtraCodecs.NON_NEGATIVE_INT, 7);
    public static final DataType<Float> GILLES_TENTACLE_DAMAGE = ServantExtraData.register("fateubw", "gilles_tentacle_damage", Codec.FLOAT, Float.valueOf(15.0f));
    public static final DataType<Integer> HERACLES_DEATH_MAX = ServantExtraData.register("fateubw", "heracles_death_max", ExtraCodecs.POSITIVE_INT, 2);
    public static final Codec<ServantExtraData> CODEC = new Codec<ServantExtraData>(){

        public <T> DataResult<Pair<ServantExtraData, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(map -> {
                ImmutableMap.Builder values = ImmutableMap.builder();
                ArrayList errors = new ArrayList();
                map.entries().forEach(pair -> {
                    DataResult val = ResourceLocation.CODEC.parse(ops, pair.getFirst()).flatMap(id -> {
                        DataType<?> type = REGISTRY.get(id);
                        if (type == null) {
                            return DataResult.error(() -> "No such type " + String.valueOf(id));
                        }
                        DataResult value = type.codec.parse(ops, pair.getSecond());
                        return value.map(v -> {
                            values.put((Object)type, v);
                            return Unit.INSTANCE;
                        });
                    });
                    val.error().ifPresent(e -> errors.add(e.message()));
                });
                ServantExtraData extraData = new ServantExtraData((Map<DataType<?>, Object>)values.build());
                if (!errors.isEmpty()) {
                    return DataResult.error(() -> "Error during parsing: " + String.join((CharSequence)"\n", errors), (Object)extraData);
                }
                return DataResult.success((Object)extraData);
            }).map(r -> Pair.of((Object)r, (Object)input));
        }

        public <T> DataResult<T> encode(ServantExtraData input, DynamicOps<T> ops, T prefix) {
            RecordBuilder builder = ops.mapBuilder();
            for (DataType<?> type : input.values.keySet()) {
                builder.add(ResourceLocation.CODEC.encodeStart(ops, (Object)type.id()), input.encode(ops, type));
            }
            return builder.build(prefix);
        }
    };
    private final Map<DataType<?>, Object> values;

    public static synchronized <T> DataType<T> register(String namespace, String path, Codec<T> codec, T defaultValue) {
        DataType<T> type = new DataType<T>(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path), codec, defaultValue);
        if (REGISTRY.put(type.id(), type) != null) {
            throw new IllegalStateException("Type with " + String.valueOf(type.id()) + " already registered");
        }
        return type;
    }

    public ServantExtraData(Map<DataType<?>, Object> map) {
        this.values = map;
    }

    public <T> T get(DataType<T> type) {
        Object val = this.values.get(type);
        if (val == null) {
            return type.defaultValue();
        }
        return (T)val;
    }

    public boolean empty() {
        return this.values.isEmpty();
    }

    private <R, T> DataResult<R> encode(DynamicOps<R> ops, DataType<T> type) {
        return type.codec.encodeStart(ops, this.get(type));
    }

    public record DataType<T>(ResourceLocation id, Codec<T> codec, T defaultValue) {
        public DataType(String namespace, String path, Codec<T> codec, T defaultValue) {
            this(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path), codec, defaultValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof DataType)) return false;
            DataType other = (DataType)obj;
            if (!this.id.equals((Object)other.id)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.id.hashCode();
        }

        @Override
        @NotNull
        public String toString() {
            return this.id.toString();
        }
    }
}

