/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.api.datapack;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.fateubw.api.datapack.ServantExtraData;
import io.github.flemmli97.fateubw.common.lib.BuiltinServantClasses;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;

public record ServantProperties(Map<Holder<Attribute>, Double> attributes, int manaCost, int weight, ResourceLocation servantClass, Optional<ServantExtraData> extraData) {
    public static final Codec<ServantProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)BuiltInRegistries.ATTRIBUTE.holderByNameCodec(), (Codec)Codec.DOUBLE).fieldOf("attributes").forGetter(d -> d.attributes), (App)Codec.INT.fieldOf("nobel_phantasm_cost").forGetter(ServantProperties::manaCost), (App)Codec.INT.fieldOf("weight").forGetter(ServantProperties::weight), (App)ResourceLocation.CODEC.fieldOf("class").forGetter(ServantProperties::servantClass), (App)ServantExtraData.CODEC.optionalFieldOf("configs").forGetter(d -> d.extraData.flatMap(ex -> ex.empty() ? Optional.empty() : Optional.of(ex)))).apply((Applicative)instance, ServantProperties::new));
    public static final ServantProperties DEFAULT = new Builder(BuiltinServantClasses.NONE).putAttributes((Holder<Attribute>)Attributes.MAX_HEALTH, 20.0).putAttributes((Holder<Attribute>)Attributes.ATTACK_DAMAGE, 1.0).putAttributes((Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.2).putAttributes((Holder<Attribute>)FateAttributes.MAGIC_ATTACK.asHolder(), 1.0).build();

    public ServantProperties(Map<Holder<Attribute>, Double> attributes, int manaCost, int weight, ResourceLocation servantClass, Optional<ServantExtraData> extraData) {
        this.attributes = ImmutableMap.copyOf(attributes);
        this.manaCost = manaCost;
        this.weight = weight;
        this.servantClass = servantClass;
        this.extraData = extraData;
    }

    public <T> T getConfig(ServantExtraData.DataType<T> type) {
        return (T)this.extraData.map(d -> d.get(type)).orElse(type.defaultValue());
    }

    public static class Builder {
        private final Map<Holder<Attribute>, Double> attributes = new HashMap<Holder<Attribute>, Double>();
        private int manaCost;
        private int weight = 1;
        private final ResourceLocation servantClass;
        private final Map<ServantExtraData.DataType<?>, Object> values = new HashMap();

        public Builder(ResourceLocation servantClass) {
            this.servantClass = servantClass;
        }

        public Builder putAttributes(Holder<Attribute> att, double val) {
            this.attributes.put(att, val);
            return this;
        }

        public Builder npCost(int manaCost) {
            this.manaCost = manaCost;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public <T> Builder withConfigData(ServantExtraData.DataType<T> type) {
            return this.withConfigData(type, type.defaultValue());
        }

        public <T> Builder withConfigData(ServantExtraData.DataType<T> type, T value) {
            this.values.put(type, value);
            return this;
        }

        public ServantProperties build() {
            return new ServantProperties(this.attributes, this.manaCost, this.weight, this.servantClass, this.values.isEmpty() ? Optional.empty() : Optional.of(new ServantExtraData(this.values)));
        }
    }
}

