/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.api.entity;

import io.github.flemmli97.fateubw.api.datapack.ServantProperties;
import io.github.flemmli97.fateubw.api.entity.CommandType;
import io.github.flemmli97.fateubw.common.world.GrailWarHandler;
import java.util.Comparator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface ServantLike<T extends Mob>
extends OwnableEntity {
    public static final TicketType<ChunkPos> TRACKINGTICKET = TicketType.create((String)"servant", Comparator.comparingLong(ChunkPos::toLong), (int)5);

    default public T get() {
        return (T)((Mob)this);
    }

    default public void trackingTick() {
        ServerLevel serverLevel;
        GrailWarHandler handler;
        T entity = this.get();
        Level level = entity.level();
        if (level instanceof ServerLevel && (handler = GrailWarHandler.get((serverLevel = (ServerLevel)level).getServer())).isParticipant((Entity)entity)) {
            ChunkPos pos = entity.chunkPosition();
            ((ServerChunkCache)entity.level().getChunkSource()).addRegionTicket(TRACKINGTICKET, pos, 2, (Object)pos);
            handler.moveToPlayer((ServantLike)entity);
        }
    }

    @Nullable
    public Player getOwner();

    public void setOwner(Player var1);

    public ServantProperties props();

    public Component nobelPhantasm();

    public void onPlayerCommand(ServerPlayer var1, CommandType var2);

    default public String[] specialCommands() {
        return null;
    }

    default public void doSpecialCommand(ServerPlayer sender, String id) {
    }

    public void shouldScheduleEntityDataSync(boolean var1);
}

