/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public class AttackBBRender {
    private static final float[] ATTACK_RGB = new float[]{0.07058824f, 0.70980394f, 0.2f};
    private static final float[] ATTEMPT_RGB = new float[]{0.07450981f, 0.21960784f, 0.7490196f};
    public static final AttackBBRender INST = new AttackBBRender();
    private final List<RenderOBB> list = new ArrayList<RenderOBB>();
    private final List<RenderOBB> toAdd = new ArrayList<RenderOBB>();

    public void addNewAABB(OrientedBoundingBox aabb, int duration, S2CAttackDebug.EnumAABBType type) {
        this.toAdd.add(new RenderOBB(aabb, duration, type));
    }

    public void render(PoseStack stack, MultiBufferSource.BufferSource buffer) {
        this.list.addAll(this.toAdd);
        this.toAdd.clear();
        this.list.removeIf(r -> r.render(stack, (MultiBufferSource)buffer));
        buffer.endBatch((RenderType)RenderType.LINES);
    }

    private static class RenderOBB {
        private final OrientedBoundingBox obb;
        private final S2CAttackDebug.EnumAABBType type;
        private int duration;

        public RenderOBB(OrientedBoundingBox aabb, int duration, S2CAttackDebug.EnumAABBType type) {
            this.obb = aabb;
            this.duration = duration;
            this.type = type;
        }

        public boolean render(PoseStack stack, MultiBufferSource buffer) {
            float[] color = this.type == S2CAttackDebug.EnumAABBType.ATTEMPT ? ATTEMPT_RGB : ATTACK_RGB;
            RenderUtils.renderOBB((PoseStack)stack, (MultiBufferSource)buffer, (OrientedBoundingBox)this.obb, (float)color[0], (float)color[1], (float)color[2], (float)1.0f, (boolean)false);
            return this.duration-- < 0;
        }
    }
}

