/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.client.ClientHandler;
import io.github.flemmli97.fateubw.client.ItemModelProps;
import io.github.flemmli97.fateubw.client.model.MedeaModel;
import io.github.flemmli97.fateubw.client.model.ServantModel;
import io.github.flemmli97.fateubw.client.particles.RingParticle;
import io.github.flemmli97.fateubw.client.particles.TrailParticle;
import io.github.flemmli97.fateubw.client.render.RenderEmpty;
import io.github.flemmli97.fateubw.client.render.ServantRenderer;
import io.github.flemmli97.fateubw.client.render.layer.PetrificationLayer;
import io.github.flemmli97.fateubw.client.render.misc.EmptyRender;
import io.github.flemmli97.fateubw.client.render.misc.RenderArcherArrow;
import io.github.flemmli97.fateubw.client.render.misc.RenderBabylon;
import io.github.flemmli97.fateubw.client.render.misc.RenderCaladbolg;
import io.github.flemmli97.fateubw.client.render.misc.RenderChainDagger;
import io.github.flemmli97.fateubw.client.render.misc.RenderEA;
import io.github.flemmli97.fateubw.client.render.misc.RenderEnkiduChains;
import io.github.flemmli97.fateubw.client.render.misc.RenderExcalibur;
import io.github.flemmli97.fateubw.client.render.misc.RenderGaeBolg;
import io.github.flemmli97.fateubw.client.render.misc.RenderGem;
import io.github.flemmli97.fateubw.client.render.misc.RenderGordius;
import io.github.flemmli97.fateubw.client.render.misc.RenderHassanCopy;
import io.github.flemmli97.fateubw.client.render.misc.RenderMagicBeam;
import io.github.flemmli97.fateubw.client.render.misc.RenderPegasus;
import io.github.flemmli97.fateubw.client.render.misc.RenderStarfish;
import io.github.flemmli97.fateubw.client.render.misc.RenderTentacle;
import io.github.flemmli97.fateubw.client.render.misc.RenderThrownItem;
import io.github.flemmli97.fateubw.client.render.servant.MedusaRenderer;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.registry.FateBlocks;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.tenshilib.client.particles.TranslucentAddParticle;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ClientRegister {
    public static void registerKeyBinding(Consumer<KeyMapping> consumer) {
        ClientHandler.gui = new KeyMapping("fateubw.key.gui", 72, "fateubw.keycategory");
        consumer.accept(ClientHandler.gui);
        ClientHandler.special = new KeyMapping("fateubw.key.np", 74, "fateubw.keycategory");
        consumer.accept(ClientHandler.special);
        ClientHandler.boost = new KeyMapping("fateubw.key.boost", 78, "fateubw.keycategory");
        consumer.accept(ClientHandler.boost);
        ClientHandler.target = new KeyMapping("fateubw.key.target", 66, "fateubw.keycategory");
        consumer.accept(ClientHandler.target);
    }

    public static void registerItemProps(ItemModelPropsRegister register) {
        register.register((Item)FateItems.EXCALIBUR.get(), ItemModelProps.ACTIVE_ID, ItemModelProps.ACTIVE_ITEM_PROP);
        register.register((Item)FateItems.MEDUSA_DAGGER.get(), ItemModelProps.THROWN_DAGGER_ID, ItemModelProps.THROWN_DAGGER_PROP);
        register.register((Item)FateItems.EMIYAS_BOW.get(), ItemModelProps.BOW_PULL_ID, ItemModelProps.BOW_PULL_PROP);
        register.register((Item)FateItems.EMIYAS_BOW.get(), ItemModelProps.CALADBOLG_ID, ItemModelProps.CALADBOLG_CHARGE);
        register.register((Item)FateItems.GAEDEARG.get(), ItemModelProps.UNSEALED_ID, ItemModelProps.UNSEALED_PROP);
        register.register((Item)FateItems.GAEBUIDHE.get(), ItemModelProps.UNSEALED_ID, ItemModelProps.UNSEALED_PROP);
    }

    public static void setupRenderLayers(BiConsumer<Block, RenderType> consumer) {
        consumer.accept((Block)FateBlocks.ALTAR.get(), RenderType.cutout());
        consumer.accept((Block)FateBlocks.GEM_ORE.get(), RenderType.cutout());
        consumer.accept((Block)FateBlocks.ARTIFACT_ORE.get(), RenderType.cutout());
        consumer.accept((Block)FateBlocks.DEEP_SLATE_GEM_ORE.get(), RenderType.cutout());
        consumer.accept((Block)FateBlocks.DEEP_SLATE_ARTIFACT_ORE.get(), RenderType.cutout());
        consumer.accept((Block)FateBlocks.CHALK.get(), RenderType.cutout());
    }

    public static void registerRenderers(EntityRendererRegister consumer) {
        ClientRegister.registerServant(consumer, FateEntities.ARTHUR);
        ClientRegister.registerServant(consumer, FateEntities.CUCHULAINN);
        ClientRegister.registerServant(consumer, FateEntities.DIARMUID);
        ClientRegister.registerServant(consumer, FateEntities.EMIYA);
        ClientRegister.registerServant(consumer, FateEntities.GILGAMESH);
        consumer.register((EntityType)FateEntities.MEDEA.get(), manager -> new ServantRenderer(manager, new MedeaModel(), ClientRegister.servantTexture(FateEntities.MEDEA), 0.5f));
        ClientRegister.registerServant(consumer, FateEntities.GILLES);
        ClientRegister.registerServant(consumer, FateEntities.HERACLES, 1.0f);
        ClientRegister.registerServant(consumer, FateEntities.LANCELOT, 0.5f);
        ClientRegister.registerServant(consumer, FateEntities.ISKANDER, 0.5f);
        consumer.register((EntityType)FateEntities.MEDUSA.get(), MedusaRenderer::new);
        ClientRegister.registerServant(consumer, FateEntities.HASSAN);
        ClientRegister.registerServant(consumer, FateEntities.SASAKI);
        consumer.register((EntityType)FateEntities.EXCALIBUR.get(), RenderExcalibur::new);
        consumer.register((EntityType)FateEntities.GAEBOLG.get(), RenderGaeBolg::new);
        consumer.register((EntityType)FateEntities.ARCHER_ARROW.get(), RenderArcherArrow::new);
        consumer.register((EntityType)FateEntities.CALADBOLG.get(), RenderCaladbolg::new);
        consumer.register((EntityType)FateEntities.BABYLON.get(), RenderBabylon::new);
        consumer.register((EntityType)FateEntities.EA.get(), RenderEA::new);
        consumer.register((EntityType)FateEntities.MAGIC_BEAM.get(), RenderMagicBeam::new);
        consumer.register((EntityType)FateEntities.MEDEA_CIRCLE.get(), RenderEmpty::new);
        consumer.register((EntityType)FateEntities.GORDIUS_WHEEL.get(), RenderGordius::new);
        consumer.register((EntityType)FateEntities.THROWN_ITEM.get(), RenderThrownItem::new);
        consumer.register((EntityType)FateEntities.GEM.get(), RenderGem::new);
        consumer.register((EntityType)FateEntities.MAGIC_SHOT.get(), EmptyRender::new);
        consumer.register((EntityType)FateEntities.TENTACLE.get(), RenderTentacle::new);
        consumer.register((EntityType)FateEntities.STARFISH_SHOT.get(), EmptyRender::new);
        consumer.register((EntityType)FateEntities.ENKIDU_CHAINS.get(), RenderEnkiduChains::new);
        consumer.register((EntityType)FateEntities.LESSER_MONSTER.get(), RenderStarfish::new);
        consumer.register((EntityType)FateEntities.HASSAN_COPY.get(), RenderHassanCopy::new);
        consumer.register((EntityType)FateEntities.PEGASUS.get(), RenderPegasus::new);
        consumer.register((EntityType)FateEntities.DAGGER_HOOK.get(), RenderChainDagger::new);
        consumer.register((EntityType)FateEntities.MULTIPART.get(), EmptyRender::new);
        consumer.register((EntityType)FateEntities.GORDIUS_CHARIOT.get(), EmptyRender::new);
    }

    private static <T extends BaseServant> void registerServant(EntityRendererRegister consumer, RegistryEntrySupplier<EntityType<?>, EntityType<T>> reg) {
        ClientRegister.registerServant(consumer, reg, 0.5f);
    }

    private static <T extends BaseServant> void registerServant(EntityRendererRegister consumer, RegistryEntrySupplier<EntityType<?>, EntityType<T>> reg, float shadow) {
        consumer.register((EntityType)reg.get(), manager -> new ServantRenderer(manager, new ServantModel(ClientRegister.servantLocation(reg)), ClientRegister.servantTexture(reg), shadow));
    }

    public static <T extends Entity> ResourceLocation servantLocation(RegistryEntrySupplier<EntityType<?>, EntityType<T>> reg) {
        return Fate.modRes("servant/" + reg.getID().getPath());
    }

    public static <T extends Entity> ResourceLocation servantTexture(RegistryEntrySupplier<EntityType<?>, EntityType<T>> reg) {
        return Fate.modRes("textures/entity/servant/" + reg.getID().getPath() + ".png");
    }

    public static void registerParticles(PartileRegister consumer) {
        consumer.register((ParticleType)FateParticles.LIGHT.get(), TranslucentAddParticle.Factory::new);
        consumer.register((ParticleType)FateParticles.TRAIL.get(), TrailParticle.Factory::new);
        consumer.register((ParticleType)FateParticles.RING.get(), RingParticle.Factory::new);
        consumer.register((ParticleType)FateParticles.FLASH.get(), TranslucentAddParticle.Factory::new);
    }

    public static <T extends LivingEntity> void addLayersTo(LivingEntityRenderer<T, ?> renderer, Consumer<RenderLayer<T, ?>> layerConsumer) {
        layerConsumer.accept(new PetrificationLayer(renderer));
    }

    public static interface ItemModelPropsRegister {
        public void register(Item var1, ResourceLocation var2, ClampedItemPropertyFunction var3);
    }

    public static interface EntityRendererRegister {
        public <T extends Entity> void register(EntityType<? extends T> var1, EntityRendererProvider<T> var2);
    }

    public static interface PartileRegister {
        public <T extends ParticleOptions> void register(ParticleType<T> var1, Function<SpriteSet, ParticleProvider<T>> var2);
    }
}

