/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.gui;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.network.C2SGrailReward;
import io.github.flemmli97.tenshilib.client.gui.widget.TexturedButton;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class GuiHolyGrail
extends Screen {
    private static final ResourceLocation TEX = Fate.modRes("textures/gui/grail_reward.png");
    private static final WidgetSprites ENTRY_WIDGET = new WidgetSprites(Fate.modRes("widget/grail_reward_entry"), Fate.modRes("widget/grail_reward_entry_highlighted"));
    private static final WidgetSprites NEXT_WIDGET = new WidgetSprites(Fate.modRes("widget/button_right"), Fate.modRes("widget/button_right_highlighted"));
    private static final WidgetSprites PREVIOUS_WIDGET = new WidgetSprites(Fate.modRes("widget/button_left"), Fate.modRes("widget/button_left_highlighted"));
    private final Map<ResourceLocation, Component> rewards;
    private int page;
    private static final int X_SIZE = 255;
    private static final int Y_SIZE = 186;

    public GuiHolyGrail(Map<ResourceLocation, Component> rewards) {
        super((Component)Component.translatable((String)"fateubw.gui.holy_grail"));
        this.rewards = rewards;
    }

    protected void init() {
        super.init();
        List list = this.rewards.entrySet().stream().toList();
        for (int i = 0; i < 7; ++i) {
            int index = this.page * 7 + i;
            if (index >= list.size()) continue;
            Map.Entry val = (Map.Entry)list.get(this.page * 7 + i);
            this.addRenderableWidget((GuiEventListener)new TexturedButton(this.width / 2 - 127 + 6, this.height / 2 - 93 + i * 23 + 6, 243, 20, (Component)val.getValue(), button -> {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SGrailReward((ResourceLocation)val.getKey()));
                this.minecraft.player.closeContainer();
            }).withSprite(ENTRY_WIDGET));
        }
        if (this.page > 0) {
            this.addRenderableWidget((GuiEventListener)new TexturedButton(this.width / 2 - 127 + 220, this.height / 2 - 93 + 167, 13, 13, (Component)Component.empty(), b -> {
                --this.page;
                this.clearWidgets();
                this.init();
            }).withSprite(PREVIOUS_WIDGET));
        }
        if ((this.page + 1) * 7 + 1 <= list.size()) {
            this.addRenderableWidget((GuiEventListener)new TexturedButton(this.width / 2 - 127 + 235, this.height / 2 - 93 + 167, 13, 13, (Component)Component.empty(), b -> {
                ++this.page;
                this.clearWidgets();
                this.init();
            }).withSprite(NEXT_WIDGET));
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blit(TEX, this.width / 2 - 127, this.height / 2 - 93, 0, 0, 255, 186);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

