/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.gui;

import io.github.flemmli97.fateubw.common.components.ServantSpawneggData;
import io.github.flemmli97.fateubw.common.network.C2SSpawnEgg;
import io.github.flemmli97.fateubw.common.registry.FateDataComponents;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SpawnEggScreen
extends Screen {
    private final Player player;
    protected LivingEntity entity;
    private final InteractionHand hand;
    private int leftPos;
    private int topPos;
    private final int sizeX = 240;
    private final int sizeY = 200;
    private Checkbox withMasterCheckbox;
    private Checkbox warCheckBox;
    private boolean withMaster;
    private boolean joinWar;

    public SpawnEggScreen(InteractionHand hand) {
        super((Component)Component.empty());
        this.hand = hand;
        this.player = Minecraft.getInstance().player;
    }

    protected void init() {
        LivingEntity living;
        super.init();
        ItemStack stack = this.player.getItemInHand(this.hand);
        Item item = stack.getItem();
        if (!(item instanceof SpawnEgg)) {
            Minecraft.getInstance().setScreen(null);
            return;
        }
        SpawnEgg egg = (SpawnEgg)item;
        EntityType type = egg.getType(stack);
        Entity e = type.create((Level)Minecraft.getInstance().level);
        if (!(e instanceof LivingEntity)) {
            Minecraft.getInstance().setScreen(null);
            return;
        }
        this.entity = living = (LivingEntity)e;
        ServantSpawneggData data = (ServantSpawneggData)stack.getOrDefault((DataComponentType)FateDataComponents.SERVANT_EGG_DATA.get(), (Object)ServantSpawneggData.DEFAULT);
        this.withMaster = data.withMaster();
        this.joinWar = data.joinGrailwar();
        this.leftPos = this.width / 2 - this.sizeX / 2;
        this.topPos = this.height / 2 - this.sizeY / 2;
        this.buttons();
    }

    public void tick() {
        super.tick();
        ++this.entity.tickCount;
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int padding;
        graphics.fillGradient(this.leftPos, this.topPos, this.leftPos + this.sizeX, this.topPos + this.sizeY, -1072689136, -1072689136);
        int yOff = padding = 16;
        graphics.drawString(this.font, (Component)Component.translatable((String)"fateubw.gui.spawn.master"), this.leftPos + padding, this.topPos + yOff, 0xFFFFFF, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"fateubw.gui.spawn.war"), this.leftPos + padding, this.topPos + (yOff += 44), 0xFFFFFF, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"fateubw.gui.spawn.war.help"), this.leftPos + padding, this.topPos + (yOff += 16), 0xFFFFFF, false);
        RenderUtils.renderScaledEntityGui((GuiGraphics)graphics, (float)(this.leftPos + this.sizeX - padding - 96), (float)(this.topPos + padding), (float)96.0f, (float)96.0f, (float)32.0f, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)this.entity);
    }

    protected void buttons() {
        int padding = 16;
        int yOff = padding + 12;
        this.withMasterCheckbox = Checkbox.builder((Component)Component.empty(), (Font)this.font).selected(this.withMaster).pos(this.leftPos + padding, this.topPos + yOff).maxWidth(20).onValueChange((b, a) -> {
            this.withMaster = a;
        }).build();
        this.addRenderableWidget((GuiEventListener)this.withMasterCheckbox);
        this.warCheckBox = Checkbox.builder((Component)Component.empty(), (Font)this.font).selected(this.joinWar).pos(this.leftPos + padding, this.topPos + (yOff += 60)).maxWidth(20).onValueChange((b, a) -> {
            this.joinWar = a;
        }).build();
        this.addRenderableWidget((GuiEventListener)this.warCheckBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"fateubw.gui.save"), b -> {
            LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SSpawnEgg(this.hand, this.withMasterCheckbox.selected(), this.warCheckBox.selected()));
            this.minecraft.setScreen(null);
        }).bounds(this.leftPos + this.sizeX / 2 - 50, this.topPos + (yOff += 80), 100, 20).build());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

