/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.network.C2STeamMessage;
import io.github.flemmli97.fateubw.common.network.C2STeamUuidMessage;
import io.github.flemmli97.fateubw.common.world.GrailTeam;
import io.github.flemmli97.tenshilib.client.gui.widget.TexturedButton;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableListWidget;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableText;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class TeamGui
extends Screen {
    private static final ResourceLocation WIDGETS = Fate.modRes("textures/gui/widgets.png");
    private static final WidgetSprites ACCEPT = new WidgetSprites(Fate.modRes("icon/team/accept"), Fate.modRes("icon/team/accept_highlighted"));
    private static final WidgetSprites DEMOTE = new WidgetSprites(Fate.modRes("icon/team/demote"), Fate.modRes("icon/team/demote_highlighted"));
    private static final WidgetSprites DENY = new WidgetSprites(Fate.modRes("icon/team/deny"), Fate.modRes("icon/team/deny_highlighted"));
    private static final WidgetSprites INVITE = new WidgetSprites(Fate.modRes("icon/team/invite"), Fate.modRes("icon/team/invite_highlighted"));
    private static final WidgetSprites PROMOTE = new WidgetSprites(Fate.modRes("icon/team/promote"), Fate.modRes("icon/team/promote_highlighted"));
    private static final WidgetSprites UNDO = new WidgetSprites(Fate.modRes("icon/team/undo"), Fate.modRes("icon/team/undo_highlighted"));
    private static final WidgetSprites BACK = new WidgetSprites(Fate.modRes("widget/button_back"), Fate.modRes("widget/button_back_disabled"), Fate.modRes("widget/button_back_highlighted"));
    private int leftPos;
    private int topPos;
    private GrailTeam.ClientTeamInfo info;
    private boolean admin;
    private Pages page = Pages.MAIN;
    private int sizeX;
    private int sizeY;
    @Nullable
    private EditBox box;
    private Button leaveButton;

    public TeamGui(GrailTeam.ClientTeamInfo info) {
        super((Component)Component.translatable((String)"fateubw.gui.team"));
        this.sizeX = Pages.MAIN.sizeX;
        this.sizeY = Pages.MAIN.sizeY;
        this.update(info, false);
    }

    private void changePage(Pages page) {
        this.page = page;
        this.clearWidgets();
        this.init();
    }

    protected void init() {
        int padding;
        super.init();
        this.sizeX = this.page.sizeX;
        this.sizeY = this.page.sizeY;
        this.leftPos = this.width / 2 - this.sizeX / 2;
        this.topPos = this.height / 2 - this.sizeY / 2;
        int y = padding = 12;
        switch (this.page.ordinal()) {
            case 0: {
                int x = this.leftPos + this.sizeX / 2 - 40;
                if (this.info.team().isPresent()) {
                    GrailTeam.ShortTeamInfo team = this.info.team().get();
                    y = this.topPos + 12 + 24;
                    Button invite = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"fateubw.gui.team.invites"), b -> this.changePage(Pages.INVITES)).bounds(x, y, 80, 20).build());
                    invite.active = team.admin();
                    this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"fateubw.gui.team.allies"), b -> this.changePage(Pages.ALLIES)).bounds(x, y += 24, 80, 20).build());
                    this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"fateubw.gui.team.members"), b -> this.changePage(Pages.MEMBERS)).bounds(x, y += 24, 80, 20).build());
                    if (this.admin) {
                        this.box = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, x, this.topPos + 10, 80, 16, (Component)Component.empty()));
                        this.box.visible = false;
                    }
                    this.leaveButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)(team.creator().equals(this.minecraft.player.getUUID()) ? "fateubw.gui.team.disband" : "fateubw.gui.team.leave")).withStyle(ChatFormatting.RED), b -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamMessage(C2STeamMessage.Type.LEAVE, ""))).bounds(this.leftPos + this.sizeX - padding - 80, this.topPos + this.sizeY - padding - 20, 80, 20).build());
                    this.leaveButton.active = false;
                    break;
                }
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"fateubw.gui.team.invites"), b -> this.changePage(Pages.INVITES)).bounds(this.leftPos + this.sizeX - padding - 80, this.topPos + y, 80, 20).build());
                y = this.topPos + this.sizeY - padding - 20 - 24;
                this.box = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.leftPos + this.sizeX / 2 - 60, y, 120, 20, (Component)Component.empty()));
                Button create = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"fateubw.gui.team.create"), b -> {
                    LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamMessage(C2STeamMessage.Type.CREATE, this.box.getValue()));
                    b.active = false;
                }).bounds(this.leftPos + this.sizeX / 2 - 60, y += 24, 120, 20).build());
                create.active = false;
                this.box.setResponder(s -> {
                    create.active = !s.isEmpty();
                });
                break;
            }
            case 1: {
                if (this.info.team().isPresent()) {
                    List<Pair> invites = this.info.players().stream().filter(p -> !((GrailTeam.TeamPosition)((Object)((Object)p.getSecond()))).isInTeam()).toList();
                    if (!invites.isEmpty()) {
                        this.addRenderableWidget((GuiEventListener)new SelectableListWidget(this.leftPos + 25, this.topPos + 37, 170, 128, this.font, invites.stream().map(t -> {
                            if (t.getSecond() == GrailTeam.TeamPosition.INVITED) {
                                return new SelectableText("\u23f3 " + ((GameProfile)t.getFirst()).getName(), new ChatFormatting[0]).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.RETRACT_INVITE, ((GameProfile)t.getFirst()).getId())});
                            }
                            return new SelectableText(((GameProfile)t.getFirst()).getName(), new ChatFormatting[]{ChatFormatting.AQUA}).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.INVITE, ((GameProfile)t.getFirst()).getId())});
                        }).toList()).selectMultiple());
                    }
                } else {
                    this.addRenderableWidget((GuiEventListener)new SelectableListWidget(this.leftPos + 25, this.topPos + 37, 170, 128, this.font, this.info.invites().stream().map(t -> new SelectableText(t.name(), new ChatFormatting[0]).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.ACCEPT_INVITE, t.id()), this.getButton(C2STeamUuidMessage.Type.DENY_INVITE, t.id())})).toList()));
                }
                this.addRenderableWidget((GuiEventListener)new TexturedButton(this.leftPos + 8, this.topPos + 8, 20, 20, (Component)Component.empty(), b -> this.changePage(Pages.MAIN)).withSprite(BACK));
                break;
            }
            case 2: {
                this.addRenderableWidget((GuiEventListener)new SelectableListWidget(this.leftPos + 25, this.topPos + 37, 170, 128, this.font, this.info.others().stream().map(t -> {
                    if (t.getSecond() == GrailTeam.TeamStatus.INCOMING_REQUEST) {
                        return new SelectableText("\u2709 " + ((GrailTeam.ShortTeamInfo)t.getFirst()).name(), new ChatFormatting[]{ChatFormatting.GREEN}).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.ACCEPT_ALLY, ((GrailTeam.ShortTeamInfo)t.getFirst()).id()), this.getButton(C2STeamUuidMessage.Type.DENY_ALLY, ((GrailTeam.ShortTeamInfo)t.getFirst()).id())});
                    }
                    if (t.getSecond() == GrailTeam.TeamStatus.OUTGOING_REQUEST) {
                        return new SelectableText("\u23f3 " + ((GrailTeam.ShortTeamInfo)t.getFirst()).name(), new ChatFormatting[0]).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.RETRACT_REQUEST, ((GrailTeam.ShortTeamInfo)t.getFirst()).id())});
                    }
                    if (t.getSecond() == GrailTeam.TeamStatus.ALLY) {
                        return new SelectableText("\ud83d\udee1 " + ((GrailTeam.ShortTeamInfo)t.getFirst()).name(), new ChatFormatting[]{ChatFormatting.AQUA}).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.DISSOLVE_ALLY, ((GrailTeam.ShortTeamInfo)t.getFirst()).id())});
                    }
                    return new SelectableText(((GrailTeam.ShortTeamInfo)t.getFirst()).name(), new ChatFormatting[0]).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.REQUEST_ALLY, ((GrailTeam.ShortTeamInfo)t.getFirst()).id())});
                }).toList()));
                this.addRenderableWidget((GuiEventListener)new TexturedButton(this.leftPos + 8, this.topPos + 8, 20, 20, (Component)Component.empty(), b -> this.changePage(Pages.MAIN)).withSprite(BACK));
                break;
            }
            case 3: {
                List<Pair> members = this.info.players().stream().filter(p -> ((GrailTeam.TeamPosition)((Object)((Object)p.getSecond()))).isInTeam()).toList();
                if (!members.isEmpty()) {
                    this.addRenderableWidget((GuiEventListener)new SelectableListWidget(this.leftPos + 25, this.topPos + 37, 170, 128, this.font, members.stream().map(t -> {
                        if (t.getSecond() == GrailTeam.TeamPosition.ADMIN) {
                            return new SelectableText("\u25c7 " + ((GameProfile)t.getFirst()).getName(), new ChatFormatting[]{ChatFormatting.AQUA}).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.DEMOTE, ((GameProfile)t.getFirst()).getId())});
                        }
                        if (t.getSecond() == GrailTeam.TeamPosition.CREATOR) {
                            return new SelectableText("\u2606 " + ((GameProfile)t.getFirst()).getName(), new ChatFormatting[]{ChatFormatting.GOLD}).noSelect();
                        }
                        return new SelectableText(((GameProfile)t.getFirst()).getName(), new ChatFormatting[0]).with(new SelectableText.SelectButton[]{this.getButton(C2STeamUuidMessage.Type.PROMOTE, ((GameProfile)t.getFirst()).getId()), this.getButton(C2STeamUuidMessage.Type.KICK, ((GameProfile)t.getFirst()).getId())});
                    }).toList()));
                }
                this.addRenderableWidget((GuiEventListener)new TexturedButton(this.leftPos + 8, this.topPos + 8, 20, 20, (Component)Component.empty(), b -> this.changePage(Pages.MAIN)).withSprite(BACK));
            }
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blit(this.page.texture, this.leftPos, this.topPos, 0, 0, this.sizeX, this.sizeY);
        if (this.leaveButton != null) {
            this.leaveButton.active = TeamGui.hasShiftDown();
        }
        if (this.page == Pages.MAIN) {
            if (this.info.team().isPresent()) {
                MutableComponent txt = Component.translatable((String)"fateubw.gui.team.name", (Object[])new Object[]{this.info.team().get().name()});
                int width = this.font.width((FormattedText)txt);
                graphics.drawString(this.font, (Component)txt, this.leftPos + this.sizeX / 2 - width / 2, this.topPos + 15, 0, false);
                if (this.box != null && !this.box.canConsumeInput()) {
                    boolean vis = this.box.visible;
                    this.box.visible = true;
                    if (this.box.isMouseOver((double)mouseX, (double)mouseY)) {
                        graphics.renderTooltip(this.font, (Component)Component.translatable((String)"fateubw.gui.team.rename"), mouseX, mouseY);
                    }
                    this.box.visible = vis;
                }
            } else {
                int y = 0;
                for (FormattedCharSequence lines : this.font.split((FormattedText)Component.translatable((String)"fateubw.gui.team.none"), this.sizeX / 2 - 18)) {
                    graphics.drawString(this.font, lines, this.leftPos + 18, this.topPos + 18 + y * 11, 0, false);
                    ++y;
                }
            }
        } else {
            Component txt = this.page.title;
            int width = this.font.width((FormattedText)txt);
            graphics.drawString(this.font, txt, this.leftPos + this.sizeX / 2 - width / 2, this.topPos + 12, 0, false);
        }
    }

    private SelectableText.SelectButton getButton(C2STeamUuidMessage.Type type, UUID uuid) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case C2STeamUuidMessage.Type.INVITE, C2STeamUuidMessage.Type.REQUEST_ALLY -> new SelectableText.SelectButton(INVITE, () -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamUuidMessage(type, uuid)), () -> this.admin);
            case C2STeamUuidMessage.Type.RETRACT_INVITE, C2STeamUuidMessage.Type.RETRACT_REQUEST -> new SelectableText.SelectButton(UNDO, () -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamUuidMessage(type, uuid)), () -> this.admin);
            case C2STeamUuidMessage.Type.ACCEPT_INVITE -> new SelectableText.SelectButton(ACCEPT, () -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamUuidMessage(type, uuid)));
            case C2STeamUuidMessage.Type.DENY_INVITE -> new SelectableText.SelectButton(DENY, () -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamUuidMessage(type, uuid)));
            case C2STeamUuidMessage.Type.ACCEPT_ALLY -> new SelectableText.SelectButton(ACCEPT, () -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamUuidMessage(type, uuid)), () -> this.admin);
            case C2STeamUuidMessage.Type.DENY_ALLY -> new SelectableText.SelectButton(DENY, () -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamUuidMessage(type, uuid)), () -> this.admin);
            case C2STeamUuidMessage.Type.KICK, C2STeamUuidMessage.Type.DISSOLVE_ALLY -> new SelectableText.SelectButton(DENY, () -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamUuidMessage(type, uuid)), () -> this.admin && Screen.hasShiftDown());
            case C2STeamUuidMessage.Type.PROMOTE -> new SelectableText.SelectButton(PROMOTE, () -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamUuidMessage(type, uuid)), () -> this.admin);
            case C2STeamUuidMessage.Type.DEMOTE -> new SelectableText.SelectButton(DEMOTE, () -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamUuidMessage(type, uuid)), () -> this.admin && Screen.hasShiftDown());
        };
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.box != null && this.info.team().isPresent()) {
            this.box.visible = true;
            if (this.box.isMouseOver(mouseX, mouseY)) {
                this.box.setValue(this.info.team().get().name());
                this.box.setFocused(true);
            } else {
                this.box.visible = false;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.box != null && this.info.team().isPresent() && keyCode == 257) {
            this.box.visible = false;
            this.box.setFocused(false);
            if (!this.box.getValue().isEmpty()) {
                LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamMessage(C2STeamMessage.Type.RENAME, this.box.getValue()));
            }
            return true;
        }
        if ((this.box == null || !this.box.canConsumeInput()) && this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        super.onClose();
        LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2STeamMessage(C2STeamMessage.Type.CLOSE, ""));
    }

    public void update(GrailTeam.ClientTeamInfo info, boolean reInit) {
        this.info = info;
        this.admin = this.info.team().map(GrailTeam.ShortTeamInfo::admin).orElse(false);
        if (this.info.team().isEmpty() && this.page != Pages.MAIN && this.page != Pages.INVITES) {
            this.page = Pages.MAIN;
        }
        if (reInit) {
            this.changePage(this.page);
        }
    }

    private static enum Pages {
        MAIN(Fate.modRes("textures/gui/team_gui_1.png"), null, 220, 160),
        INVITES(Fate.modRes("textures/gui/team_gui_2.png"), (Component)Component.translatable((String)"fateubw.gui.team.invites"), 220, 206),
        ALLIES(Fate.modRes("textures/gui/team_gui_2.png"), (Component)Component.translatable((String)"fateubw.gui.team.allies"), 220, 206),
        MEMBERS(Fate.modRes("textures/gui/team_gui_2.png"), (Component)Component.translatable((String)"fateubw.gui.team.members"), 220, 206);

        public final ResourceLocation texture;
        public final Component title;
        public final int sizeX;
        public final int sizeY;

        private Pages(ResourceLocation texture, Component title, int sizeX, int sizeY) {
            this.texture = texture;
            this.title = title;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
        }
    }
}

