/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.client.ClientHandler;
import io.github.flemmli97.fateubw.common.entity.summons.GordiusWheel;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class GordiusWheelModel
extends EntityModel<GordiusWheel>
implements ExtendedModel,
RideableModel<GordiusWheel> {
    public static final ResourceLocation LOCATION = Fate.modRes("gordius_wheel");
    protected final ReloadableCache<ModelPartsContainer> model = GeoModelManager.getInstance().getModel(LOCATION, model -> {
        this.bull1 = model.getPart("bull1");
        this.bull2 = model.getPart("bull2");
        this.centerBeam = model.getPart("centerBeam");
        this.backBeam = model.getPart("backBeam");
        this.ridingPosition = model.getPart("mountPos");
    });
    protected final ReloadableCache<BedrockAnimations> anim = GeoAnimationManager.getInstance().getAnimation(LOCATION);
    public ModelPartsContainer.ModelPartExtended bull1;
    public ModelPartsContainer.ModelPartExtended bull2;
    public ModelPartsContainer.ModelPartExtended centerBeam;
    public ModelPartsContainer.ModelPartExtended backBeam;
    public ModelPartsContainer.ModelPartExtended ridingPosition;

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.getModel().getRoot().render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(GordiusWheel entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.getModel().resetPoses();
        float partialTicks = ClientHandler.getPartialTicks();
        if (entity.deathTime <= 0) {
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "idle", entity.tickCount, partialTicks);
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "move", entity.tickCount, partialTicks, entity.interpolatedMoveTick(partialTicks));
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "run", entity.tickCount, partialTicks, entity.interpolatedMoveTickOf(MoveType.RUN, partialTicks));
            if (entity.getMoveType() != MoveType.NONE) {
                entity.wheelPartial = partialTicks;
            }
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "wheel_move", entity.wheelMoveTick, entity.wheelPartial, 1.0f);
        }
        ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, entity.getAnimationHandler(), partialTicks);
        if (entity.getWheelEntity() != null) {
            float yRot = GordiusWheelModel.lerpClamped(partialTicks, entity.getWheelEntity().yRotO, entity.getWheelEntity().getYRot());
            float pYRot = GordiusWheelModel.lerpClamped(partialTicks, entity.yRotO, entity.getYRot());
            this.backBeam.yRot -= pYRot * ((float)Math.PI / 180);
            this.backBeam.yRot += yRot * ((float)Math.PI / 180);
            float xRot = Mth.lerp((float)partialTicks, (float)entity.getWheelEntity().xRotO, (float)entity.getWheelEntity().getXRot());
            float chariotX = Mth.clamp((float)xRot, (float)-15.0f, (float)15.0f);
            this.centerBeam.xRot += chariotX * ((float)Math.PI / 180);
            chariotX = Mth.clamp((float)(xRot - chariotX), (float)-40.0f, (float)40.0f);
            this.backBeam.xRot += chariotX * ((float)Math.PI / 180);
        }
    }

    private static float lerpClamped(float partialTicks, float start, float end) {
        while (start < 0.0f) {
            start += 360.0f;
        }
        while (end < 0.0f) {
            end += 360.0f;
        }
        float diff1 = (end %= 360.0f) - (start %= 360.0f);
        float diff2 = Math.min(start, end) + 360.0f - Math.max(start, end);
        if (Math.abs(diff2) > Math.abs(diff1)) {
            return start + partialTicks * diff1;
        }
        return start + partialTicks * diff2;
    }

    public ModelPartsContainer getModel() {
        return (ModelPartsContainer)this.model.get();
    }

    public boolean transform(GordiusWheel entity, EntityRenderer<GordiusWheel> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack stack, int riderNum) {
        this.ridingPosition.translateAndRotateWithParents(stack);
        GordiusWheelModel.translateRider(stack, (LivingEntity)entity, rider);
        return true;
    }

    public static void translateRider(PoseStack poseStack, LivingEntity entity, Entity rider) {
        Vec3 attach = rider.getVehicleAttachmentPoint((Entity)entity);
        float scale = entity.getScale();
        poseStack.scale(1.0f / scale, 1.0f / scale, 1.0f / scale);
        poseStack.translate(attach.x(), 0.0, attach.z());
    }
}

