/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.client.ClientHandler;
import io.github.flemmli97.fateubw.common.entity.summons.Pegasus;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class PegasusModel
extends EntityModel<Pegasus>
implements ExtendedModel,
RideableModel<Pegasus> {
    public static final ResourceLocation LOCATION = Fate.modRes("pegasus");
    protected final ReloadableCache<ModelPartsContainer> model = GeoModelManager.getInstance().getModel(LOCATION, model -> {
        this.head = model.getPart("head");
        this.ridingPosition = model.getPart("mountPos");
    });
    protected final ReloadableCache<BedrockAnimations> anim = GeoAnimationManager.getInstance().getAnimation(LOCATION);
    public ModelPartsContainer.ModelPartExtended head;
    public ModelPartsContainer.ModelPartExtended ridingPosition;

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.getModel().getRoot().render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(Pegasus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.getModel().resetPoses();
        this.head.yRot += netHeadYaw * ((float)Math.PI / 180) * 0.3f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.1f;
        float partialTicks = ClientHandler.getPartialTicks();
        ((BedrockAnimations)this.anim.get()).setVariable("x_rotation", () -> ((Pegasus)entity).getXRot());
        if (entity.deathTime <= 0) {
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "idle", entity.tickCount, partialTicks);
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "walk", entity.tickCount, partialTicks, entity.interpolatedMoveTick(partialTicks));
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "run", entity.tickCount, partialTicks, entity.interpolatedMoveTickOf(MoveType.RUN, partialTicks));
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "fly", entity.tickCount, partialTicks, entity.interpolatedMoveTickOf(MoveType.FLY, partialTicks));
        }
        ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, entity.getAnimationHandler(), partialTicks);
    }

    public ModelPartsContainer getModel() {
        return (ModelPartsContainer)this.model.get();
    }

    public boolean transform(Pegasus entity, EntityRenderer<Pegasus> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack stack, int riderNum) {
        this.ridingPosition.translateAndRotateWithParents(stack);
        AnimationState animation = entity.getAnimationHandler().getAnimation();
        if (animation == null || !animation.is(new String[]{Pegasus.SUMMON}) || animation.isPast("seated")) {
            PegasusModel.translateRider(stack, (LivingEntity)entity, rider);
        }
        return true;
    }

    public static void translateRider(PoseStack poseStack, LivingEntity entity, Entity rider) {
        Vec3 attach = rider.getVehicleAttachmentPoint((Entity)entity);
        float scale = entity.getScale();
        poseStack.scale(1.0f / scale, 1.0f / scale, 1.0f / scale);
        poseStack.translate(attach.x(), attach.y(), attach.z());
    }
}

