/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.mixin.RenderTypeAccessor;
import io.github.flemmli97.tenshilib.client.VertexUtils;
import io.github.flemmli97.tenshilib.client.shader.ShaderRegister;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class FateRenders
extends RenderType {
    private static final Vector4f NO_COLOR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static ShaderInstance CORRUPTED_SHADER_INSTANCE;
    private static ShaderInstance CLIPPED_SHADER_INSTANCE;
    private static ShaderInstance PULSING_TEXT_SHADER;
    private static ShaderInstance BABYLON_SHADER_INSTANCE;
    private static ShaderInstance PARTICLE_COLOR_ADD_SHADER_INSTANCE;
    private static ShaderInstance ENTITY_MASKED;
    private static final RenderStateShard.ShaderStateShard CORRUPTED_SHADER;
    private static final RenderStateShard.ShaderStateShard CLIPPED_SHADER;
    private static final RenderStateShard.ShaderStateShard BLOOM_SHADER;
    private static final RenderStateShard.ShaderStateShard BABYLON_SHADER;
    private static final RenderStateShard.ShaderStateShard ENTITY_MASKED_SHADER;
    private static final RenderStateShard.TransparencyStateShard CORRUPTED_OVERLAY_TRANSPARENCY;
    public static final ResourceLocation CORRUPTED_TEXTURE;
    public static final VertexFormat POSITION_COLOR_TEX_TIME;
    public static final RenderType BABYLON_RENDER;
    public static final RenderType TRANSLUCENTCOLOR;
    public static final RenderType CORRUPTED_OVERLAY;
    public static final RenderType TRAIL_TRANSLUCENT;
    private static final BiFunction<ResourceLocation, ResourceLocation, RenderType> MASKED_ENTITY_CUTOUT;
    private static final ClipRenderFactory CLIPPED;
    private static final Function<ResourceLocation, RenderType> TRANSLUCENT_BLOOM_TEX;
    private static boolean init;

    public static void registerShader() {
        ShaderRegister.INSTANCE.register("fateubw", register -> {
            try {
                register.register(Fate.modRes("rendertype_corrupted"), DefaultVertexFormat.POSITION_TEX, shaderInstance -> {
                    CORRUPTED_SHADER_INSTANCE = shaderInstance;
                });
                register.register(Fate.modRes("rendertype_clipped"), DefaultVertexFormat.NEW_ENTITY, shaderInstance -> {
                    CLIPPED_SHADER_INSTANCE = shaderInstance;
                });
                register.register(Fate.modRes("pulsing_entity_text"), DefaultVertexFormat.NEW_ENTITY, shaderInstance -> {
                    PULSING_TEXT_SHADER = shaderInstance;
                });
                register.register(Fate.modRes("babylon"), POSITION_COLOR_TEX_TIME, shaderInstance -> {
                    BABYLON_SHADER_INSTANCE = shaderInstance;
                });
                register.register(Fate.modRes("particle_color_add"), DefaultVertexFormat.PARTICLE, shaderInstance -> {
                    PARTICLE_COLOR_ADD_SHADER_INSTANCE = shaderInstance;
                });
                register.register(Fate.modRes("rendertype_entity_masked"), DefaultVertexFormat.NEW_ENTITY, shaderInstance -> {
                    ENTITY_MASKED = shaderInstance;
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void addRendertype(Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder> map) {
        if (init) {
            return;
        }
        init = true;
        map.computeIfAbsent((Object)CORRUPTED_OVERLAY, e -> new ByteBufferBuilder(CORRUPTED_OVERLAY.bufferSize()));
    }

    public static RenderType getClippedRendertype(RenderType origin, Vector4f clippingPlane) {
        return FateRenders.getClippedRendertype(origin, clippingPlane, NO_COLOR, 0.0f);
    }

    public static RenderType getClippedRendertype(RenderType origin, Vector4f clippingPlane, Vector4f color, float width) {
        return CLIPPED.get(origin, clippingPlane, color, width);
    }

    public static RenderType getPulsingEntityText(ResourceLocation texture) {
        return TRANSLUCENT_BLOOM_TEX.apply(texture);
    }

    public static RenderType entityCutoutMasked(ResourceLocation location, ResourceLocation mask) {
        return MASKED_ENTITY_CUTOUT.apply(location, mask);
    }

    public static Vector4f createClippingPlane(Vector3f normal, Entity from, float offset) {
        Camera cam = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 viewPos = cam.getPosition();
        viewPos = viewPos.subtract(from.position());
        double dist = ((double)normal.x() * viewPos.x() + (double)normal.y() * viewPos.y() + (double)normal.z() * viewPos.z()) / Math.sqrt(normal.x() * normal.x() + normal.y() * normal.y() + normal.z() * normal.z());
        return new Vector4f(normal.x(), normal.y(), normal.z(), (float)dist + offset);
    }

    public static ShaderInstance getParticleColorAddShaderInstance() {
        return PARTICLE_COLOR_ADD_SHADER_INSTANCE;
    }

    private FateRenders(String string, VertexFormat vertexFormat, VertexFormat.Mode mode, int i, boolean bl, boolean bl2, Runnable runnable, Runnable runnable2) {
        super(string, vertexFormat, mode, i, bl, bl2, runnable, runnable2);
    }

    static {
        CORRUPTED_SHADER = new RenderStateShard.ShaderStateShard(() -> CORRUPTED_SHADER_INSTANCE);
        CLIPPED_SHADER = new RenderStateShard.ShaderStateShard(() -> CLIPPED_SHADER_INSTANCE);
        BLOOM_SHADER = new RenderStateShard.ShaderStateShard(() -> PULSING_TEXT_SHADER);
        BABYLON_SHADER = new RenderStateShard.ShaderStateShard(() -> BABYLON_SHADER_INSTANCE);
        ENTITY_MASKED_SHADER = new RenderStateShard.ShaderStateShard(() -> ENTITY_MASKED);
        CORRUPTED_OVERLAY_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("fateubw:corrupted_overlay_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        CORRUPTED_TEXTURE = Fate.modRes("textures/misc/corrupted_overlay.png");
        POSITION_COLOR_TEX_TIME = VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("UV0", VertexFormatElement.UV0).add("Time", (VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()).build();
        BABYLON_RENDER = RenderType.create((String)"fateubw:babylon", (VertexFormat)POSITION_COLOR_TEX_TIME, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(BABYLON_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).createCompositeState(false));
        TRANSLUCENTCOLOR = RenderType.create((String)"fateubw:translucent_color", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LIGHTNING_SHADER).setWriteMaskState(COLOR_DEPTH_WRITE).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(WEATHER_TARGET).createCompositeState(false));
        CORRUPTED_OVERLAY = RenderType.create((String)"fateubw:corrupted_overlay", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(CORRUPTED_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(CORRUPTED_TEXTURE, true, false)).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setTransparencyState(CORRUPTED_OVERLAY_TRANSPARENCY).setDepthTestState(EQUAL_DEPTH_TEST).setTexturingState(GLINT_TEXTURING).createCompositeState(false));
        TRAIL_TRANSLUCENT = RenderType.create((String)"fateubw:trail_translucent", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LIGHTNING_SHADER).setTransparencyState(LIGHTNING_TRANSPARENCY).setDepthTestState(LEQUAL_DEPTH_TEST).setCullState(NO_CULL).createCompositeState(false));
        MASKED_ENTITY_CUTOUT = Util.memoize((texture, mask) -> RenderType.create((String)"entity_cutout", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(ENTITY_MASKED_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.builder().add(texture, false, false).add(mask, false, false).build()).setTransparencyState(NO_TRANSPARENCY).setLightmapState(LIGHTMAP).createCompositeState(true)));
        CLIPPED = (wrapped, plane, color, width) -> new RenderType("rendertype_clipped_" + wrapped.toString(), wrapped.format(), wrapped.mode(), wrapped.bufferSize(), wrapped.affectsCrumbling(), ((RenderTypeAccessor)wrapped).getSortOnUpload(), () -> {
            Uniform uniformWidth;
            Uniform uniformColor;
            wrapped.setupRenderState();
            CLIPPED_SHADER.setupRenderState();
            Uniform uniform = CLIPPED_SHADER_INSTANCE.getUniform("ClippingPlane");
            if (uniform != null) {
                uniform.set(plane);
            }
            if ((uniformColor = CLIPPED_SHADER_INSTANCE.getUniform("ClippingColor")) != null) {
                uniformColor.set(color);
            }
            if ((uniformWidth = CLIPPED_SHADER_INSTANCE.getUniform("ClippingWidth")) != null) {
                uniformWidth.set(width);
            }
        }, () -> {
            wrapped.clearRenderState();
            CLIPPED_SHADER.clearRenderState();
        }){};
        TRANSLUCENT_BLOOM_TEX = Util.memoize(resourceLocation -> {
            RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setShaderState(BLOOM_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(LIGHTMAP).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).createCompositeState(true);
            return RenderType.create((String)"fateubw:entity_translucent_bloom", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)compositeState);
        });
    }

    public static interface ClipRenderFactory {
        public RenderType get(RenderType var1, Vector4f var2, Vector4f var3, float var4);
    }
}

