/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.client.render.FateRenders;
import io.github.flemmli97.fateubw.common.blocks.entity.AltarBlockEntity;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class RenderAltar
implements BlockEntityRenderer<AltarBlockEntity> {
    private final ResourceLocation texture = Fate.modRes("textures/misc/magic_circle.png");
    private final RenderUtils.BeamBuilder builder = new RenderUtils.BeamBuilder();

    public RenderAltar(BlockEntityRendererProvider.Context context) {
        this.builder.setEndColor(255, 255, 255, 0);
    }

    public boolean shouldRenderOffScreen(AltarBlockEntity blockEntity) {
        return true;
    }

    public void render(AltarBlockEntity altar, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int uv) {
        ItemStack stack;
        float ticker = (float)altar.ticker() + partialTicks;
        if (altar.isComplete()) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.025f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(ticker * 0.5f));
            VertexConsumer vert = buffer.getBuffer(FateRenders.getPulsingEntityText(this.texture));
            Matrix4f mat = poseStack.last().pose();
            float size = 2.5f;
            vert.addVertex(mat, size, 0.0f, size).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xFF00FF).setNormal(1.0f, 0.0f, 0.0f);
            vert.addVertex(mat, size, 0.0f, -size).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xFF00FF).setNormal(1.0f, 0.0f, 0.0f);
            vert.addVertex(mat, -size, 0.0f, -size).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xFF00FF).setNormal(1.0f, 0.0f, 0.0f);
            vert.addVertex(mat, -size, 0.0f, size).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xFF00FF).setNormal(1.0f, 0.0f, 0.0f);
            vert.addVertex(mat, -size, 0.0f, size).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xFF00FF).setNormal(1.0f, 0.0f, 0.0f);
            vert.addVertex(mat, -size, 0.0f, -size).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xFF00FF).setNormal(1.0f, 0.0f, 0.0f);
            vert.addVertex(mat, size, 0.0f, -size).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xFF00FF).setNormal(1.0f, 0.0f, 0.0f);
            vert.addVertex(mat, size, 0.0f, size).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xFF00FF).setNormal(1.0f, 0.0f, 0.0f);
            poseStack.popPose();
        }
        if (!(stack = altar.getCharm()).isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 1.125f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(ticker));
            poseStack.translate(0.0f, 0.06f * (float)Math.sin((double)ticker * Math.PI / 180.0), 0.0f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, 0xF000F0, OverlayTexture.NO_OVERLAY, poseStack, buffer, altar.getLevel(), 0);
            poseStack.popPose();
        }
        NonNullList<ItemStack> catalyst = altar.getCatalyst();
        float summoningTick = altar.isSummoning() ? (float)altar.getSummoningTick() + partialTicks : 0.0f;
        double yTrans = (double)(0.01f * (float)Math.sin((double)ticker * Math.PI / 180.0)) + (double)summoningTick * 0.01;
        int centerTime = 140;
        double x = Math.max(2.5 - (double)summoningTick * 2.5 / (double)centerTime, 0.0);
        for (int i = 0; i < catalyst.size(); ++i) {
            if (((ItemStack)catalyst.get(i)).isEmpty()) continue;
            poseStack.pushPose();
            poseStack.translate(0.5f, 1.125f, 0.5f);
            poseStack.translate(0.0, yTrans, 0.0);
            if (summoningTick > (float)(centerTime - 15)) {
                RenderUtils.renderGradientBeams3d((PoseStack)poseStack, (MultiBufferSource)buffer, (float)0.7f, (float)0.25f, (int)altar.ticker(), (float)partialTicks, (float)5.0f, (int)10, (RenderUtils.BeamBuilder)this.builder);
            }
            poseStack.mulPose(Axis.YP.rotationDegrees(ticker * (float)(altar.isSummoning() ? 2 : 1) + (float)((double)i * 45.0)));
            poseStack.translate(x, 0.0, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic((ItemStack)catalyst.get(i), ItemDisplayContext.GROUND, 0xF000F0, OverlayTexture.NO_OVERLAY, poseStack, buffer, altar.getLevel(), 0);
            poseStack.popPose();
        }
    }
}

