/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.fateubw.client.ClientHandler;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class RenderExcaliburItem
extends BlockEntityWithoutLevelRenderer {
    private final RenderUtils.BeamBuilder beam = RenderExcaliburItem.createBeam();

    public RenderExcaliburItem(BlockEntityRenderDispatcher blockEntityRenderDispatcher, EntityModelSet entityModelSet) {
        super(blockEntityRenderDispatcher, entityModelSet);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        RenderExcaliburItem.render(stack, transformType, matrixStack, buffer, combinedLight, combinedOverlay, this.beam);
    }

    public static RenderUtils.BeamBuilder createBeam() {
        RenderUtils.BeamBuilder beam = new RenderUtils.BeamBuilder();
        beam.setStartColor(240, 240, 240, 210);
        beam.setEndColor(245, 245, 0, 0);
        return beam;
    }

    public static void render(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, RenderUtils.BeamBuilder beam) {
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        BakedModel model = renderer.getItemModelShaper().getItemModel(stack);
        if (transformType != ItemDisplayContext.GUI) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            RenderUtils.renderGradientBeams3d((PoseStack)poseStack, (MultiBufferSource)buffer, (float)1.5f, (float)0.5f, (int)ClientHandler.clientTick, (float)ClientHandler.getPartialTicks(), (float)0.45f, (int)20, (RenderUtils.BeamBuilder)beam);
            poseStack.popPose();
        }
        poseStack.popPose();
        renderer.render(stack, transformType, false, poseStack, buffer, combinedLight, combinedOverlay, model);
        poseStack.pushPose();
    }
}

