/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.fateubw.client.render.layer.TrailPoseGetter;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.tenshilib.client.model.ItemHolderModel;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class ItemTrailLayer<T extends LivingEntity & EntityWeaponTrailHolderProvider, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final RenderLayerParent<T, M> renderer;

    public ItemTrailLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AnimationState anim = ((AnimatedEntity)entity).getAnimationHandler().getAnimation();
        if (anim != null && anim.isPast("weapon_swing_start") && !anim.isPast("weapon_swing_end")) {
            PoseStack poseStack;
            RenderLayerParent<T, M> renderLayerParent = this.renderer;
            if (renderLayerParent instanceof TrailPoseGetter) {
                TrailPoseGetter getter = (TrailPoseGetter)renderLayerParent;
                poseStack = getter.getPlainStack();
            } else {
                poseStack = stack;
            }
            stack = poseStack;
            Vec3[] data = this.calculatePosition(stack, entity, true);
            ((EntityWeaponTrailHolderProvider)entity).getTrailHolder().recordData(anim.getID(), true, data[0], data[1]);
            data = this.calculatePosition(stack, entity, false);
            ((EntityWeaponTrailHolderProvider)entity).getTrailHolder().recordData(anim.getID(), false, data[0], data[1]);
        }
    }

    protected Vec3[] calculatePosition(PoseStack stack, T entity, boolean left) {
        stack.pushPose();
        ((ItemHolderModel)this.getParentModel()).transform(left ? HumanoidArm.LEFT : HumanoidArm.RIGHT, stack);
        EntityWeaponTrailHolderProvider.WeaponTrail edge = ((EntityWeaponTrailHolderProvider)entity).weaponTrailEdge(left);
        Vector4f start = edge.start();
        Vector4f end = edge.end();
        Matrix4f last = stack.last().pose();
        start.mul((Matrix4fc)last);
        end.mul((Matrix4fc)last);
        Vec3 normal = new Vec3((double)(end.x() - start.x()), (double)(end.y() - start.y()), (double)(end.z() - start.z()));
        stack.popPose();
        return new Vec3[]{new Vec3((double)start.x() + normal.x(), (double)start.y() + normal.y(), (double)start.z() + normal.z()), normal};
    }
}

