/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.render.misc;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Axis;
import io.github.flemmli97.fateubw.client.particles.TrailRenderer;
import io.github.flemmli97.fateubw.client.render.FateRenders;
import io.github.flemmli97.fateubw.common.entity.misc.BabylonWeapon;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.provider.ParticlePositionProvider;
import io.github.flemmli97.tenshilib.client.VertexUtils;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class RenderBabylon
extends EntityRenderer<BabylonWeapon> {
    private static final MultiBufferSource.BufferSource SEP = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
    private final Vector4f color = new Vector4f(0.91764706f, 0.64705884f, 0.14509805f, 0.7f);
    private final TrailInfo info = TrailInfo.builder(new ParticlePositionProvider.ParticlePositionData(0)).setColor(0.91764706f, 0.64705884f, 0.14509805f, 0.7f).setColor2(1.0f, 0.8509804f, 0.2627451f, 0.3f).setWidth(0.07f).setWidth2(0.005f).setInterpolation(1).build();

    public RenderBabylon(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(BabylonWeapon entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        Vector4f clip;
        float yRot = Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
        float xRot = -Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        if (entity.preparing()) {
            stack.pushPose();
            float scale = Math.min(1.0f, ((float)entity.tickCount + partialTicks) / 6.0f);
            stack.scale(scale, scale, scale);
            stack.mulPose(Axis.YP.rotationDegrees(yRot));
            stack.mulPose(Axis.XP.rotationDegrees(xRot));
            stack.translate(0.0, (double)entity.getBbHeight() * 0.5, 0.0);
            float size = 1.5f;
            Matrix4f matrix4f = stack.last().pose();
            VertexConsumer consumer = buffer.getBuffer(FateRenders.BABYLON_RENDER);
            float tick = entity.tickCount + entity.renderRand;
            tick = (tick % 24000.0f + partialTicks) / 24000.0f;
            VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, -size, -size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(0.0f, 0.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
            VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, size, -size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(1.0f, 0.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
            VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, size, size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(1.0f, 1.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
            VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, -size, size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(0.0f, 1.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
            VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, -size, size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(0.0f, 1.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
            VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, size, size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(1.0f, 1.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
            VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, size, -size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(1.0f, 0.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
            VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, -size, -size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(0.0f, 0.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
            stack.popPose();
        } else {
            TrailRenderer.render((Entity)entity, this.info, entity.trailPositions(), buffer.getBuffer(FateRenders.TRAIL_TRANSLUCENT), partialTicks);
        }
        stack.pushPose();
        stack.scale(2.0f, 2.0f, 2.0f);
        stack.translate(0.0, (double)entity.getBbHeight() * 0.5, 0.0);
        stack.mulPose(Axis.YP.rotationDegrees(90.0f + yRot));
        stack.mulPose(Axis.ZP.rotationDegrees(xRot));
        if (entity.preparing()) {
            stack.translate(Math.max(0.0, 2.0 * (0.8 - (double)entity.preparationState(partialTicks))), 0.0, 0.0);
        }
        stack.translate((double)(-entity.getBbWidth()) * 0.25, 0.0, 0.0);
        stack.mulPose(Axis.ZP.rotationDegrees(135.0f));
        AtomicInteger state = new AtomicInteger();
        if (entity.preparing()) {
            normal = new Vector3f(0.0f, 0.0f, 1.0f);
            matrix3f = new Matrix3f();
            matrix3f.identity();
            matrix3f.rotate((Quaternionfc)Axis.YP.rotationDegrees(yRot));
            matrix3f.rotate((Quaternionfc)Axis.XP.rotationDegrees(xRot));
            normal.mul((Matrix3fc)matrix3f);
            clip = FateRenders.createClippingPlane(normal, (Entity)entity, entity.getBbWidth() * 0.5f);
        } else if (entity.despawning()) {
            normal = new Vector3f(0.0f, 0.0f, 1.0f);
            matrix3f = new Matrix3f();
            matrix3f.identity();
            matrix3f.rotate((Quaternionfc)Axis.YP.rotationDegrees(yRot));
            matrix3f.rotate((Quaternionfc)Axis.XP.rotationDegrees(xRot));
            normal.mul((Matrix3fc)matrix3f);
            clip = FateRenders.createClippingPlane(normal, (Entity)entity, -entity.despawnProgress() * 2.0f + 1.0f);
        } else {
            clip = null;
        }
        MultiBufferSource buf = clip != null ? renderType -> {
            VertexConsumer cons;
            RenderType rendertype = FateRenders.getClippedRendertype(renderType, clip, this.color, 0.1f);
            int current = state.get();
            VertexConsumer vertexConsumer = cons = current == 1 ? SEP.getBuffer(rendertype) : buffer.getBuffer(rendertype);
            if (current == 0 || current == 2) {
                state.set(1);
            } else {
                state.set(2);
            }
            return cons;
        } : buffer;
        Minecraft.getInstance().getItemRenderer().renderStatic(this.getRenderItemStack(entity), ItemDisplayContext.GROUND, 0xFF00FF, OverlayTexture.NO_OVERLAY, stack, buf, entity.level(), entity.getId());
        super.render((Entity)entity, rotation, partialTicks, stack, buf, 0xFF00FF);
        if (state.get() != 0) {
            SEP.endBatch();
        }
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(BabylonWeapon entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }

    public ItemStack getRenderItemStack(BabylonWeapon entity) {
        return entity.getWeapon();
    }
}

