/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.render.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.entity.misc.CaladBolg;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class RenderCaladbolg
extends EntityRenderer<CaladBolg> {
    public static final ResourceLocation TEX = Fate.modRes("textures/entity/caladbolg.png");

    public RenderCaladbolg(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(CaladBolg entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.pushPose();
        int size = 6;
        matrixStack.scale(0.2f, 0.2f, 0.2f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        matrixStack.translate((float)(-size + 2), entity.getBbHeight() * 0.6f / 0.2f, -entity.getBbWidth() * 0.3f / 0.2f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity)));
        PoseStack.Pose pose = matrixStack.last();
        float textureWidth = 1.0f;
        float textureHeight = 0.171875f;
        float ratio = textureHeight / textureWidth;
        for (int r = 0; r < 4; ++r) {
            matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.vertex(pose, vertexConsumer, -size, (float)(-size) * ratio, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, packedLight);
            this.vertex(pose, vertexConsumer, size, (float)(-size) * ratio, 0.0f, textureWidth, 0.0f, 0.0f, 1.0f, 0.0f, packedLight);
            this.vertex(pose, vertexConsumer, size, (float)size * ratio, 0.0f, textureWidth, textureHeight, 0.0f, 1.0f, 0.0f, packedLight);
            this.vertex(pose, vertexConsumer, -size, (float)size * ratio, 0.0f, 0.0f, textureHeight, 0.0f, 1.0f, 0.0f, packedLight);
        }
        matrixStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public void vertex(PoseStack.Pose pose, VertexConsumer vertexBuilder, float x, float y, float z, float textureX, float textureY, float normalX, float normalY, float normalZ, int packedLight) {
        vertexBuilder.addVertex(pose, x, y, z).setColor(255, 255, 255, 255).setUv(textureX, textureY).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, normalX, normalZ, normalY);
    }

    public ResourceLocation getTextureLocation(CaladBolg entity) {
        return TEX;
    }
}

