/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.render.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.entity.misc.ChainDagger;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class RenderChainDagger
extends EntityRenderer<ChainDagger> {
    public static final ResourceLocation TEX = Fate.modRes("textures/entity/chain_dagger_tip.png");
    public static final ResourceLocation CHAIN = Fate.modRes("textures/entity/chain.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutout((ResourceLocation)TEX);
    private static final RenderType CHAIN_RENDER = RenderType.entityCutout((ResourceLocation)CHAIN);

    public RenderChainDagger(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(ChainDagger entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Entity owner = entity.getOwner();
        float yRot = Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f;
        float xRot = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        if (entity.retracting()) {
            yRot -= 180.0f;
            xRot *= -1.0f;
        }
        poseStack.pushPose();
        poseStack.translate(0.0, (double)entity.getBbHeight() * 0.5, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(yRot));
        poseStack.mulPose(Axis.ZP.rotationDegrees(xRot));
        VertexConsumer vertexConsumer = buffer.getBuffer(RENDER_TYPE);
        PoseStack.Pose pose = poseStack.last();
        for (int r = 0; r < 4; ++r) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.vertex(pose, vertexConsumer, -0.25f, -0.25f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, packedLight);
            this.vertex(pose, vertexConsumer, 0.25f, -0.25f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, packedLight);
            this.vertex(pose, vertexConsumer, 0.25f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, packedLight);
            this.vertex(pose, vertexConsumer, -0.25f, 0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, packedLight);
        }
        poseStack.popPose();
        poseStack.pushPose();
        if (owner instanceof LivingEntity) {
            double targetZ;
            double targetY;
            double targetX;
            int i;
            LivingEntity living = (LivingEntity)owner;
            int n = i = entity.fromMainHand() ? -1 : 1;
            if (i == -1 && living.getMainHandItem().isEmpty() && living.getOffhandItem().getItem() == FateItems.MEDUSA_DAGGER.get()) {
                i = 1;
            } else if (living.getMainHandItem().getItem() == FateItems.MEDUSA_DAGGER.get()) {
                i = -1;
            }
            if ((this.entityRenderDispatcher.options == null || this.entityRenderDispatcher.options.getCameraType().isFirstPerson()) && living == Minecraft.getInstance().cameraEntity) {
                Vector3f left = this.entityRenderDispatcher.camera.getLeftVector().mul((float)i * 0.2f, new Vector3f());
                Vector3f up = this.entityRenderDispatcher.camera.getUpVector().mul(-0.2f, new Vector3f());
                float attackAnim = living.getAttackAnim(partialTicks);
                float g = Mth.sin((float)(Mth.sqrt((float)attackAnim) * (float)Math.PI));
                left = left.rotateY(g * 0.5f).rotateX(-g * 0.5f);
                up = up.rotateY(g * 0.5f).rotateX(-g * 0.5f);
                targetX = this.entityRenderDispatcher.camera.getPosition().x() + (double)left.x() + (double)up.x();
                targetY = this.entityRenderDispatcher.camera.getPosition().y() + (double)left.y() + (double)up.y();
                targetZ = this.entityRenderDispatcher.camera.getPosition().z() + (double)left.z() + (double)up.z();
            } else {
                float yRotLiving = Mth.lerp((float)partialTicks, (float)living.yBodyRotO, (float)living.yBodyRot) * ((float)Math.PI / 180);
                float hand = living.getBbWidth() * 0.6f;
                targetX = Mth.lerp((double)partialTicks, (double)living.xo, (double)living.getX()) + (double)(Mth.cos((float)yRotLiving) * (float)i * hand);
                targetY = Mth.lerp((double)partialTicks, (double)living.yo, (double)living.getY()) + (double)living.getEyeHeight() * 0.5;
                targetZ = Mth.lerp((double)partialTicks, (double)living.zo, (double)living.getZ()) + (double)(Mth.sin((float)yRotLiving) * (float)i * hand);
            }
            Vec3 look = Vec3.directionFromRotation((float)xRot, (float)(-yRot + 90.0f)).scale(0.17);
            double entityX = Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX()) + look.x;
            double entityY = Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY()) + look.y;
            double entityZ = Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ()) + look.z;
            float dX = (float)(targetX - entityX);
            float dY = (float)(targetY - entityY);
            float dZ = (float)(targetZ - entityZ);
            float[] yXRot = MathsHelper.YXRotFrom(dX, dY, dZ);
            poseStack.translate(look.x(), (double)entity.getBbHeight() * 0.5 + look.y(), look.z());
            poseStack.mulPose(Axis.YP.rotationDegrees(-yXRot[0] - 90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-yXRot[1]));
            float len = Mth.sqrt((float)(dX * dX + dY * dY + dZ * dZ)) + living.getBbWidth() * 0.0f;
            vertexConsumer = buffer.getBuffer(CHAIN_RENDER);
            this.renderChains(poseStack, vertexConsumer, packedLight, len, 0.3f);
        }
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void renderChains(PoseStack stack, VertexConsumer consumer, int packedLight, float length, float width) {
        for (int r = 0; r < 4; ++r) {
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
            PoseStack.Pose pose = stack.last();
            for (float sec = 0.0f; sec < length; sec += width * 2.0f) {
                float sectionNext = Math.min(sec + width * 2.0f, length);
                this.vertex(pose, consumer, sec, -width, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, packedLight);
                this.vertex(pose, consumer, sectionNext, -width, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, packedLight);
                this.vertex(pose, consumer, sectionNext, width, 0.0f, 1.0f, 0.9375f, 1.0f, 0.0f, 0.0f, packedLight);
                this.vertex(pose, consumer, sec, width, 0.0f, 0.0f, 0.9375f, 1.0f, 0.0f, 0.0f, packedLight);
            }
        }
    }

    public void vertex(PoseStack.Pose pose, VertexConsumer vertexBuilder, float x, float y, float z, float textureX, float textureY, float normalX, float normalY, float normalZ, int packedLight) {
        vertexBuilder.addVertex(pose, x, y, z).setColor(255, 255, 255, 255).setUv(textureX, textureY).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, normalX, normalZ, normalY);
    }

    public ResourceLocation getTextureLocation(ChainDagger entity) {
        return TEX;
    }
}

