/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.render.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Axis;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.client.render.FateRenders;
import io.github.flemmli97.fateubw.common.entity.misc.EnkiduChains;
import io.github.flemmli97.tenshilib.client.VertexUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class RenderEnkiduChains
extends EntityRenderer<EnkiduChains> {
    public static final ResourceLocation TEXTURE = Fate.modRes("textures/entity/enkidu_chain.png");
    private final Vector4f color = new Vector4f(0.91764706f, 0.64705884f, 0.14509805f, 0.7f);

    public RenderEnkiduChains(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(EnkiduChains entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        Vec3 start = entity.getStartPosition();
        float yRot = Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
        float xRot = -Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        double x = Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX());
        double y = Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY());
        double z = Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ());
        double dx = x - start.x();
        double dy = y - start.y();
        double dz = z - start.z();
        double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
        stack.pushPose();
        float scale = Math.min(1.0f, ((float)entity.tickCount + partialTicks) / 6.0f);
        stack.scale(scale, scale, scale);
        stack.mulPose(Axis.YP.rotationDegrees(yRot));
        stack.mulPose(Axis.XP.rotationDegrees(xRot));
        stack.translate(0.0, (double)entity.getBbHeight() * 0.5, -len);
        stack.mulPose(Axis.XP.rotationDegrees(-xRot));
        stack.mulPose(Axis.YP.rotationDegrees(-yRot));
        stack.mulPose(Axis.YP.rotationDegrees(entity.getStartY()));
        stack.mulPose(Axis.XP.rotationDegrees(entity.getStartX()));
        float size = 1.5f;
        Matrix4f matrix4f = stack.last().pose();
        VertexConsumer consumer = buffer.getBuffer(FateRenders.BABYLON_RENDER);
        float tick = entity.tickCount + entity.renderRand;
        tick = (tick % 24000.0f + partialTicks) / 24000.0f;
        VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, -size, -size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(0.0f, 0.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
        VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, size, -size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(1.0f, 0.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
        VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, size, size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(1.0f, 1.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
        VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, -size, size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(0.0f, 1.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
        VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, -size, size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(0.0f, 1.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
        VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, size, size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(1.0f, 1.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
        VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, size, -size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(1.0f, 0.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
        VertexUtils.addVertexData((VertexConsumer)consumer.addVertex(matrix4f, -size, -size, 0.0f).setColor(this.color.x(), this.color.y(), this.color.z(), 1.0f).setUv(0.0f, 0.0f), (VertexFormatElement)((VertexFormatElement)VertexUtils.SINGLE_FLOAT.get()), (float[])new float[]{tick});
        stack.popPose();
        if (!entity.preparing()) {
            int mod;
            stack.pushPose();
            stack.translate(0.0, (double)entity.getBbHeight() * 0.5, 0.0);
            stack.mulPose(Axis.YP.rotationDegrees(yRot + 90.0f));
            stack.mulPose(Axis.ZP.rotationDegrees(xRot));
            if (entity.hasHooked() && (mod = entity.tickCount % 10) < 3) {
                stack.translate(0.0, entity.getRandom().nextDouble() * 0.05, entity.getRandom().nextDouble() * 0.05);
            }
            consumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity)));
            this.renderChains(stack, consumer, (float)len, entity.getBbWidth() * 2.0f);
            stack.popPose();
        }
    }

    protected void renderChains(PoseStack stack, VertexConsumer consumer, float length, float width) {
        for (int r = 0; r < 4; ++r) {
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
            PoseStack.Pose pose = stack.last();
            for (float sec = 0.0f; sec < length; sec += width * 2.0f) {
                float sectionNext = Math.min(sec + width * 2.0f, length);
                float perc = sectionNext - sec / (width * 2.0f);
                this.vertex(pose, consumer, sec, -width, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                this.vertex(pose, consumer, sectionNext, -width, 0.0f, perc, 0.0f, 1.0f, 0.0f, 0.0f);
                this.vertex(pose, consumer, sectionNext, width, 0.0f, perc, 1.0f, 1.0f, 0.0f, 0.0f);
                this.vertex(pose, consumer, sec, width, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f);
            }
        }
    }

    public void vertex(PoseStack.Pose pose, VertexConsumer vertexBuilder, float x, float y, float z, float textureX, float textureY, float normalX, float normalY, float normalZ) {
        vertexBuilder.addVertex(pose, x, y, z).setColor(255, 255, 255, 255).setUv(textureX, textureY).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xFFFFFF).setNormal(pose, normalX, normalZ, normalY);
    }

    public ResourceLocation getTextureLocation(EnkiduChains entity) {
        return TEXTURE;
    }
}

