/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.render.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.entity.misc.Excalibur;
import io.github.flemmli97.tenshilib.client.render.BeamRenderer;
import io.github.flemmli97.tenshilib.common.entity.BeamEntity;
import java.util.Random;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RenderExcalibur
extends BeamRenderer<Excalibur> {
    public static final ResourceLocation TEX = Fate.modRes("textures/entity/excalibur.png");
    private static final Random RANDOM = new Random();
    private final float widthMod = Mth.sqrt((float)0.40499997f) * 2.0f;

    public RenderExcalibur(EntityRendererProvider.Context ctx) {
        super(ctx, 1.0f, 0.9f, 4);
    }

    public void render(Excalibur entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        boolean playerView;
        matrixStack.pushPose();
        boolean bl = playerView = entity.getOwner() == Minecraft.getInstance().player && Minecraft.getInstance().options.getCameraType() != CameraType.THIRD_PERSON_BACK;
        if (!playerView) {
            float y = Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) + 90.0f;
            float x = -Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
            matrixStack.mulPose(Axis.YN.rotationDegrees(y));
            matrixStack.mulPose(Axis.ZP.rotationDegrees(x));
            float scale = Mth.sin((float)(((float)entity.tickCount + partialTicks) * 1000.0f)) * 0.05f + 1.0f;
            matrixStack.scale(1.0f, scale, scale);
            matrixStack.translate(0.0, (double)RANDOM.nextFloat() * 0.2, (double)RANDOM.nextFloat() * 0.2);
            matrixStack.mulPose(Axis.ZP.rotationDegrees(-x));
            matrixStack.mulPose(Axis.YN.rotationDegrees(-y));
        }
        super.render((BeamEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        matrixStack.popPose();
    }

    public float widthFunc(Excalibur entity, float partialTicks) {
        return super.widthFunc((BeamEntity)entity, partialTicks) / this.widthMod;
    }

    public ResourceLocation getTextureLocation(Excalibur entity) {
        return TEX;
    }

    public BeamRenderer.ResourcePair startTexture(Excalibur entity) {
        return null;
    }

    public BeamRenderer.ResourcePair endTexture(Excalibur entity) {
        return null;
    }
}

