/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.render.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.entity.misc.MagicBeam;
import io.github.flemmli97.tenshilib.client.render.BeamRenderer;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.common.entity.BeamEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RenderMagicBeam
extends BeamRenderer<MagicBeam> {
    public static final ResourceLocation TEX = Fate.modRes("textures/entity/magic_beam.png");
    public static final ResourceLocation TEX_CIRCLE = Fate.modRes("textures/entity/medea_beam_circle.png");
    private final RenderUtils.TextureBuilder textureBuilder = new RenderUtils.TextureBuilder();
    private final float widthMod = Mth.sqrt((float)0.32000002f) * 2.0f;

    public RenderMagicBeam(EntityRendererProvider.Context ctx) {
        super(ctx, 1.0f, 0.8f, 4);
    }

    public void render(MagicBeam projectile, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        stack.scale(1.6f, 1.6f, 1.6f);
        stack.mulPose(Axis.YP.rotationDegrees(-projectile.getSpawnRotY()));
        stack.mulPose(Axis.XP.rotationDegrees(projectile.getSpawnRotX()));
        this.textureBuilder.setLight(0xF000F0);
        RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEX_CIRCLE)), (float)1.0f, (float)1.0f, (RenderUtils.TextureBuilder)this.textureBuilder);
        stack.popPose();
        if (!projectile.preparing()) {
            super.render((BeamEntity)projectile, rotation, partialTicks, stack, buffer, packedLight);
        }
    }

    public float widthFunc(MagicBeam entity, float partialTicks) {
        float width = (float)((double)(entity.radius() * 2.0f) * Math.sin((double)Math.clamp(((float)entity.livingTicks() + partialTicks) / (float)entity.livingTickMax(), 0.0f, 1.0f) * Math.PI));
        return width / this.widthMod;
    }

    public BeamRenderer.ResourcePair startTexture(MagicBeam entityMagicBeam) {
        return null;
    }

    public BeamRenderer.ResourcePair endTexture(MagicBeam entityMagicBeam) {
        return null;
    }

    public ResourceLocation getTextureLocation(MagicBeam entityMagicBeam) {
        return TEX;
    }
}

