/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.client.render.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.client.model.PegasusModel;
import io.github.flemmli97.fateubw.client.render.FateRenders;
import io.github.flemmli97.fateubw.client.render.layer.PortalLayerRenderer;
import io.github.flemmli97.fateubw.common.entity.summons.Pegasus;
import io.github.flemmli97.tenshilib.client.render.layer.RiderEntityLayer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RenderPegasus
extends MobRenderer<Pegasus, PegasusModel> {
    public static final ResourceLocation TEX = Fate.modRes("textures/entity/pegasus.png");
    private float partialTicks;
    private final float shadowDefault;

    public RenderPegasus(EntityRendererProvider.Context ctx) {
        super(ctx, (EntityModel)new PegasusModel(), 0.5f);
        this.shadowDefault = this.shadowRadius;
        this.layers.add(new PortalLayerRenderer(this, e -> e.getAnimationHandler().isCurrent(new String[]{Pegasus.SUMMON}), stack -> stack.translate(0.0f, 0.0f, this.portalOffset()), Fate.modRes("textures/misc/magic_circle.png"), Pegasus.PORTAL_SIZE));
        this.layers.add(new RiderEntityLayer((LivingEntityRenderer)this));
    }

    public void render(Pegasus entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        this.partialTicks = partialTicks;
        this.shadowRadius = entity.getAnimationHandler().isCurrent(new String[]{Pegasus.SUMMON}) ? 0.0f : this.shadowDefault;
        super.render((LivingEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    @Nullable
    protected RenderType getRenderType(Pegasus livingEntity, boolean bodyVisible, boolean translucent, boolean glowing) {
        RenderType origin = super.getRenderType((LivingEntity)livingEntity, bodyVisible, translucent, glowing);
        if (origin == null || !livingEntity.getAnimationHandler().isCurrent(new String[]{Pegasus.SUMMON})) {
            return origin;
        }
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        normal.rotate((Quaternionfc)Axis.YP.rotationDegrees(-Mth.rotLerp((float)this.partialTicks, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot)));
        return FateRenders.getClippedRendertype(origin, FateRenders.createClippingPlane(normal, (Entity)livingEntity, this.portalOffset()));
    }

    private float portalOffset() {
        return Pegasus.PORTAL_OFFSET;
    }

    public ResourceLocation getTextureLocation(Pegasus pegasus) {
        return TEX;
    }
}

