/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.attachment;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.misc.ChainDagger;
import io.github.flemmli97.fateubw.common.network.S2CCommandSeals;
import io.github.flemmli97.fateubw.common.network.S2CMana;
import io.github.flemmli97.fateubw.common.network.S2CPlayerCap;
import io.github.flemmli97.fateubw.common.registry.FateMobEffects;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class PlayerData {
    private final Player player;
    private int currentMana;
    private int commandSeals = 0;
    private int manaRegenCooldown = 100;
    private float manaRegenAccel = 1.0f;
    private Pair<EntityType<?>, CompoundTag> savedServant;
    private ChainDagger currentDagger;

    public PlayerData(Player player) {
        this.player = player;
    }

    public void setMana(int mana) {
        this.currentMana = Math.min(mana, 100);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CMana(this), serverPlayer);
        }
    }

    public void addMana(int amount) {
        this.setMana(this.currentMana + amount);
    }

    public int getMana() {
        if (this.player.hasEffect(FateMobEffects.RULE_BREAKER.asHolder())) {
            return 0;
        }
        return this.currentMana;
    }

    public boolean useMana(int amount) {
        boolean flag;
        boolean bl = flag = this.getMana() >= amount;
        if (flag) {
            this.currentMana -= amount;
            this.manaRegenAccel = 1.0f;
            this.manaRegenCooldown = 160;
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CMana(this), serverPlayer);
            }
        }
        return flag;
    }

    public void tick() {
        if (--this.manaRegenCooldown <= 0 && !this.player.hasEffect(FateMobEffects.RULE_BREAKER.asHolder())) {
            this.addMana(1);
            this.manaRegenCooldown = (int)(120.0f / this.manaRegenAccel);
            this.manaRegenAccel = Math.min(this.manaRegenAccel + 0.5f, 10.0f);
        }
    }

    public void saveServant(ServantLike<?> servant) {
        if (servant != null) {
            Object entity = servant.get();
            entity.stopRiding();
            entity.ejectPassengers();
            CompoundTag nbt = new CompoundTag();
            entity.saveWithoutId(nbt);
            nbt.remove("Pos");
            nbt.remove("Motion");
            nbt.remove("Rotation");
            nbt.remove("UUID");
            this.savedServant = Pair.of((Object)entity.getType(), (Object)nbt);
        }
    }

    public void restoreServant(boolean loot) {
        Level level;
        if (this.savedServant != null && (level = this.player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (loot) {
                ResourceKey lootId = ((EntityType)this.savedServant.getFirst()).getDefaultLootTable();
                LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(lootId);
                LootContext.Builder builder = this.createLootContext((ServerPlayer)this.player);
                lootTable.getRandomItems(builder.create(Optional.empty()), arg_0 -> ((Player)this.player).spawnAtLocation(arg_0));
                this.savedServant = null;
            } else {
                Entity entity = ((EntityType)this.savedServant.getFirst()).create((Level)serverLevel);
                if (entity instanceof BaseServant) {
                    BaseServant servant = (BaseServant)entity;
                    servant.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(servant.blockPosition()), MobSpawnType.TRIGGERED, null);
                    entity.load((CompoundTag)this.savedServant.getSecond());
                    Vec3 look = this.player.getLookAngle();
                    entity.setPos(this.player.getX() + look.x, this.player.getY(), this.player.getZ() + look.z);
                    servant.setOwner(this.player);
                    serverLevel.addFreshEntity(entity);
                    this.savedServant = null;
                }
            }
        }
    }

    private LootContext.Builder createLootContext(ServerPlayer player) {
        DamageSource source = player.damageSources().playerAttack((Player)player);
        LootParams params = new LootParams.Builder(player.serverLevel()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity()).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).withLuck(player.getLuck()).create(LootContextParamSets.ENTITY);
        return new LootContext.Builder(params).withOptionalRandomSource(player.getRandom());
    }

    public int getCommandSeals() {
        return this.commandSeals;
    }

    public boolean useCommandSeal() {
        boolean flag;
        boolean bl = flag = this.commandSeals > 0;
        if (flag) {
            --this.commandSeals;
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CCommandSeals(this), serverPlayer);
            }
        }
        return flag;
    }

    public void setCommandSeals(int amount) {
        this.commandSeals = Math.min(amount, 3);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CCommandSeals(this), serverPlayer);
        }
    }

    public void setThrownDagger(ChainDagger hook) {
        this.currentDagger = hook;
    }

    public ChainDagger getThrownDagger() {
        if (this.currentDagger != null && this.currentDagger.isAlive()) {
            return this.currentDagger;
        }
        return null;
    }

    public CompoundTag save(CompoundTag compound) {
        compound.putInt("Mana", this.currentMana);
        compound.putInt("CommandSeal", this.commandSeals);
        if (this.savedServant != null) {
            compound.putString("SavedServantType", BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)this.savedServant.getFirst())).toString());
            compound.put("SavedServant", (Tag)this.savedServant.getSecond());
        }
        return compound;
    }

    public void load(CompoundTag compound) {
        this.currentMana = compound.getInt("Mana");
        this.commandSeals = compound.getInt("CommandSeal");
        if (compound.contains("SavedServantType")) {
            this.savedServant = Pair.of((Object)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)compound.getString("SavedServantType")))), (Object)compound.getCompound("SavedServant"));
        }
    }

    public void from(PlayerData other) {
        this.currentMana = other.currentMana;
        this.commandSeals = other.commandSeals;
        this.savedServant = other.savedServant;
    }

    public void handleClientUpdatePacket(S2CPlayerCap pkt) {
        this.currentMana = pkt.manaValue;
        this.commandSeals = pkt.commandSeals;
    }
}

