/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.blocks;

import com.mojang.serialization.MapCodec;
import io.github.flemmli97.fateubw.common.blocks.ChalkBlock;
import io.github.flemmli97.fateubw.common.blocks.entity.AltarBlockEntity;
import io.github.flemmli97.fateubw.common.registry.FateBlocks;
import io.github.flemmli97.fateubw.common.registry.FateCriterionTriggers;
import io.github.flemmli97.fateubw.common.world.GrailWarHandler;
import io.github.flemmli97.tenshilib.common.utils.VoxelUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AltarBlock
extends BaseEntityBlock {
    public static final MapCodec<AltarBlock> CODEC = AltarBlock.simpleCodec(AltarBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final double PIXEL = 0.0625;
    private static final VoxelShape[] SHAPES = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)13.5, (double)0.0, (double)0.5, (double)15.5, (double)11.0, (double)2.5), VoxelUtils.ShapeBuilder.of((double)0.5, (double)0.0, (double)0.5, (double)2.5, (double)11.0, (double)2.5), VoxelUtils.ShapeBuilder.of((double)0.5, (double)9.0, (double)0.5, (double)15.5, (double)12.0, (double)15.5), VoxelUtils.ShapeBuilder.of((double)13.5, (double)0.0, (double)13.5, (double)15.5, (double)11.0, (double)15.5), VoxelUtils.ShapeBuilder.of((double)0.5, (double)0.0, (double)13.5, (double)2.5, (double)11.0, (double)15.5), VoxelUtils.ShapeBuilder.of((double)0.0, (double)11.9, (double)0.0, (double)16.0, (double)12.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)15.9, (double)5.0, (double)4.0, (double)16.0, (double)6.0, (double)5.0), VoxelUtils.ShapeBuilder.of((double)15.9, (double)4.0, (double)3.0, (double)16.0, (double)6.0, (double)4.0), VoxelUtils.ShapeBuilder.of((double)15.9, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)3.0), VoxelUtils.ShapeBuilder.of((double)15.9, (double)3.0, (double)13.0, (double)16.0, (double)6.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)15.9, (double)4.0, (double)12.0, (double)16.0, (double)6.0, (double)13.0), VoxelUtils.ShapeBuilder.of((double)15.9, (double)5.0, (double)11.0, (double)16.0, (double)6.0, (double)12.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)3.0, (double)0.0, (double)0.1, (double)6.0, (double)3.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)4.0, (double)3.0, (double)0.1, (double)6.0, (double)4.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)5.0, (double)4.0, (double)0.1, (double)6.0, (double)5.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)5.0, (double)11.0, (double)0.1, (double)6.0, (double)12.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)4.0, (double)12.0, (double)0.1, (double)6.0, (double)13.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)3.0, (double)13.0, (double)0.1, (double)6.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)3.0, (double)15.9, (double)3.0, (double)6.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)3.0, (double)4.0, (double)15.9, (double)4.0, (double)6.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)4.0, (double)5.0, (double)15.9, (double)5.0, (double)6.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)13.0, (double)3.0, (double)15.9, (double)16.0, (double)6.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)12.0, (double)4.0, (double)15.9, (double)13.0, (double)6.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)11.0, (double)5.0, (double)15.9, (double)12.0, (double)6.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)0.1), VoxelUtils.ShapeBuilder.of((double)12.0, (double)4.0, (double)0.0, (double)13.0, (double)6.0, (double)0.1), VoxelUtils.ShapeBuilder.of((double)11.0, (double)5.0, (double)0.0, (double)12.0, (double)6.0, (double)0.1), VoxelUtils.ShapeBuilder.of((double)4.0, (double)5.0, (double)0.0, (double)5.0, (double)6.0, (double)0.1), VoxelUtils.ShapeBuilder.of((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)6.0, (double)0.1), VoxelUtils.ShapeBuilder.of((double)3.0, (double)4.0, (double)0.0, (double)4.0, (double)6.0, (double)0.1), VoxelUtils.ShapeBuilder.of((double)0.0, (double)6.0, (double)0.0, (double)0.1, (double)12.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)15.9, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)0.1), VoxelUtils.ShapeBuilder.of((double)0.0, (double)6.0, (double)15.9, (double)16.0, (double)12.0, (double)16.0), VoxelUtils.ShapeBuilder.of((double)7.0, (double)12.0, (double)13.0, (double)9.0, (double)15.0, (double)15.0), VoxelUtils.ShapeBuilder.of((double)8.5, (double)11.5, (double)12.5, (double)9.5, (double)12.5, (double)13.5), VoxelUtils.ShapeBuilder.of((double)1.5, (double)11.5, (double)12.5, (double)2.5, (double)12.5, (double)13.5), VoxelUtils.ShapeBuilder.of((double)3.5, (double)11.5, (double)11.5, (double)4.5, (double)12.5, (double)12.5), VoxelUtils.ShapeBuilder.of((double)2.0, (double)10.5, (double)12.0, (double)4.0, (double)13.5, (double)14.0), VoxelUtils.ShapeBuilder.of((double)12.5, (double)11.5, (double)11.5, (double)13.5, (double)12.5, (double)12.5), VoxelUtils.ShapeBuilder.of((double)12.0, (double)11.5, (double)12.0, (double)14.0, (double)14.5, (double)14.0)});

    public AltarBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static boolean placeSummoningStructure(ServerLevel level, BlockPos pos, AltarBlockEntity altar, Direction facing) {
        int z;
        int x;
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                BlockPos posNew;
                if (x == 0 && z == 0 || level.getBlockState(posNew = pos.offset(x, 0, z)).getBlock() instanceof ChalkBlock) continue;
                return false;
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                if (x == 0 && z == 0) continue;
                BlockPos newPos = new BlockPos(pos.getX() + x, pos.getY(), pos.getZ() + z);
                level.removeBlock(newPos, false);
                level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, (double)newPos.getX() + 0.5, (double)newPos.getY(), (double)newPos.getZ() + 0.5, 1, 0.0, 0.2, 0.0, 0.0);
            }
        }
        altar.setComplete(true);
        return true;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.getValue((Property)FACING)).get2DDataValue()];
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!state.is(oldState.getBlock())) {
            BlockEntity tileentity = level.getBlockEntity(pos);
            if (tileentity instanceof AltarBlockEntity) {
                AltarBlockEntity altar = (AltarBlockEntity)tileentity;
                ItemStack stack = altar.getCharm();
                if (!stack.isEmpty()) {
                    ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
                    level.addFreshEntity((Entity)item);
                }
                NonNullList<ItemStack> list = altar.getCatalyst();
                for (ItemStack cat : list) {
                    if (cat.isEmpty()) continue;
                    ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), cat);
                    level.addFreshEntity((Entity)item);
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, oldState, isMoving);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        AltarBlockEntity altar;
        for (int i = 0; i < 5; ++i) {
            double d0 = (float)pos.getX() + random.nextFloat();
            double d1 = (float)pos.getY() + random.nextFloat();
            double d2 = (float)pos.getZ() + random.nextFloat();
            double d3 = ((double)random.nextFloat() - 0.5) * 1.000000001490116;
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, d3, d3, d3);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AltarBlockEntity) || !(altar = (AltarBlockEntity)blockEntity).isComplete()) {
            return;
        }
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.1875, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.78125, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.5, (double)pos.getY() + 1.09375, (double)pos.getZ() + 0.84375, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.8125, (double)pos.getY() + 1.0625, (double)pos.getZ() + 0.78125, 0.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.8125, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.15625, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.5, (double)pos.getY() + 1.09375, (double)pos.getZ() + 0.09375, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.1875, (double)pos.getY() + 1.0625, (double)pos.getZ() + 0.15625, 0.0, 0.0, 0.0);
                break;
            }
            case EAST: {
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.15625, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.1875, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.09375, (double)pos.getY() + 1.09375, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.15625, (double)pos.getY() + 1.0625, (double)pos.getZ() + 0.8125, 0.0, 0.0, 0.0);
                break;
            }
            case WEST: {
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.78125, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.8125, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.84375, (double)pos.getY() + 1.09375, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.78125, (double)pos.getY() + 1.0625, (double)pos.getZ() + 0.1875, 0.0, 0.0, 0.0);
                break;
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AltarBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        AltarBlockEntity altar = (AltarBlockEntity)blockEntity;
        if (!(player instanceof ServerPlayer)) {
            return ItemInteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (altar.addItem(player, stack)) {
            return ItemInteractionResult.CONSUME;
        }
        if (player.isShiftKeyDown()) {
            if (altar.removeItem(player)) {
                return ItemInteractionResult.CONSUME;
            }
            return ItemInteractionResult.FAIL;
        }
        if (altar.addItem(player, stack)) {
            return ItemInteractionResult.CONSUME;
        }
        if (!altar.isComplete()) {
            boolean placeRes = AltarBlock.placeSummoningStructure((ServerLevel)level, pos, altar, ((Direction)state.getValue((Property)FACING)).getOpposite());
            if (!placeRes) {
                player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.altar.incomplete").withStyle(ChatFormatting.DARK_RED));
            }
            return placeRes ? ItemInteractionResult.CONSUME : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        GrailWarHandler tracker = GrailWarHandler.get(serverPlayer.getServer());
        if (tracker.getServant(serverPlayer).isEmpty()) {
            if (!altar.canSummon()) {
                player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.altar.missing.catalyst").withStyle(ChatFormatting.DARK_RED));
                return ItemInteractionResult.FAIL;
            }
            if (!altar.isSummoning()) {
                GrailWarHandler.JoinResult joinResult = tracker.checkJoining(player);
                if (joinResult != GrailWarHandler.JoinResult.SUCCESS) {
                    player.sendSystemMessage((Component)Component.translatable((String)joinResult.translationKey).withStyle(ChatFormatting.DARK_RED));
                    return ItemInteractionResult.FAIL;
                }
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                if (altar.setSummoning(player)) {
                    ((PlayerTrigger)FateCriterionTriggers.JOIN_GRAIL_WAR.get()).trigger(serverPlayer);
                    return ItemInteractionResult.CONSUME;
                }
                return ItemInteractionResult.FAIL;
            }
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.altar.servant.existing").withStyle(ChatFormatting.DARK_RED));
        }
        return ItemInteractionResult.FAIL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return AltarBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)FateBlocks.ALTAR_BLOCK_ENTITY.get()), AltarBlockEntity::ticker);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AltarBlockEntity(pos, state);
    }
}

