/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.blocks.entity;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.network.S2CAltarUpdate;
import io.github.flemmli97.fateubw.common.registry.FateBlocks;
import io.github.flemmli97.fateubw.common.registry.FateDataComponents;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.world.GrailWarHandler;
import io.github.flemmli97.fateubw.platform.Platform;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AltarBlockEntity
extends BlockEntity {
    private boolean isComplete;
    private boolean isSummoning;
    private ItemStack inventoryCharm = ItemStack.EMPTY;
    private final NonNullList<ItemStack> invCatalyst = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
    private int summoningTick;
    private int tick;
    private ServantLike<?> servant;

    public AltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FateBlocks.ALTAR_BLOCK_ENTITY.get(), pos, state);
    }

    public static void ticker(Level level, BlockPos pos, BlockState state, AltarBlockEntity altar) {
        if (level instanceof ServerLevel) {
            if (altar.isSummoning) {
                ++altar.summoningTick;
                if (altar.summoningTick == 1) {
                    level.playSound(null, altar.worldPosition, SoundEvents.PORTAL_TRAVEL, SoundSource.AMBIENT, 0.4f, 1.0f);
                }
                if (altar.summoningTick == 150) {
                    if (altar.servant != null) {
                        if (altar.servant.getOwner() != null) {
                            altar.servant.get().lookAt(EntityAnchorArgument.Anchor.EYES, altar.servant.getOwner().position());
                        }
                        level.addFreshEntity(altar.servant.get());
                    }
                    level.destroyBlock(pos, false);
                }
            }
        } else {
            ++altar.tick;
            if (altar.isSummoning) {
                ++altar.summoningTick;
            }
        }
    }

    public ItemStack getCharm() {
        return this.inventoryCharm;
    }

    public NonNullList<ItemStack> getCatalyst() {
        return this.invCatalyst;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean canSummon() {
        return this.isComplete() && !this.isSummoning() && this.invCatalyst.stream().noneMatch(ItemStack::isEmpty);
    }

    public void setComplete(boolean flag) {
        this.isComplete = flag;
        if (!this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public boolean addItem(Player player, ItemStack stack) {
        if (stack.has((DataComponentType)FateDataComponents.CLASS_RELIC.get()) || stack.has((DataComponentType)FateDataComponents.SERVANT_RELIC.get())) {
            if (this.inventoryCharm.isEmpty()) {
                ItemStack stackToAdd = stack.copy();
                stackToAdd.setCount(1);
                this.inventoryCharm = stackToAdd;
                if (player != null && !player.isCreative()) {
                    stack.shrink(1);
                }
                this.setChanged();
                if (!this.level.isClientSide) {
                    this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
                }
                return true;
            }
        } else if (stack.getItem() == FateItems.MANA_GEM.get()) {
            ItemStack add = stack.copy();
            add.setCount(1);
            for (int x = 0; x < this.invCatalyst.size(); ++x) {
                if (!((ItemStack)this.invCatalyst.get(x)).isEmpty()) continue;
                this.invCatalyst.set(x, (Object)add);
                if (player != null && !player.isCreative()) {
                    stack.shrink(1);
                }
                this.setChanged();
                if (!this.level.isClientSide) {
                    this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
                }
                return true;
            }
        }
        return false;
    }

    public boolean removeItem(Player player) {
        if (!this.inventoryCharm.isEmpty()) {
            if (player != null && !player.isCreative()) {
                player.getInventory().add(this.inventoryCharm);
            }
            this.inventoryCharm = ItemStack.EMPTY;
            this.setChanged();
            if (!this.level.isClientSide) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            }
            return true;
        }
        for (int x = 0; x < this.invCatalyst.size(); ++x) {
            ItemStack inv = (ItemStack)this.invCatalyst.get(x);
            if (inv.isEmpty()) continue;
            if (player != null && !player.isCreative()) {
                player.getInventory().add(inv);
            }
            this.invCatalyst.set(x, (Object)ItemStack.EMPTY);
            this.setChanged();
            if (!this.level.isClientSide) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            }
            return true;
        }
        return false;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("Charm")) {
            this.inventoryCharm = (ItemStack)ItemStack.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("Charm")).getOrThrow();
        }
        this.invCatalyst.clear();
        ContainerHelper.loadAllItems((CompoundTag)compound, this.invCatalyst, (HolderLookup.Provider)provider);
        this.isComplete = compound.getBoolean("complete");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (!this.inventoryCharm.isEmpty()) {
            compound.put("Charm", (Tag)ItemStack.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.inventoryCharm).getOrThrow());
        }
        ContainerHelper.saveAllItems((CompoundTag)compound, this.invCatalyst, (HolderLookup.Provider)provider);
        compound.putBoolean("complete", this.isComplete);
    }

    public boolean setSummoning(Player player) {
        ServerPlayer serverPlayer;
        ServantLike<?> servant;
        if (player instanceof ServerPlayer && (servant = GrailWarHandler.get((serverPlayer = (ServerPlayer)player).getServer()).summonRandomServant(serverPlayer.serverLevel(), Vec3.atCenterOf((Vec3i)this.worldPosition), serverPlayer, this.inventoryCharm, false, false)) != null) {
            this.isSummoning = true;
            LoaderNetwork.INSTANCE.sendToTracking((CustomPacketPayload)new S2CAltarUpdate(this.getBlockPos(), this.isSummoning), serverPlayer.serverLevel(), new ChunkPos(this.getBlockPos()));
            Platform.INSTANCE.getPlayerData((Player)serverPlayer).setCommandSeals(3);
            this.servant = servant;
            return true;
        }
        return false;
    }

    public boolean isSummoning() {
        return this.isSummoning;
    }

    public int getSummoningTick() {
        return this.summoningTick;
    }

    public int ticker() {
        return this.tick;
    }

    public void updateSummoning(boolean flag) {
        this.isSummoning = flag;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.getBlockPos()).inflate(4.0);
    }
}

