/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.fateubw.common.attachment.PlayerData;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.loot.GrailLootTable;
import io.github.flemmli97.fateubw.common.loot.entry.AttributeEntry;
import io.github.flemmli97.fateubw.common.world.GrailWarHandler;
import io.github.flemmli97.fateubw.mixin.AttributeMapAccessor;
import io.github.flemmli97.fateubw.platform.Platform;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandHandler {
    public static SuggestionProvider<CommandSourceStack> GRAILLOOTSUGGESTION = (ctx, builder) -> SharedSuggestionProvider.suggestResource(DatapackHandler.getAllTables().stream(), (SuggestionsBuilder)builder);

    public static void reg(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fateubw").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(src -> src.hasPermission(2))).executes(CommandHandler::resetWar)).then(Commands.literal((String)"attributes").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(CommandHandler::resetAttributes))))).then(((LiteralArgumentBuilder)Commands.literal((String)"start").requires(src -> src.hasPermission(2))).executes(CommandHandler::startWar))).then(((LiteralArgumentBuilder)Commands.literal((String)"loot").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).suggests(GRAILLOOTSUGGESTION).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(CommandHandler::giveLoot))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"command_spell").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CommandHandler.modifyCommandspell((CommandContext<CommandSourceStack>)ctx, CommnandMode.SET)))))).then(Commands.literal((String)"give").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CommandHandler.modifyCommandspell((CommandContext<CommandSourceStack>)ctx, CommnandMode.ADD)))))).then(Commands.literal((String)"take").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CommandHandler.modifyCommandspell((CommandContext<CommandSourceStack>)ctx, CommnandMode.TAKE)))))));
    }

    private static int startWar(CommandContext<CommandSourceStack> ctx) {
        if (!GrailWarHandler.get(((CommandSourceStack)ctx.getSource()).getServer()).forceStartGrailWar()) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"fateubw.command.war.start.fail"));
            return 0;
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"fateubw.command.war.start"), false);
        return 1;
    }

    private static int resetWar(CommandContext<CommandSourceStack> ctx) {
        GrailWarHandler.get(((CommandSourceStack)ctx.getSource()).getServer()).reset(true);
        return 1;
    }

    private static int giveLoot(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(ctx, (String)"players");
        ResourceLocation id = ResourceLocationArgument.getId(ctx, (String)"id");
        GrailLootTable loot = DatapackHandler.getLootTable(id).orElse(null);
        if (loot == null) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"fateubw.command.loot.none", (Object[])new Object[]{id.toString()}), false);
            return 0;
        }
        players.forEach(loot::give);
        if (players.size() == 1) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"fateubw.command.loot.give.single", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).getDisplayName(), id.toString()}), false);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"fateubw.command.loot.give", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).getDisplayName(), id.toString()}), false);
        }
        return 1;
    }

    private static int resetAttributes(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(ctx, (String)"players");
        players.forEach(player -> ((AttributeMapAccessor)player.getAttributes()).getAttributes().forEach((att, inst) -> inst.removeModifier(AttributeEntry.ATTRIBUTE_UUID)));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"fateubw.command.attributes.reset", (Object[])new Object[]{players}), false);
        return 1;
    }

    private static int modifyCommandspell(CommandContext<CommandSourceStack> ctx, CommnandMode mode) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(ctx, (String)"players");
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        players.forEach(player -> {
            PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
            int count = switch (mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> amount;
                case 1 -> data.getCommandSeals() - amount;
                case 2 -> data.getCommandSeals() + amount;
            };
            data.setCommandSeals(count);
        });
        switch (mode.ordinal()) {
            case 0: {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"fateubw.command.spells.set", (Object[])new Object[]{players, amount}), false);
                break;
            }
            case 1: {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"fateubw.command.spells.take", (Object[])new Object[]{players, amount}), false);
                break;
            }
            case 2: {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"fateubw.command.spells.add", (Object[])new Object[]{players, amount}), false);
            }
        }
        return players.size();
    }

    private static enum CommnandMode {
        SET,
        TAKE,
        ADD;

    }
}

