/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity;

import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.api.datapack.ServantProperties;
import io.github.flemmli97.fateubw.api.entity.CommandType;
import io.github.flemmli97.fateubw.api.entity.ServantLike;
import io.github.flemmli97.fateubw.common.attachment.PlayerData;
import io.github.flemmli97.fateubw.common.datapack.DatapackHandler;
import io.github.flemmli97.fateubw.common.entity.HeldEquipmentHandler;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.SetTargetFromRider;
import io.github.flemmli97.fateubw.common.entity.utils.MoveStateTracker;
import io.github.flemmli97.fateubw.common.entity.utils.MoveType;
import io.github.flemmli97.fateubw.common.entity.utils.ServantModelLike;
import io.github.flemmli97.fateubw.common.entity.utils.TargetableOpponent;
import io.github.flemmli97.fateubw.common.lib.FateTags;
import io.github.flemmli97.fateubw.common.network.S2CAttackDebug;
import io.github.flemmli97.fateubw.common.network.S2CServantGui;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolder;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.fateubw.common.registry.FateActivities;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateMemoryTypes;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.ExtendedCombatRules;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.fateubw.common.world.GrailWarHandler;
import io.github.flemmli97.fateubw.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.AOEAttackEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.MoveControllerPlus;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetMoveToRestriction;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowEntity;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.InteractWithDoor;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public abstract class BaseServant
extends PathfinderMob
implements AnimatedEntity,
AOEAttackEntity,
TargetableOpponent,
EntityWeaponTrailHolderProvider,
ServantModelLike,
ServantLike<BaseServant>,
SmartBrainOwner<BaseServant>,
SyncedMobDataHandler {
    public static final int MOVE_TICK_MAX = 3;
    protected static final ResourceLocation MANA_LEECH_DEBUFF_ID = Fate.modRes("mana_leech_debuff");
    protected static final EntityDataAccessor<Boolean> SHOW_SERVANT = SynchedEntityData.defineId(BaseServant.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> STATIONARY = SynchedEntityData.defineId(BaseServant.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(BaseServant.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<Byte> MOVE_FLAGS = SynchedEntityData.defineId(BaseServant.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final TypedResource<TargetPosition> TARGET_POSITION = new TypedResource(Fate.modRes("target_position"));
    protected static final Vector4f SUMMON_COLOR = new Vector4f(0.23529412f, 0.4627451f, 0.78039217f, 0.8f);
    private final SyncedDataContainer<BaseServant> syncedDataContainer;
    private double servantMana = 100.0;
    private double manaRegenCounter;
    private double nobelPhantasmCooldown;
    private int manaLeechDebuffDuration;
    protected boolean commandNPUse;
    protected CommandType commandBehaviour = CommandType.NORMAL;
    protected AttackBehaviour attackBehaviour = AttackBehaviour.NORMAL;
    private Player owner;
    private final Component hogou;
    private final ServantProperties prop;
    public final Predicate<LivingEntity> targetPred = Utils.servantTargetPredicate((Mob)this);
    private final MoveStateTracker moveStateTracker = new MoveStateTracker(3, this::getMoveFlag);
    private final List<ServerPlayer> tracked = new ArrayList<ServerPlayer>();
    private boolean sendToOwnerData;
    private boolean initAnim;
    private final EntityWeaponTrailHolder<BaseServant> trailHolder = new EntityWeaponTrailHolder<BaseServant>(this);

    public BaseServant(EntityType<? extends BaseServant> entityType, Level level) {
        super(entityType, level);
        SyncedDataContainer.Builder builder = SyncedDataContainer.builder((Entity)this);
        this.definedAdditinoalSyncedData((SyncedDataContainer.Builder<BaseServant>)builder);
        this.syncedDataContainer = builder.build();
        this.moveControl = new MoveControllerPlus((Mob)this);
        this.xpReward = 35;
        this.prop = DatapackHandler.SERVANT_PROPS.get(this.getType());
        if (!level.isClientSide) {
            this.updateAttributes();
        }
        this.hogou = Component.translatable((String)(String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType())) + ".hogou"));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(FateAttributes.MAGIC_ATTACK.asHolder()).add(FateAttributes.MAGIC_RESISTANCE.asHolder()).add(FateAttributes.PROJECTILE_BLOCK_CHANCE.asHolder()).add(FateAttributes.PROJECTILE_RESISTANCE.asHolder()).add(FateAttributes.COMBAT_REGEN.asHolder()).add(FateAttributes.PASSIVE_REGEN.asHolder()).add(FateAttributes.MANA_REGEN.asHolder(), 1.0).add(FateAttributes.MANA_LEECH.asHolder(), 1.0);
    }

    private void updateAttributes() {
        this.prop.attributes().forEach((att, val) -> {
            AttributeInstance inst = this.getAttribute((Holder)att);
            if (inst != null) {
                inst.setBaseValue(val.doubleValue());
                if (att == Attributes.MAX_HEALTH) {
                    this.setHealth(this.getMaxHealth());
                }
            }
        });
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATIONARY, (Object)false);
        builder.define(SHOW_SERVANT, (Object)false);
        builder.define(OWNER_UUID, Optional.empty());
        builder.define(MOVE_FLAGS, (Object)0);
    }

    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseServant> builder) {
        builder.define(TARGET_POSITION, (SyncedEntityData)TenshilibSyncableEntityDatas.TARGET_POS.get(), null);
    }

    public SyncedDataContainer<?> getDataContainer() {
        return this.syncedDataContainer;
    }

    protected PathNavigation createNavigation(Level level) {
        SmoothGroundNavigation nav = new SmoothGroundNavigation((Mob)this, level);
        nav.setCanOpenDoors(true);
        nav.setCanPassDoors(true);
        return nav;
    }

    public List<? extends ExtendedSensor<? extends BaseServant>> getSensors() {
        return List.of(new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> entity.targetPred.test((LivingEntity)target)).setScanRate(e -> 10), new HurtBySensor().setPredicate((source, entity) -> {
            Entity patt0$temp = source.getEntity();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt0$temp;
                return !Utils.alliedTo((Entity)entity, (Entity)attacker);
            }
            return true;
        }));
    }

    public BrainActivityGroup<? extends BaseServant> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new FloatToSurfaceOfFluid(), new SetTargetFromRider(), new InteractWithDoor(), new FollowEntity().following(BaseServant::getOwner).teleportToTargetAfter(17.0).stopFollowingWithin(6.0).speedMod(1.1f).startCondition(m -> m.commandBehaviour == CommandType.FOLLOW), this.lookBehaviour(), new LookAtTarget().runFor(entity -> entity.getRandom().nextIntBetweenInclusive(40, 100)).whenStopping(m -> BrainUtils.clearMemory((LivingEntity)m, (MemoryModuleType)MemoryModuleType.LOOK_TARGET))});
    }

    protected ExtendedBehaviour<? extends BaseServant> lookBehaviour() {
        return new AllApplicableBehaviours(new ExtendedBehaviour[]{new LookAtAttackTarget(), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomLookTarget().lookChance((FloatProvider)ConstantFloat.of((float)1.0f)), new SetPlayerLookTarget()}).startCondition(m -> (double)m.getRandom().nextFloat() < 0.1 && !BrainUtils.hasMemory((LivingEntity)m, (MemoryModuleType)MemoryModuleType.WALK_TARGET))}).startCondition(e -> !BrainUtils.hasMemory((LivingEntity)e, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET) && !e.isSleeping() && !e.getAnimationHandler().hasAnimation());
    }

    public BrainActivityGroup<? extends BaseServant> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().attackablePredicate(entity -> {
            if (entity == BrainUtils.getMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY)) {
                return true;
            }
            if (entity instanceof Enemy && this.attackBehaviour == AttackBehaviour.AGGRESSIVE) {
                return true;
            }
            return entity instanceof ServantLike;
        }), new SetMoveToRestriction(), this.getWanderBehaviour().startCondition(m -> m.getRandom().nextInt(120) == 0)})});
    }

    public BrainActivityGroup<? extends BaseServant> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), this.getCooldownAI().startCondition(BehaviourUtils::runCooldownBehaviour).stopIf(e -> !BehaviourUtils.runCooldownBehaviour(e)), this.getCombatAI().startCondition(BehaviourUtils::runCombatBehaviour)});
    }

    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return new Idle();
    }

    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return new Idle();
    }

    public Map<Activity, BrainActivityGroup<? extends BaseServant>> getAdditionalTasks() {
        HashMap<Activity, BrainActivityGroup<? extends BaseServant>> map = new HashMap<Activity, BrainActivityGroup<? extends BaseServant>>();
        map.put((Activity)FateActivities.STAY.get(), new BrainActivityGroup((Activity)FateActivities.STAY.get()).priority(20).behaviours(new Behavior[]{new Idle()}).onlyStartWithMemoryStatus((MemoryModuleType)FateMemoryTypes.STAYING.get(), MemoryStatus.VALUE_PRESENT));
        return map;
    }

    public List<Activity> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new Activity[]{(Activity)FateActivities.STAY.get(), Activity.FIGHT, Activity.IDLE});
    }

    protected ExtendedBehaviour<? extends BaseServant> getWanderBehaviour() {
        return new SetRandomWalkTarget();
    }

    protected Brain.Provider<?> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public void tick() {
        if (!this.initAnim) {
            this.getAnimationHandler().withChangeListener(anim -> {
                if (!this.level().isClientSide && this.getTargetPosition() != null) {
                    this.setTargetPosition((TargetPosition)null);
                }
                if (anim != null) {
                    this.setupAttack((AnimationDefinition)anim);
                }
                return false;
            });
            this.initAnim = true;
        }
        super.tick();
        Vec3 lookDir = this.directionToLookAt();
        if (lookDir != null) {
            float[] yxRot = MathsHelper.YXRotFrom(lookDir);
            float[] clamp = this.targetLookClamp();
            this.setYRot(MathsHelper.rotlerp(this.getYRot(), yxRot[0], clamp[0]));
            this.setXRot(MathsHelper.rotlerp(this.getXRot(), yxRot[1], clamp[1]));
            this.setYBodyRot(this.getYRot());
            this.setYHeadRot(this.getYRot());
        }
        this.getAnimationHandler().tick();
        this.getTrailHolder().tick();
        this.moveStateTracker.tick();
        if (this.getSummonAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getSummonAnimation()})) {
            this.setDeltaMovement(Vec3.ZERO);
            this.getNavigation().stop();
        }
        this.trackingTick();
        if (this.level() instanceof ServerLevel) {
            ServerPlayer serverPlayer;
            this.nobelPhantasmCooldown -= 1.0;
            this.regenMana();
            --this.manaLeechDebuffDuration;
            if (this.manaLeechDebuffDuration == 0) {
                AttributeInstance inst = this.getAttribute(FateAttributes.MANA_LEECH.asHolder());
                inst.removeModifier(MANA_LEECH_DEBUFF_ID);
            }
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
            Player player = this.getOwner();
            if (player instanceof ServerPlayer && !this.tracked.contains(serverPlayer = (ServerPlayer)player) && !this.isRemoved() && this.sendToOwnerData) {
                S2CServantGui.sendServantGui(serverPlayer, this, false);
            }
            if (this.getTarget() != null && this.getTarget().getVehicle() instanceof LivingEntity) {
                this.setTarget((LivingEntity)this.getTarget().getVehicle());
            }
        }
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.tickBrain((LivingEntity)this);
        if (!(this.getControllingPassenger() instanceof Player) && this.isMoving() && this.isAlive()) {
            double speed = this.getMoveControl().getSpeedModifier();
            MoveType move = this.getMoveFromSpeed(speed);
            if (this.isImmobile()) {
                move = MoveType.NONE;
            }
            this.setMovingFlag(move);
        } else {
            this.setMovingFlag(MoveType.NONE);
            this.setShiftKeyDown(false);
            this.setSprinting(false);
        }
    }

    protected MoveType getMoveFromSpeed(double speed) {
        MoveType move = speed > 1.0 ? MoveType.RUN : (speed <= 0.8 ? MoveType.SNEAK : MoveType.WALK);
        return move;
    }

    protected boolean isMoving() {
        return this.getDeltaMovement().x != 0.0 || this.getDeltaMovement().z != 0.0;
    }

    @Override
    public float interpolatedMoveTick(float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTick(partialTicks);
    }

    @Override
    public float interpolatedMoveTickOf(MoveType moveType, float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTickOf(moveType, partialTicks);
    }

    public void setMovingFlag(MoveType type) {
        this.entityData.set(MOVE_FLAGS, (Object)((byte)type.ordinal()));
    }

    public MoveType getMoveFlag() {
        return MoveType.values()[(Byte)this.entityData.get(MOVE_FLAGS)];
    }

    protected Vec3 directionToLookAt() {
        return this.getAnimationHandler().hasAnimation() && this.getTargetPosition() != null ? this.getTargetPosition().asVec(this.position()).subtract(this.position()) : null;
    }

    protected float[] targetLookClamp() {
        return new float[]{60.0f, 30.0f};
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        ((Optional)this.entityData.get(OWNER_UUID)).ifPresent(uuid -> tag.putUUID("Owner", uuid));
        tag.putInt("Death", this.deathTime);
        tag.putString("Command", this.attackBehaviour.toString());
        tag.putDouble("Mana", this.servantMana);
        tag.putBoolean("Revealed", this.showServant());
        if (this.getEquipmentHandler() != null) {
            tag.put("EquipmentHandler", (Tag)this.getEquipmentHandler().save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Owner")) {
            this.entityData.set(OWNER_UUID, Optional.of(tag.getUUID("Owner")));
        }
        this.deathTime = tag.getInt("Death");
        try {
            this.onBehaviourCommand(CommandType.valueOf(tag.getString("Command")));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.servantMana = tag.getInt("Mana");
        this.entityData.set(SHOW_SERVANT, (Object)tag.getBoolean("Revealed"));
        if (this.getEquipmentHandler() != null) {
            this.getEquipmentHandler().read(tag.getCompound("EquipmentHandler"), (HolderLookup.Provider)this.registryAccess());
        }
    }

    public TargetPosition getTargetPosition() {
        return (TargetPosition)this.getDataContainer().get(TARGET_POSITION);
    }

    public void setTargetPositionFromAttackTarget() {
        LivingEntity target = this.getTarget();
        if (target != null) {
            this.setTargetPosition(target);
        } else {
            this.setTargetPosition(TargetPosition.of((Vec3)this.position().add(this.getViewVector(1.0f).scale(10.0))));
        }
    }

    public void setTargetPosition(LivingEntity target) {
        this.setTargetPosition(target == null ? null : TargetPosition.of((LivingEntity)target));
    }

    public void setTargetPosition(TargetPosition position) {
        this.getDataContainer().set(TARGET_POSITION, (Object)position);
    }

    @Nullable
    public Vec3 tryGetTargetPosition(LivingEntity target) {
        if (this.getTargetPosition() != null) {
            return this.getTargetPosition().asVec(this.position());
        }
        return target != null ? target.position() : null;
    }

    public boolean canAttack(LivingEntity target) {
        return super.canAttack(target) && this.isWithinRestriction(target.blockPosition());
    }

    public LivingEntity getTarget() {
        return BrainUtils.getTargetOfEntity((LivingEntity)this);
    }

    public void setTarget(@Nullable LivingEntity target) {
        super.setTarget(target);
        if (super.getTarget() == null) {
            BrainUtils.clearMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
        } else {
            BrainUtils.setMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET, (Object)super.getTarget());
        }
    }

    public void setupAttack(AnimationDefinition anim) {
        BrainUtils.clearMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.LOOK_TARGET);
        if (this.getTarget() != null) {
            this.setTargetPosition(this.getTarget());
        }
        this.getNavigation().stop();
    }

    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{this.getSummonAnimation()})) {
            return;
        }
        if (anim.isAt("attack")) {
            this.mobAttack(anim, this.getTarget(), this::doHurtTarget);
        }
    }

    public void mobAttack(AnimationState anim, LivingEntity target, Consumer<LivingEntity> cons) {
        OrientedBoundingBox obb = this.calculateAttackAABB(anim, this.tryGetTargetPosition(target), 0.2);
        this.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox(), entity -> this.targetPred.test((LivingEntity)entity) && obb.intersects(entity.getBoundingBox())).forEach(cons);
        if (!this.level().isClientSide) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
        }
    }

    public OrientedBoundingBox prepareAttackBox(String anim, Entity target, double grow, boolean debug) {
        OrientedBoundingBox obb = this.calculateAttackAABB(this.getAnimationHandler().createDefaulted(anim), target != null ? target.position() : null, grow);
        if (debug) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (Entity)this);
        }
        return obb;
    }

    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, @Nullable Vec3 target, double grow) {
        float yRot = this.getYHeadRot();
        float xRot = this.getXRot();
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            yRot = player.getYHeadRot();
            xRot = player.getXRot();
        } else if (target != null) {
            Vec3 dir = target.subtract(this.position()).normalize();
            float[] yXRot = MathsHelper.YXRotFrom(dir);
            yRot = yXRot[0];
            xRot = -yXRot[1];
        }
        double off = (double)this.getBbHeight() * 0.5;
        return new OrientedBoundingBox(this.attackBB(anim).inflate(grow, 0.0, grow).move(0.0, -off, grow), yRot, Mth.clamp((float)xRot, (float)-15.0f, (float)15.0f), this.position().add(0.0, off, 0.0));
    }

    public AABB attackBB(AnimationState anim) {
        double range = 1.0;
        return new AABB(-range * 0.5, -0.02, 0.0, range * 0.5, this.vehicleDependentHeight() + 0.02, range);
    }

    public final double vehicleDependentHeight() {
        double height = this.getBbHeight();
        Entity entity = this.getVehicle();
        if (entity != null) {
            height = this.getAttackBoundingBox().maxY - entity.getBoundingBox().minY;
        }
        return height;
    }

    public boolean doHurtTarget(Entity entity) {
        return Utils.runWithInvulTimer((Entity)this, entity, this::mobHurtTarget, 0);
    }

    protected boolean mobHurtTarget(Entity target) {
        boolean result;
        float damage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        DamageSource damageSource = this.damageSourceAttack(target);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)damage);
        }
        if (result = target.hurt(damageSource, damage *= this.damageModifier(target))) {
            Level level2;
            float knockback = this.getKnockback(target, damageSource);
            if (knockback > 0.0f && target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                livingEntity.knockback((double)knockback * 0.5, (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((level2 = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)target, (DamageSource)damageSource);
            }
            this.setLastHurtMob(target);
            this.onEntityHit(target, damage);
        }
        return result;
    }

    public float damageModifier(Entity target) {
        return 1.0f;
    }

    public void onEntityHit(Entity target, float damage) {
        this.playAttackSound();
        this.servantMana += this.getAttributeValue(FateAttributes.MANA_LEECH.asHolder());
    }

    protected DamageSource damageSourceAttack(Entity target) {
        return this.damageSources().mobAttack((LivingEntity)this);
    }

    protected void tryDisableShield(Player player, ItemStack stack, ItemStack playerUseItem) {
        if (!stack.isEmpty() && !playerUseItem.isEmpty() && stack.getItem() instanceof AxeItem && playerUseItem.is(Items.SHIELD)) {
            player.getCooldowns().addCooldown(Items.SHIELD, 100);
            this.level().broadcastEntityEvent((Entity)player, (byte)30);
        }
    }

    @Override
    public Predicate<LivingEntity> validTargetPredicate() {
        return this.targetPred;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (this.getSummonAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getSummonAnimation()})) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public boolean hurt(DamageSource damageSource, float damage) {
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(damageSource, damage);
        }
        if (damageSource.getEntity() == null || !damageSource.getEntity().getType().is(FateTags.EntityTypes.STRONG_MOB)) {
            damage *= 0.75f;
        }
        return super.hurt(damageSource, Math.min(50.0f, damage));
    }

    protected float getDamageAfterArmorAbsorb(DamageSource damageSource, float damageAmount) {
        if (!damageSource.is(DamageTypeTags.BYPASSES_ARMOR)) {
            this.hurtArmor(damageSource, damageAmount);
            damageAmount = ExtendedCombatRules.getDamageAfterArmor((LivingEntity)this, damageAmount, damageSource, this.getAttributeValue(Attributes.ARMOR), this.getAttributeValue(Attributes.ARMOR_TOUGHNESS));
        }
        return damageAmount;
    }

    public void knockback(double strength, double xRatio, double zRatio) {
        super.knockback(strength * 0.75, xRatio, zRatio);
    }

    @Override
    public ServantProperties props() {
        return this.prop;
    }

    @Override
    public Component nobelPhantasm() {
        return this.hogou;
    }

    @Override
    public void onPlayerCommand(ServerPlayer player, CommandType behaviour) {
        if (behaviour.isBehaviour) {
            this.onBehaviourCommand(behaviour);
        }
        if (behaviour == CommandType.KILL) {
            if (!player.getUUID().equals(this.getOwnerUUID())) {
                return;
            }
            this.hurt(FateDamageTypes.grail(this.registryAccess()), Float.MAX_VALUE);
        }
        if (behaviour == CommandType.NP) {
            if (!this.commandNPUse) {
                PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
                if (player.hasInfiniteMaterials() || data.useMana(this.props().manaCost()) && data.useCommandSeal()) {
                    player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.command.npsuccess").withStyle(ChatFormatting.RED));
                    this.commandNPUse = true;
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.command.npfail").withStyle(ChatFormatting.RED));
                }
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"fateubw.chat.command.npprep").withStyle(ChatFormatting.RED));
            }
        }
    }

    public void onBehaviourCommand(CommandType command) {
        if (!command.isBehaviour) {
            return;
        }
        this.commandBehaviour = command;
        switch (command) {
            case NORMAL: 
            case AGGRESSIVE: 
            case DEFENSIVE: {
                this.setTarget(null);
                this.getNavigation().stop();
                this.attackBehaviour = AttackBehaviour.of(command);
                break;
            }
            case FOLLOW: {
                this.setStaying(false);
                this.clearRestriction();
                break;
            }
            case STAY: {
                this.setStaying(true);
                break;
            }
            case GUARD: {
                this.setStaying(false);
                this.restrictTo(this.getOwner().blockPosition(), 8);
            }
        }
    }

    @Override
    public void shouldScheduleEntityDataSync(boolean sync) {
        this.sendToOwnerData = sync;
    }

    public boolean showServant() {
        return (Boolean)this.entityData.get(SHOW_SERVANT);
    }

    public void revealServant() {
        this.entityData.set(SHOW_SERVANT, (Object)true);
    }

    @Override
    public boolean isStaying() {
        return (Boolean)this.entityData.get(STATIONARY);
    }

    public void setStaying(boolean stay) {
        this.entityData.set(STATIONARY, (Object)stay);
        if (!this.level().isClientSide) {
            if (stay) {
                BrainUtils.setMemory((LivingEntity)this, (MemoryModuleType)((MemoryModuleType)FateMemoryTypes.STAYING.get()), (Object)Unit.INSTANCE);
            } else {
                BrainUtils.clearMemory((LivingEntity)this, (MemoryModuleType)((MemoryModuleType)FateMemoryTypes.STAYING.get()));
            }
        }
    }

    public boolean useMana(float amount) {
        if (this.servantMana < (double)amount) {
            return false;
        }
        this.servantMana -= (double)amount;
        this.manaRegenCounter = 40.0;
        return true;
    }

    protected void regenMana() {
        double d;
        this.manaRegenCounter -= 1.0;
        if (d <= 0.0) {
            this.regenMana(this.getAttributeValue(FateAttributes.MANA_REGEN.asHolder()));
            this.manaRegenCounter = 20.0;
        }
    }

    public void regenMana(Entity source) {
        double amount = this.getAttributeValue(FateAttributes.MANA_LEECH.asHolder());
        this.regenMana(amount);
    }

    public void regenMana(double amount) {
        this.servantMana = Mth.clamp((double)(this.servantMana + amount), (double)0.0, (double)100.0);
    }

    public int getMana() {
        return (int)this.servantMana;
    }

    public void applyManaLeechDebuff(int duration, double amount) {
        this.manaLeechDebuffDuration = duration;
        AttributeInstance inst = this.getAttribute(FateAttributes.MANA_LEECH.asHolder());
        inst.removeModifier(MANA_LEECH_DEBUFF_ID);
        inst.addTransientModifier(new AttributeModifier(MANA_LEECH_DEBUFF_ID, 1.0 - amount, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    }

    public boolean healthBelow(float percentage) {
        return this.getHealth() < this.getMaxHealth() * percentage;
    }

    public boolean canUseNobelPhantasm() {
        return this.nobelPhantasmCheck() || this.commandNPUse;
    }

    public boolean nobelPhantasmCheck() {
        return this.getMana() >= this.props().manaCost() && this.nobelPhantasmCooldown <= 0.0;
    }

    public boolean attemptUseNobelPhantasm() {
        if (!this.commandNPUse && !this.useMana(this.props().manaCost())) {
            return false;
        }
        if (!this.commandNPUse) {
            this.nobelPhantasmCooldown = this.nobelPhantasmCooldown();
        }
        this.commandNPUse = false;
        return true;
    }

    protected int nobelPhantasmCooldown() {
        return 200 + this.getRandom().nextInt(100);
    }

    public HeldEquipmentHandler getEquipmentHandler() {
        return null;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData data) {
        super.finalizeSpawn(world, difficulty, reason, data);
        this.populateDefaultEquipmentSlots(this.getRandom(), difficulty);
        for (EquipmentSlot type : EquipmentSlot.values()) {
            this.setDropChance(type, 0.0f);
        }
        this.setLeftHanded(false);
        if (this.getSummonAnimation() != null && (reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.MOB_SUMMONED)) {
            this.getAnimationHandler().setAnimation(this.getSummonAnimation());
        }
        return data;
    }

    @Override
    public Player getOwner() {
        Object owner;
        if (this.owner != null && this.owner.isAlive()) {
            return this.owner;
        }
        UUID ownerId = this.getOwnerUUID();
        if (ownerId != null && (owner = this.getServer() != null ? this.getServer().getPlayerList().getPlayer(ownerId) : this.level().getPlayerByUUID(ownerId)) != null) {
            this.setOwner((Player)owner);
        }
        return this.owner;
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    @Override
    public void setOwner(Player player) {
        if (player != null) {
            this.entityData.set(OWNER_UUID, Optional.of(player.getUUID()));
        } else {
            this.entityData.set(OWNER_UUID, Optional.empty());
        }
        this.owner = player;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.isShiftKeyDown() && player.getUUID().equals(this.getOwnerUUID())) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                S2CServantGui.sendServantGui(serverPlayer, this);
            }
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return InteractionResult.FAIL;
    }

    protected boolean isImmobile() {
        return super.isImmobile() || this.getSummonAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getSummonAnimation()});
    }

    public void startSeenByPlayer(ServerPlayer player) {
        this.tracked.add(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        this.tracked.remove(player);
    }

    public boolean removeWhenFarAway(double d) {
        return false;
    }

    protected void tickDeath() {
        if (this.level().isClientSide) {
            for (int i = 0; i < (int)(9.0f / (float)this.maxDeathTick() * (float)this.deathTime - 1.0f); ++i) {
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.29803923f, 0.5019608f, 0.8117647f, 0.3f)).addData((AdvancedParticleData)new ScaleData(0.15f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), this.getX(this.random.nextDouble() * 3.0 - 1.5), this.getY(this.random.nextDouble() * 3.0 - 1.5), this.getZ(this.random.nextDouble() * 3.0 - 1.5));
            }
        }
        ++this.deathTime;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.deathTime == 1) {
                GrailWarHandler handler = GrailWarHandler.get(serverLevel.getServer());
                if (handler.isParticipant((Entity)this) || this.getLastDamageSource() != null && this.getLastDamageSource().is(FateDamageTypes.GRAIL)) {
                    handler.broadcastParticipants((Component)Component.translatable((String)"fateubw.chat.servant.death").withStyle(ChatFormatting.RED));
                }
                this.playSound(SoundEvents.WITHER_SPAWN, 1.0f, 1.0f);
                this.getAnimationHandler().setAnimation(this.getDeathAnimation());
            }
            if ((this.getLastDamageSource() == null || !this.getLastDamageSource().is(FateDamageTypes.GRAIL)) && this.deathTime > 15 && this.deathTime % 5 == 0 && (this.lastHurtByPlayerTime > 0 || this.isAlwaysExperienceDropper()) && this.shouldDropExperience() && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                int splitExp;
                for (int exp = this.xpReward; exp > 0; exp -= splitExp) {
                    splitExp = ExperienceOrb.getExperienceValue((int)exp);
                    this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY(), this.getZ(), splitExp));
                }
            }
            AnimationState anim = this.getAnimationHandler().getAnimation();
            if (this.deathTime >= this.maxDeathTick() && (anim == null || anim.done(0))) {
                this.remove(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public int maxDeathTick() {
        return 200;
    }

    public boolean shouldDropExperience() {
        if (this.getServer() != null && GrailWarHandler.get(this.getServer()).isParticipant((Entity)this)) {
            return false;
        }
        return super.shouldDropExperience();
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource damageSource) {
        if (damageSource.is(FateDamageTypes.GRAIL) || this.getServer() != null && GrailWarHandler.get(this.getServer()).isParticipant((Entity)this)) {
            return;
        }
        super.dropAllDeathLoot(level, damageSource);
    }

    @Nullable
    public ItemStack getPickResult() {
        return SpawnEgg.fromType((EntityType)this.getType()).map(ItemStack::new).orElse(null);
    }

    protected String getSummonAnimation() {
        return null;
    }

    public double getSummonProgress(float partialTicks) {
        String summon = this.getSummonAnimation();
        if (summon != null && this.getAnimationHandler().isCurrent(new String[]{summon})) {
            return this.getAnimationHandler().getAnimation().progress(partialTicks);
        }
        return -1.0;
    }

    public Vector4f summonColor() {
        return SUMMON_COLOR;
    }

    public EntityWeaponTrailHolder<BaseServant> getTrailHolder() {
        return this.trailHolder;
    }

    public static enum AttackBehaviour {
        NORMAL,
        AGGRESSIVE,
        DEFENSIVE;


        @Nullable
        public static AttackBehaviour of(CommandType type) {
            return switch (type) {
                case CommandType.NORMAL -> NORMAL;
                case CommandType.AGGRESSIVE -> AGGRESSIVE;
                case CommandType.DEFENSIVE -> DEFENSIVE;
                default -> null;
            };
        }
    }
}

