/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.ai.behaviour;

import io.github.flemmli97.tenshilib.common.entity.AOEAttackEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.MoveToAttackTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.MoveToWalkTargetWithSight;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.PlayAnimation;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetAnimationToPlay;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.registry.TenshilibMemoryModules;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class BehaviourUtils {
    public static <E extends Mob> PlayAnimation<E> cooldownedPlay(boolean requireInRange, int min, int max) {
        return BehaviourUtils.cooldownedPlay(requireInRange, (String s, E entity) -> min + entity.getRandom().nextInt(max - min));
    }

    public static <E extends Mob> PlayAnimation<E> cooldownedPlay(Predicate<E> condition, int min, int max) {
        return BehaviourUtils.cooldownedPlay(condition, (String s, E entity) -> min + entity.getRandom().nextInt(max - min));
    }

    public static <E extends Mob> PlayAnimation<E> cooldownedPlay(boolean requireInRange, ToIntBiFunction<String, E> cooldownFunc) {
        return BehaviourUtils.cooldownedPlay(requireInRange ? entity -> {
            LivingEntity living;
            AnimationPlayHolder anim = (AnimationPlayHolder)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)TenshilibMemoryModules.ANIMATION_TO_PLAY.get()));
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            if (target == null) {
                return false;
            }
            if (entity instanceof AOEAttackEntity) {
                AOEAttackEntity aoeEntity = (AOEAttackEntity)entity;
                return aoeEntity.prepareAttackBox(anim.animation(), (Entity)target, -0.15, true).intersects(target.getBoundingBox());
            }
            return target instanceof LivingEntity && entity.isWithinMeleeAttackRange(living = target);
        } : null, cooldownFunc);
    }

    public static <E extends Mob> PlayAnimation<E> cooldownedPlay(Predicate<E> condition, ToIntBiFunction<String, E> cooldownFunc) {
        PlayAnimation behaviour = new PlayAnimation().withCallback(BehaviourUtils.cooldownHandler(cooldownFunc)).withCallback(BehaviourUtils.cooldownHandlerCont());
        if (condition != null) {
            behaviour.startCondition(condition);
        }
        return behaviour;
    }

    public static <E extends Mob> PlayAnimation.OnStart<E> cooldownHandler(ToIntBiFunction<String, E> cooldownFunc) {
        return (animation, entity) -> {
            double calc = cooldownFunc.applyAsInt(animation, entity);
            int cooldown = Mth.ceil((double)(calc += ((AnimatedEntity)entity).getAnimationHandler().get(animation).length()));
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)cooldown);
        };
    }

    public static <E extends Mob> PlayAnimation.OnContinue<E> cooldownHandlerCont() {
        return (animation, chains, entity) -> {
            if (chains != null) {
                double add = 0.0;
                for (AnimationPlayHolder.AnimationHolder chain : chains) {
                    add += ((AnimatedEntity)entity).getAnimationHandler().get(chain.animation()).length();
                }
                BehaviourUtils.modifyExpiringMemory(entity, MemoryModuleType.ATTACK_COOLING_DOWN, Mth.ceil((double)add));
            }
        };
    }

    @SafeVarargs
    public static <E extends Mob> SetAnimationToPlay<E> of(AnimationPlayHolder<E> ... animations) {
        return new SetAnimationToPlay(animations);
    }

    public static <E extends LivingEntity> ToIntBiFunction<E, LivingEntity> closeEnough(int dist) {
        return (entity, target) -> dist;
    }

    public static <E extends LivingEntity> Predicate<E> ifCloserThan(double dist) {
        return entity -> {
            LivingEntity target;
            double distance = dist + (double)entity.getBbWidth() * 0.5;
            LivingEntity livingEntity = target = BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET) ? BrainUtils.getTargetOfEntity((LivingEntity)entity) : null;
            if (target == null && entity instanceof Mob) {
                Mob mob = (Mob)entity;
                target = mob.getTarget();
            }
            if (target == null) {
                return false;
            }
            return entity.distanceToSqr((Entity)target) <= (distance += (double)target.getBbWidth() * 0.5) * distance;
        };
    }

    public static <E extends LivingEntity> Predicate<E> ifFurtherThan(double dist) {
        return entity -> {
            LivingEntity target;
            double distance = dist + (double)entity.getBbWidth() * 0.5;
            LivingEntity livingEntity = target = BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET) ? BrainUtils.getTargetOfEntity((LivingEntity)entity) : null;
            if (target == null && entity instanceof Mob) {
                Mob mob = (Mob)entity;
                target = mob.getTarget();
            }
            if (target == null) {
                return false;
            }
            return entity.distanceToSqr((Entity)target) >= (distance += (double)target.getBbWidth() * 0.5) * distance;
        };
    }

    public static <E extends LivingEntity> Predicate<E> ifFurtherThan(double dist, double verticalDist) {
        return entity -> {
            LivingEntity target;
            double distance = dist + (double)entity.getBbWidth() * 0.5;
            LivingEntity livingEntity = target = BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET) ? BrainUtils.getTargetOfEntity((LivingEntity)entity) : null;
            if (target == null && entity instanceof Mob) {
                Mob mob = (Mob)entity;
                target = mob.getTarget();
            }
            if (target == null) {
                return false;
            }
            return entity.distanceToSqr(target.getX(), entity.getY(), target.getZ()) >= (distance += (double)target.getBbWidth() * 0.5) * distance && Math.abs(entity.getY() - target.getY()) <= verticalDist;
        };
    }

    public static <E extends LivingEntity> Consumer<ExtendedBehaviour<E>> withCondition(Predicate<E> test) {
        return behaviour -> {
            behaviour.startCondition(test);
            behaviour.stopIf(e -> !test.test(e));
        };
    }

    public static <E extends PathfinderMob & AnimatedEntity> MoveToAttackTarget<E> timedMoveAttack() {
        return BehaviourUtils.timedMoveAttack(25, 40);
    }

    public static <E extends PathfinderMob & AnimatedEntity> MoveToAttackTarget<E> timedMoveAttack(int min, int max) {
        MoveToAttackTarget<E> behaviour = BehaviourUtils.moveAttack();
        behaviour.runFor(e -> min + e.getRandom().nextInt(max - min));
        return behaviour;
    }

    public static <E extends PathfinderMob & AnimatedEntity> MoveToAttackTarget<E> moveAttack() {
        return new MoveToAttackTarget();
    }

    public static <E extends PathfinderMob> MoveToWalkTargetWithSight<E> moveTo() {
        return new MoveToWalkTargetWithSight();
    }

    public static <T> void modifyExpiringMemory(Mob mob, MemoryModuleType<T> memory, int modifier) {
        long current = BrainUtils.getTimeUntilMemoryExpires((LivingEntity)mob, memory);
        if (current > 0L) {
            if ((current += (long)modifier) <= 0L) {
                BrainUtils.clearMemory((LivingEntity)mob, memory);
            } else {
                Object value = BrainUtils.getMemory((LivingEntity)mob, memory);
                BrainUtils.setForgettableMemory((LivingEntity)mob, memory, (Object)value, (int)Math.toIntExact(current));
            }
        }
    }

    public static <T extends LivingEntity> boolean runCooldownBehaviour(T entity) {
        return !((AnimatedEntity)entity).getAnimationHandler().hasAnimation() && (BrainUtils.hasMemory(entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN) || !BrainUtils.hasMemory(entity, (MemoryModuleType)((MemoryModuleType)TenshilibMemoryModules.ANIMATION_TO_PLAY.get())));
    }

    public static <T extends Mob> boolean runCombatBehaviour(T entity) {
        return !((AnimatedEntity)entity).getAnimationHandler().hasAnimation() && entity.getTarget() != null && !BrainUtils.hasMemory(entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN);
    }
}

