/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.ai.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetTargetFromRider<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORIES = MemoryTest.builder((int)1).usesMemories(new MemoryModuleType[]{MemoryModuleType.ATTACK_TARGET});
    private LivingEntity target;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        LivingEntity currentTarget = BrainUtils.getTargetOfEntity(owner);
        LivingEntity controller = owner.getControllingPassenger();
        if (controller == null) {
            return false;
        }
        LivingEntity livingEntity = this.target = BrainUtils.hasMemory((LivingEntity)controller, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET) ? BrainUtils.getTargetOfEntity((LivingEntity)controller) : null;
        if (this.target == null && controller instanceof Mob) {
            Mob mob = (Mob)controller;
            this.target = mob.getTarget();
        }
        return currentTarget != this.target;
    }

    protected void start(E entity) {
        if (this.target == null) {
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
        } else {
            BrainUtils.setTargetOfEntity(entity, (LivingEntity)this.target);
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        }
    }
}

