/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.ai.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetWalkToFront<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORIES = MemoryTest.builder((int)1).hasMemory(MemoryModuleType.ATTACK_TARGET);
    protected BiFunction<E, LivingEntity, Float> distance = (owner, target) -> Float.valueOf(5.0f);
    protected BiFunction<E, LivingEntity, Float> speedMod = (owner, target) -> Float.valueOf(1.0f);

    public SetWalkToFront<E> distance(float distance) {
        return this.distance((owner, target) -> Float.valueOf(distance));
    }

    public SetWalkToFront<E> distance(BiFunction<E, LivingEntity, Float> distance) {
        this.distance = distance;
        return this;
    }

    public SetWalkToFront<E> speedMod(float speedModifier) {
        return this.speedMod((owner, target) -> Float.valueOf(speedModifier));
    }

    public SetWalkToFront<E> speedMod(BiFunction<E, LivingEntity, Float> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected void start(E entity) {
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        Vec3 look = target.getViewVector(1.0f).scale((double)this.distance.apply(entity, target).floatValue());
        Vec3 vec3 = target.position().add(look);
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(vec3, this.speedMod.apply(entity, target).floatValue(), 0));
    }
}

