/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.ai.behaviour;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.fateubw.common.utils.TeleportUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class TeleportBehaviour<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORIES = MemoryTest.builder((int)1).hasMemories(new MemoryModuleType[]{MemoryModuleType.ATTACK_TARGET});
    private double minDistSqr = 9.0;
    private double maxDistSqr = 100.0;
    private int teleportMin = 5;
    private int teleportMax = 10;

    public TeleportBehaviour<E> min(double min) {
        this.minDistSqr = min * min;
        return this;
    }

    public TeleportBehaviour<E> max(double max) {
        this.maxDistSqr = max * max;
        return this;
    }

    public TeleportBehaviour<E> teleportMin(int teleportMin) {
        this.teleportMin = teleportMin;
        return this;
    }

    public TeleportBehaviour<E> teleportMax(int teleportMax) {
        this.teleportMax = Math.max(this.teleportMin + 1, teleportMax);
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected void start(E entity) {
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        for (int i = 0; i < 32; ++i) {
            Vec3 posAway = !entity.isWithinRestriction() && (double)entity.getRandom().nextFloat() < 0.5 ? DefaultRandomPos.getPosTowards(entity, (int)(entity.getRandom().nextInt(this.teleportMax - this.teleportMin) + this.teleportMin), (int)8, (Vec3)Vec3.atCenterOf((Vec3i)entity.getRestrictCenter()), (double)1.5707963705062866) : (target.distanceToSqr(entity) > this.maxDistSqr ? DefaultRandomPos.getPosTowards(entity, (int)(entity.getRandom().nextInt(this.teleportMax - this.teleportMin) + this.teleportMin), (int)8, (Vec3)target.position(), (double)1.5707963705062866) : DefaultRandomPos.getPosAway(entity, (int)(entity.getRandom().nextInt(this.teleportMax - this.teleportMin) + this.teleportMin), (int)8, (Vec3)target.position()));
            if (posAway == null || !(target.distanceToSqr(posAway) >= this.minDistSqr) || !entity.isWithinRestriction(BlockPos.containing((Position)posAway))) continue;
            TeleportUtils.teleportTo(entity, posAway.x(), posAway.y(), posAway.z(), SoundEvents.ENDERMAN_TELEPORT, (ParticleOptions)ParticleTypes.WITCH);
        }
    }
}

