/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.misc;

import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.utils.Utils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class ArcherArrow
extends AbstractArrow {
    public ArcherArrow(EntityType<? extends ArcherArrow> type, Level level) {
        super(type, level);
    }

    public ArcherArrow(Level level, LivingEntity shootingEntity, ItemStack weapon) {
        super((EntityType)FateEntities.ARCHER_ARROW.get(), shootingEntity, level, Items.ARROW.getDefaultInstance(), weapon);
    }

    protected ItemStack getDefaultPickupItem() {
        return this.getPickupItemStackOrigin();
    }

    public ItemStack getPickupItemStackOrigin() {
        return ItemStack.EMPTY;
    }

    protected void onHitEntity(EntityHitResult result) {
        Utils.runWithInvulTimer(this.getOwner(), result.getEntity(), this::damageTarget, this.getOwner() instanceof Player ? 20 : 0);
    }

    protected boolean damageTarget(Entity target) {
        int crit;
        Level level;
        if (target == this.getOwner()) {
            return false;
        }
        double speed = this.getDeltaMovement().length();
        double damage = this.getBaseDamage();
        Entity owner = this.getOwner();
        DamageSource damageSource = FateDamageTypes.indirect(FateDamageTypes.ARCHER_NORMAL, (Entity)this, (Entity)(owner == null ? this : owner));
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)((float)damage));
        }
        damage = Mth.clamp((double)(speed * damage), (double)0.0, (double)Double.MAX_VALUE);
        if (this.isCritArrow() && Double.isInfinite(damage = Math.min((double)(crit = this.random.nextInt(Mth.ceil((double)damage) / 2 + 2)) + damage, Double.MAX_VALUE))) {
            damage = Double.MAX_VALUE;
        }
        if (owner instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)owner;
            living.setLastHurtMob(target);
        }
        int firePre = target.getRemainingFireTicks();
        if (target.hurt(damageSource, (float)damage)) {
            if (this.isOnFire()) {
                target.igniteForSeconds(5.0f);
            }
            if (target instanceof LivingEntity) {
                Level level2;
                LivingEntity livingTarget = (LivingEntity)target;
                if (!this.level().isClientSide) {
                    livingTarget.setArrowCount(livingTarget.getArrowCount() + 1);
                }
                if ((level2 = this.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel2 = (ServerLevel)level2;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel2, (Entity)livingTarget, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingTarget);
                if (livingTarget != owner && livingTarget instanceof Player && owner instanceof ServerPlayer && !this.isSilent()) {
                    ((ServerPlayer)owner).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
            }
            this.playSound(SoundEvents.ARROW_HIT, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            this.discard();
            return true;
        }
        target.setRemainingFireTicks(firePre);
        this.deflect(ProjectileDeflection.REVERSE, target, this.getOwner(), false);
        this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
        if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
            this.discard();
        }
        return false;
    }
}

