/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.misc;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.misc.BaseProjectile;
import io.github.flemmli97.fateubw.common.entity.utils.EntityTrailHandler;
import io.github.flemmli97.fateubw.common.particles.trail.TrailPositions;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.registry.FateSounds;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.common.utils.ItemUtils;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BabylonWeapon
extends BaseProjectile {
    protected static final EntityDataAccessor<ItemStack> WEAPON_TYPE = SynchedEntityData.defineId(BabylonWeapon.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    protected static final EntityDataAccessor<Integer> SHOOT_TIME = SynchedEntityData.defineId(BabylonWeapon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> PREPARING = SynchedEntityData.defineId(BabylonWeapon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> DESPAWN = SynchedEntityData.defineId(BabylonWeapon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<BlockPos> GROUND = SynchedEntityData.defineId(BabylonWeapon.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private LivingEntity target;
    public final int renderRand;
    private final BlockState particleState;
    private int preparationTick;
    private int despawnTimer;
    private final EntityTrailHandler trailHandler;

    public BabylonWeapon(EntityType<? extends BabylonWeapon> type, Level level) {
        super(type, level);
        this.renderRand = this.random.nextInt(1000);
        this.particleState = Blocks.GOLD_BLOCK.defaultBlockState();
        this.trailHandler = new EntityTrailHandler((Entity)this, 12);
    }

    public BabylonWeapon(Level level, LivingEntity shootingEntity) {
        super((EntityType<? extends BaseProjectile>)((EntityType)FateEntities.BABYLON.get()), level, shootingEntity);
        this.renderRand = this.random.nextInt(1000);
        this.particleState = Blocks.GOLD_BLOCK.defaultBlockState();
        this.trailHandler = new EntityTrailHandler((Entity)this, 12);
        this.entityData.set(SHOOT_TIME, (Object)(this.random.nextInt(15) + 15));
    }

    public BabylonWeapon(Level level, LivingEntity shootingEntity, LivingEntity target) {
        this(level, shootingEntity);
        this.target = target;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WEAPON_TYPE, (Object)ItemStack.EMPTY);
        builder.define(PREPARING, (Object)true);
        builder.define(SHOOT_TIME, (Object)20);
        builder.define(DESPAWN, (Object)false);
        builder.define(GROUND, (Object)BlockPos.ZERO);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key == GROUND) {
            this.setInGround((BlockPos)this.entityData.get(GROUND));
        }
    }

    public boolean preparing() {
        return (Boolean)this.entityData.get(PREPARING);
    }

    public int livingTickMax() {
        return this.inGround ? Integer.MAX_VALUE : 250;
    }

    public void tick() {
        if (this.preparing()) {
            this.updatePreparation();
        } else {
            Entity thrower;
            if (!(this.level().isClientSide || (thrower = this.getOwner()) != null && thrower.isAlive())) {
                this.discard();
                return;
            }
            if (this.firstTick) {
                this.trailHandler.tick();
            }
            if (this.level().isClientSide && !this.inGround) {
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.particleState), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
            super.tick();
            this.trailHandler.tick();
        }
        if (this.despawning()) {
            ++this.despawnTimer;
            if (!this.level().isClientSide) {
                if (this.despawnTimer >= 40) {
                    this.discard();
                }
            } else if (this.random.nextBoolean()) {
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(1.0f, 0.85f, 0.3f, 0.5f)).addData((AdvancedParticleData)new ScaleData(0.15f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, this.random.nextGaussian() * 0.01, this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), this.getX(this.random.nextGaussian()), this.getY(this.random.nextGaussian()), this.getZ(this.random.nextGaussian()));
            }
        }
    }

    protected void tickInGround() {
        super.tickInGround();
        if (!this.level().isClientSide() && this.ticksInGround > 40 && !this.despawning()) {
            this.entityData.set(DESPAWN, (Object)true);
        }
    }

    protected void resetInGround() {
        this.entityData.set(DESPAWN, (Object)true);
    }

    public void moveEntity() {
        if (this.inGround) {
            return;
        }
        super.moveEntity();
    }

    public boolean despawning() {
        return (Boolean)this.entityData.get(DESPAWN);
    }

    public float despawnProgress() {
        return Math.min(1.0f, (float)this.despawnTimer / 40.0f);
    }

    public float preparationState(float partialTicks) {
        if (!this.preparing()) {
            return 1.0f;
        }
        return Mth.clamp((float)(((float)this.preparationTick + partialTicks) / (float)((Integer)this.entityData.get(SHOOT_TIME)).intValue()), (float)0.0f, (float)1.0f);
    }

    private void updatePreparation() {
        ++this.preparationTick;
        Vec3 motion = this.getDeltaMovement();
        double f = Math.sqrt(BabylonWeapon.horizontalMag((Vec3)motion));
        this.setYRot(this.updateRotation(this.yRotO, (float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.2957763671875)));
        this.setXRot(this.updateRotation(this.xRotO, (float)(Mth.atan2((double)motion.y, (double)f) * 57.2957763671875)));
        if (this.level().isClientSide) {
            AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.92156863f, 0.92156863f, 0.0f, 1.0f)).addData((AdvancedParticleData)new ScaleData(0.15f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, this.random.nextGaussian() * 0.01, this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), this.getX(), this.getY(), this.getZ());
        } else {
            if (this.tickCount == 1) {
                this.playSound((SoundEvent)FateSounds.ENTITY_BABYLON_SPAWN.get(), 0.7f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.9f);
            }
            if (this.preparing() && this.preparationTick >= (Integer)this.entityData.get(SHOOT_TIME)) {
                this.entityData.set(PREPARING, (Object)false);
                Entity thrower = this.getOwner();
                if (thrower instanceof Player) {
                    HitResult hit = HitResultUtils.entityRayTrace((Entity)thrower, (double)64.0, (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE, (boolean)false, (boolean)false, null);
                    this.shootAtPosition(hit.getLocation().x, hit.getLocation().y, hit.getLocation().z, 1.0f, 6.0f);
                } else if (this.target != null) {
                    this.shootAtEntity((Entity)this.target, 1.0f, 6.0f);
                } else {
                    this.discard();
                }
                this.playSound((SoundEvent)FateSounds.ENTITY_BABYLON_SHOOT.get(), 0.8f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
            }
        }
    }

    public void shootAtEntity(Entity target, float velocity, float inaccuracy, boolean ignoreGravity) {
        Vec3 targetPos = EntityUtils.getStraightProjectileTarget((Vec3)this.position(), (Entity)target).add(target.getDeltaMovement().scale(2.0));
        this.shootAtPosition(targetPos.x(), targetPos.y(), targetPos.z(), velocity, inaccuracy, ignoreGravity);
    }

    private float updateRotation(float prev, float current) {
        while (current - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (current - prev >= 180.0f) {
            prev += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)prev, (float)current);
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected float motionReduction(boolean inWater) {
        return 1.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        DamageSource source = FateDamageTypes.indirect(FateDamageTypes.BABYLON, (Entity)this, this.getOwner());
        float damage = (float)ItemUtils.damage((Level)this.level(), null, (Entity)result.getEntity(), (DamageSource)source, (ItemStack)this.getWeapon());
        boolean res = Utils.runWithInvulTimer(this.getOwner(), result.getEntity(), e -> e.hurt(source, damage * CommonConfig.babylonScale), 2);
        if (res) {
            Entity entity = result.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                entity2.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40));
            }
            if ((entity = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)entity;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)result.getEntity(), (DamageSource)source);
            }
        }
        this.discard();
        return true;
    }

    protected void onBlockHit(BlockHitResult result) {
        Vec3 vec3 = result.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(vec3);
        Vec3 vec32 = vec3.normalize().scale(0.2);
        this.setPosRaw(result.getLocation().x() - vec32.x, result.getLocation().y() - vec32.y, result.getLocation().z() - vec32.z);
        this.setInGround(result.getBlockPos());
    }

    public void setInGround(BlockPos pos) {
        super.setInGround(pos);
        this.inGround = true;
        if (!this.level().isClientSide) {
            this.entityData.set(GROUND, (Object)(this.inGround ? pos : BlockPos.ZERO));
        }
    }

    public ItemStack getWeapon() {
        return (ItemStack)this.entityData.get(WEAPON_TYPE);
    }

    public void setWeapon(ItemStack stack) {
        if (!stack.isEmpty()) {
            this.entityData.set(WEAPON_TYPE, (Object)stack);
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("Weapon", (Tag)ItemStack.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.getWeapon()).getOrThrow());
        compound.putBoolean("Preparing", this.preparing());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setWeapon((ItemStack)ItemStack.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("Weapon")).getOrThrow());
        this.entityData.set(PREPARING, (Object)compound.getBoolean("Preparing"));
    }

    public TrailPositions trailPositions() {
        return this.trailHandler.getPositions();
    }

    public static void spawnWeapons(LivingEntity thrower, LivingEntity target, int amount, int range) {
        for (Vec3 offset : Utils.randomSidedPositions(thrower, amount, range)) {
            BabylonWeapon weapon = new BabylonWeapon(thrower.level(), thrower, target);
            weapon.setPos(offset.x, offset.y + (double)thrower.getBbHeight() * 0.5, offset.z);
            Vec3 dir = Vec3.directionFromRotation((float)0.0f, (float)thrower.getYRot());
            weapon.shoot(dir.x(), dir.y(), dir.z(), 0.02f, 0.0f);
            weapon.setWeapon(CommonConfig.babylonWeapons.getRandomWeapon(weapon.random));
            weapon.level().addFreshEntity((Entity)weapon);
        }
    }

    public static void spawnWeaponsAround(LivingEntity thrower, LivingEntity target, int amount, int range) {
        int targetSize = Math.max(Mth.ceil((float)target.getBbHeight()), Mth.ceil((float)target.getBbWidth()));
        range = Math.max(targetSize + 3, range);
        ArrayList<Pair> angles = new ArrayList<Pair>(amount);
        block0: for (int i = 0; i < amount; ++i) {
            float yRot = thrower.getRandom().nextFloat() * 360.0f;
            float xRot = thrower.getRandom().nextFloat() * 70.0f + 20.0f;
            int retry = 0;
            do {
                float greatDist = Float.MAX_VALUE;
                for (Pair p : angles) {
                    float d;
                    if (p == null || !((d = BabylonWeapon.greatCircDist(yRot, xRot, ((Float)p.getFirst()).floatValue(), ((Float)p.getSecond()).floatValue())) < greatDist)) continue;
                    greatDist = d;
                }
                if (!(greatDist * (float)range > 2.0f)) continue;
                angles.add(Pair.of((Object)Float.valueOf(yRot), (Object)Float.valueOf(xRot)));
                continue block0;
            } while (++retry <= 10);
        }
        Vec3 pos = target.position();
        for (Pair offset : angles) {
            if (offset == null) continue;
            BabylonWeapon weapon = new BabylonWeapon(thrower.level(), thrower, target);
            Vec3 dir = Vec3.directionFromRotation((float)(-((Float)offset.getSecond()).floatValue()), (float)((Float)offset.getFirst()).floatValue());
            Vec3 area = pos.add(dir.scale((double)range));
            weapon.setPos(area.x, area.y, area.z);
            weapon.shoot(-dir.x(), -dir.y(), -dir.z(), 0.02f, 0.0f);
            weapon.setWeapon(CommonConfig.babylonWeapons.getRandomWeapon(weapon.random));
            weapon.level().addFreshEntity((Entity)weapon);
        }
    }

    private static float greatCircDist(float yRot1, float xRot1, float yRot2, float xRot2) {
        return (float)Math.acos(Mth.sin((float)xRot1) * Mth.sin((float)xRot2) + Mth.cos((float)xRot1) * Mth.cos((float)xRot2) * Mth.cos((float)Mth.abs((float)(yRot1 - yRot2))));
    }
}

