/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.misc;

import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.misc.BaseProjectile;
import io.github.flemmli97.fateubw.common.network.S2CScreenShake;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.utils.Utils;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class CaladBolg
extends BaseProjectile {
    public CaladBolg(EntityType<? extends CaladBolg> type, Level level) {
        super(type, level);
    }

    public CaladBolg(Level level, LivingEntity shootingEntity) {
        super((EntityType<? extends BaseProjectile>)((EntityType)FateEntities.CALADBOLG.get()), level, shootingEntity);
    }

    public int livingTickMax() {
        return 100;
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        this.doExplosion(result.getEntity().getX(), result.getEntity().getY(), result.getEntity().getZ(), result.getEntity());
        return true;
    }

    protected void onBlockHit(BlockHitResult result) {
        this.doExplosion(result.getLocation().x, result.getLocation().y, result.getLocation().z, null);
    }

    private void doExplosion(double x, double y, double z, Entity hit) {
        this.doExplosion(hit);
        this.level().playSound(null, x, y, z, (Holder)SoundEvents.GENERIC_EXPLODE, this.getSoundSource(), 1.0f, 1.0f);
        this.discard();
        S2CScreenShake.sendAround((Entity)this, 9.0, 8, 2.0f);
    }

    protected void doExplosion(Entity hit) {
        float dmg = Utils.magicDamage(this.getOwner()) + CommonConfig.caladBolgDmg;
        if (hit != null) {
            hit.hurt(FateDamageTypes.indirect(FateDamageTypes.CALADBOLG, (Entity)this, this.getOwner()), dmg);
        }
        Vec3 pos = hit != null ? hit.position() : this.position();
        List list = this.level().getEntities((Entity)this, new AABB(-6.0, -6.0, -6.0, 6.0, 6.0, 6.0).move(pos));
        for (Entity e : list) {
            double dist = e.distanceToSqr((Entity)this);
            if (dist > 36.0 || e != hit && !this.canHit(e)) continue;
            float dmgPerc = (float)Mth.clamp((double)(1.0 - (dist -= 8.0) / 26.0), (double)0.15f, (double)1.0);
            e.hurt(FateDamageTypes.indirect(FateDamageTypes.CALADBOLG, (Entity)this, this.getOwner()), dmg * dmgPerc);
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, pos.x(), pos.y(), pos.z(), 2, 1.0, 0.0, 0.0, 1.0);
        }
    }
}

