/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.misc;

import io.github.flemmli97.fateubw.common.attachment.PlayerData;
import io.github.flemmli97.fateubw.common.entity.misc.BaseProjectile;
import io.github.flemmli97.fateubw.common.entity.utils.OnProjectileHit;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.utils.MathsHelper;
import io.github.flemmli97.fateubw.platform.Platform;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ChainDagger
extends BaseProjectile {
    private static final EntityDataAccessor<Boolean> RETRACTING = SynchedEntityData.defineId(ChainDagger.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> MAINHAND = SynchedEntityData.defineId(ChainDagger.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> HOOKED_ENTITY = SynchedEntityData.defineId(ChainDagger.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean retractPrev;
    private Entity hookedEntity;

    public ChainDagger(EntityType<? extends ChainDagger> type, Level level) {
        super(type, level);
    }

    public ChainDagger(Level level, LivingEntity shooter, boolean mainHand) {
        super((EntityType<? extends BaseProjectile>)((EntityType)FateEntities.DAGGER_HOOK.get()), level, shooter);
        this.entityData.set(MAINHAND, (Object)mainHand);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HOOKED_ENTITY, (Object)0);
        builder.define(RETRACTING, (Object)false);
        builder.define(MAINHAND, (Object)true);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.getEntityData().get(HOOKED_ENTITY);
            Entity entity = this.hookedEntity = i > 0 ? this.level().getEntity(i) : null;
            if (this.hookedEntity != null) {
                this.setDeltaMovement(Vec3.ZERO);
            }
        }
        super.onSyncedDataUpdated(key);
    }

    public boolean retracting() {
        return (Boolean)this.getEntityData().get(RETRACTING);
    }

    public boolean fromMainHand() {
        return (Boolean)this.getEntityData().get(MAINHAND);
    }

    public boolean canHitShooter() {
        return this.retracting();
    }

    public void tick() {
        if (this.hookedEntity != null) {
            if (!this.hookedEntity.isAlive()) {
                this.hookedEntity = null;
                this.retractHook();
            } else {
                this.setDeltaMovement(Vec3.ZERO);
                this.setPos(this.hookedEntity.getX(), this.hookedEntity.getY(0.5), this.hookedEntity.getZ());
            }
        } else if (this.level().isClientSide) {
            Player player;
            PlayerData data;
            Entity entity;
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.CHAIN_PLACE, SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            if (this.isAlive() && (entity = this.getOwner()) instanceof Player && (data = Platform.INSTANCE.getPlayerData(player = (Player)entity)).getThrownDagger() != this) {
                data.setThrownDagger(this);
            }
        }
        if (this.retractPrev != this.retracting()) {
            Vec3 motion = this.getDeltaMovement();
            float[] yXRot = MathsHelper.YXRotFrom(motion);
            this.setRot(yXRot[0], yXRot[1]);
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        super.tick();
        if (!this.level().isClientSide) {
            Entity entity;
            if (this.retracting() && (entity = this.getOwner()) != null) {
                Vec3 vector3d = new Vec3(entity.getX() - this.getX(), entity.getY() - this.getY() + (double)(entity.getBbHeight() * 0.5f), entity.getZ() - this.getZ()).normalize().scale(0.8);
                this.setDeltaMovement(vector3d);
            }
            if (this.getOwner() == null) {
                this.discard();
            } else if (this.distanceToSqr(this.getOwner()) > 900.0) {
                this.retractHook();
            }
        }
        this.retractPrev = this.retracting();
    }

    protected float motionReduction(boolean inWater) {
        return 1.0f;
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        if (!this.retracting()) {
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                result.getEntity().hurt(this.damageSources().mobProjectile((Entity)this, entity2), (float)entity2.getAttributeValue(Attributes.ATTACK_DAMAGE));
            }
            this.hookedEntity = result.getEntity();
            this.entityData.set(HOOKED_ENTITY, (Object)result.getEntity().getId());
            this.setDeltaMovement(Vec3.ZERO);
            entity = this.getOwner();
            if (entity instanceof OnProjectileHit) {
                OnProjectileHit notif = (OnProjectileHit)entity;
                notif.onProjectileHit((Entity)this);
            }
            return true;
        }
        if (result.getEntity() == this.getOwner()) {
            this.discard();
            return true;
        }
        return false;
    }

    protected EntityHitResult getEntityHit(Vec3 from, Vec3 to) {
        if (this.retracting()) {
            return HitResultUtils.rayTraceEntities((Entity)this, (Vec3)from, (Vec3)to, e -> e == this.getOwner());
        }
        return super.getEntityHit(from, to);
    }

    protected void onBlockHit(BlockHitResult blockRayTraceResult) {
        if (this.hookedEntity == null) {
            this.retractHook();
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.remove("Shooter");
    }

    public AABB getBoundingBoxForCulling() {
        Entity owner = this.getOwner();
        if (owner == null) {
            return super.getBoundingBoxForCulling();
        }
        return super.getBoundingBoxForCulling().expandTowards(owner.position().subtract(this.position()));
    }

    public void retractHook() {
        this.getEntityData().set(RETRACTING, (Object)true);
        this.noPhysics = true;
        Entity entity = this.getOwner();
        if (entity != null) {
            if (this.hookedEntity != null) {
                Vec3 vector3d = entity.position().subtract(this.hookedEntity.position()).scale(0.18);
                vector3d = vector3d.add(0.0, 0.5, 0.0);
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    this.hookedEntity.hurt(this.damageSources().mobProjectile((Entity)this, living), (float)living.getAttributeValue(Attributes.ATTACK_DAMAGE));
                }
                this.hookedEntity.setDeltaMovement(vector3d);
                this.hookedEntity.hurtMarked = true;
            }
            Vec3 motion = new Vec3(entity.getX() - this.getX(), entity.getY() - this.getY() + (double)(entity.getBbHeight() * 0.5f), entity.getZ() - this.getZ()).normalize().scale(0.8);
            this.setDeltaMovement(motion);
            this.hookedEntity = null;
            this.getEntityData().set(HOOKED_ENTITY, (Object)-1);
        } else {
            this.discard();
        }
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        Entity entity = this.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Platform.INSTANCE.getPlayerData(player).setThrownDagger(null);
        }
    }
}

