/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.misc;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.fateubw.Fate;
import io.github.flemmli97.fateubw.common.entity.misc.BaseProjectile;
import io.github.flemmli97.fateubw.common.entity.utils.OnProjectileHit;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.registry.FateSounds;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EnkiduChains
extends BaseProjectile
implements SyncedMobDataHandler {
    protected static final int CHAIN_DURATION = 100;
    protected static final EntityDataAccessor<Integer> SHOOT_TIME = SynchedEntityData.defineId(EnkiduChains.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> PREPARING = SynchedEntityData.defineId(EnkiduChains.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Integer> HOOKED_ENTITY = SynchedEntityData.defineId(EnkiduChains.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> START_YROT = SynchedEntityData.defineId(EnkiduChains.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Float> START_XROT = SynchedEntityData.defineId(EnkiduChains.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final TypedResource<Vec3> START_POSITION = new TypedResource(Fate.modRes("start_position"));
    private final SyncedDataContainer<EnkiduChains> syncedDataContainer = SyncedDataContainer.builder((Entity)this).define(START_POSITION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null).build();
    private LivingEntity target;
    private Entity hookedEntity;
    private Vec3 hookedEntityPosition;
    private int preparationTick;
    private int hitTimer;
    public final int renderRand = this.random.nextInt(1000);

    public EnkiduChains(EntityType<? extends EnkiduChains> type, Level level) {
        super(type, level);
    }

    public EnkiduChains(Level level, LivingEntity shootingEntity) {
        super((EntityType<? extends BaseProjectile>)((EntityType)FateEntities.ENKIDU_CHAINS.get()), level, shootingEntity);
        this.entityData.set(SHOOT_TIME, (Object)(this.random.nextInt(15) + 15));
    }

    public EnkiduChains(Level level, LivingEntity shooter, LivingEntity target) {
        this(level, shooter);
        this.target = target;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PREPARING, (Object)true);
        builder.define(SHOOT_TIME, (Object)20);
        builder.define(HOOKED_ENTITY, (Object)0);
        builder.define(START_YROT, (Object)Float.valueOf(0.0f));
        builder.define(START_XROT, (Object)Float.valueOf(0.0f));
    }

    public SyncedDataContainer<?> getDataContainer() {
        return this.syncedDataContainer;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.getEntityData().get(HOOKED_ENTITY);
            this.hookedEntity = i > 0 ? this.level().getEntity(i) : null;
        }
        super.onSyncedDataUpdated(key);
    }

    public boolean preparing() {
        return (Boolean)this.entityData.get(PREPARING);
    }

    public int livingTickMax() {
        return 80 + (this.hookedEntity != null ? 100 : 0);
    }

    public void tick() {
        if (this.level().isClientSide) {
            AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.92156863f, 0.92156863f, 0.0f, 1.0f)).addData((AdvancedParticleData)new ScaleData(0.3f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, this.random.nextGaussian() * 0.01, this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), this.getStartPosition().x(), this.getStartPosition().y() + (double)this.getBbHeight() * 0.5, this.getStartPosition().z());
        }
        if (this.preparing()) {
            this.updatePreparation();
            return;
        }
        if (!this.level().isClientSide) {
            Entity thrower = this.getOwner();
            if (thrower == null || !thrower.isAlive()) {
                this.discard();
                return;
            }
            if (this.hookedEntity != null) {
                ++this.hitTimer;
                if (!this.hookedEntity.isAlive() || this.hitTimer > 100) {
                    this.discard();
                } else {
                    Entity entity = this.hookedEntity;
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (!player.getAbilities().invulnerable) {
                            player.setDeltaMovement(Vec3.ZERO);
                            player.teleportTo(this.hookedEntityPosition.x(), this.hookedEntityPosition.y(), this.hookedEntityPosition.z());
                            player.hurtMarked = true;
                        }
                    } else {
                        this.hookedEntity.setPos(this.hookedEntityPosition);
                        this.hookedEntity.setDeltaMovement(Vec3.ZERO);
                    }
                }
            }
            if (this.tickCount < 4) {
                this.playSound(SoundEvents.CHAIN_PLACE, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.8f);
            }
        }
        super.tick();
    }

    public void moveEntity() {
        if (this.hookedEntity != null) {
            return;
        }
        super.moveEntity();
    }

    private void updatePreparation() {
        ++this.preparationTick;
        Vec3 motion = this.getDeltaMovement();
        double f = Math.sqrt(EnkiduChains.horizontalMag((Vec3)motion));
        this.setYRot(this.updateRotation(this.yRotO, (float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.2957763671875)));
        this.setXRot(this.updateRotation(this.xRotO, (float)(Mth.atan2((double)motion.y, (double)f) * 57.2957763671875)));
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        if (!this.level().isClientSide) {
            this.entityData.set(START_YROT, (Object)Float.valueOf(this.getYRot()));
            this.entityData.set(START_XROT, (Object)Float.valueOf(this.getXRot()));
            this.syncedDataContainer.set(START_POSITION, (Object)this.position());
            if (this.tickCount == 1) {
                this.playSound((SoundEvent)FateSounds.ENTITY_BABYLON_SPAWN.get(), 0.7f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.9f);
            }
            if (this.preparing() && this.preparationTick >= (Integer)this.entityData.get(SHOOT_TIME)) {
                this.entityData.set(PREPARING, (Object)false);
                Entity thrower = this.getOwner();
                if (thrower instanceof Player) {
                    HitResult hit = HitResultUtils.entityRayTrace((Entity)thrower, (double)64.0, (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE, (boolean)false, (boolean)false, null);
                    this.shootAtPosition(hit.getLocation().x, hit.getLocation().y, hit.getLocation().z, 1.0f, 6.0f);
                } else if (this.target != null) {
                    this.shootAtEntity((Entity)this.target, 1.0f, 6.0f);
                } else {
                    this.discard();
                }
                this.playSound(SoundEvents.CHAIN_PLACE, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.8f);
            }
        }
    }

    private float updateRotation(float prev, float current) {
        while (current - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (current - prev >= 180.0f) {
            prev += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)prev, (float)current);
    }

    protected float motionReduction(boolean inWater) {
        return 1.0f;
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        if (result.getEntity() == this.getOwner()) {
            return false;
        }
        if (this.hookedEntity == null) {
            boolean hurt = false;
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                hurt = Utils.runWithInvulTimer((Entity)entity2, result.getEntity(), target -> target.hurt(this.damageSources().mobProjectile((Entity)this, entity2), (float)entity2.getAttributeValue(Attributes.ATTACK_DAMAGE) * 0.4f), 2);
            }
            if (!hurt) {
                return false;
            }
            this.moveEntity();
            this.hookedEntity = result.getEntity();
            this.hookedEntityPosition = this.hookedEntity.position();
            this.entityData.set(HOOKED_ENTITY, (Object)result.getEntity().getId());
            entity = this.getOwner();
            if (entity instanceof OnProjectileHit) {
                OnProjectileHit notif = (OnProjectileHit)entity;
                notif.onProjectileHit((Entity)this);
            }
        }
        return true;
    }

    protected void onBlockHit(BlockHitResult blockRayTraceResult) {
        this.discard();
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Preparing", this.preparing());
        Vec3 start = this.getStartPosition();
        compound.put("StartPosition", (Tag)Vec3.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)start).getOrThrow());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(PREPARING, (Object)compound.getBoolean("Preparing"));
        this.syncedDataContainer.set(START_POSITION, (Object)Vec3.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("StartPosition")).result().orElse(this.position()));
    }

    public AABB getBoundingBoxForCulling() {
        return super.getBoundingBoxForCulling().expandTowards(this.getStartPosition().subtract(this.position()));
    }

    public boolean hasHooked() {
        return (Integer)this.entityData.get(HOOKED_ENTITY) > 0;
    }

    public Vec3 getStartPosition() {
        Vec3 start = (Vec3)this.syncedDataContainer.get(START_POSITION);
        return start == null ? this.position() : start;
    }

    public float getStartY() {
        return ((Float)this.entityData.get(START_YROT)).floatValue();
    }

    public float getStartX() {
        return ((Float)this.entityData.get(START_XROT)).floatValue();
    }

    public static void spawnWeaponsAround(LivingEntity thrower, LivingEntity target, int amount, int range) {
        int targetSize = Math.max(Mth.ceil((float)target.getBbHeight()), Mth.ceil((float)target.getBbWidth()));
        range = Math.max(targetSize + 3, range);
        ArrayList<Pair> angles = new ArrayList<Pair>(amount);
        block0: for (int i = 0; i < amount; ++i) {
            float yRot = thrower.getRandom().nextFloat() * 360.0f;
            float xRot = thrower.getRandom().nextFloat() * 70.0f + 20.0f;
            int retry = 0;
            do {
                float greatDist = Float.MAX_VALUE;
                for (Pair p : angles) {
                    float d;
                    if (p == null || !((d = EnkiduChains.greatCircDist(yRot, xRot, ((Float)p.getFirst()).floatValue(), ((Float)p.getSecond()).floatValue())) < greatDist)) continue;
                    greatDist = d;
                }
                if (!(greatDist * (float)range > 2.0f)) continue;
                angles.add(Pair.of((Object)Float.valueOf(yRot), (Object)Float.valueOf(xRot)));
                continue block0;
            } while (++retry <= 10);
        }
        Vec3 pos = target.position();
        for (Pair offset : angles) {
            if (offset == null) continue;
            EnkiduChains chains = new EnkiduChains(thrower.level(), thrower, target);
            chains.shoot((Entity)thrower, ((Float)offset.getSecond()).floatValue(), ((Float)offset.getFirst()).floatValue(), 0.0f, 0.02f, 0.0f);
            Vec3 area = pos.add(Vec3.directionFromRotation((float)(-((Float)offset.getSecond()).floatValue()), (float)((Float)offset.getFirst()).floatValue()).scale((double)range));
            chains.setPos(area.x, area.y, area.z);
            chains.level().addFreshEntity((Entity)chains);
        }
    }

    private static float greatCircDist(float yRot1, float xRot1, float yRot2, float xRot2) {
        return (float)Math.acos(Mth.sin((float)xRot1) * Mth.sin((float)xRot2) + Mth.cos((float)xRot1) * Mth.cos((float)xRot2) * Mth.cos((float)Mth.abs((float)(yRot1 - yRot2))));
    }
}

