/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.misc;

import io.github.flemmli97.fateubw.client.ShakeHandler;
import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.misc.BaseBeam;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.registry.FateSounds;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Excalibur
extends BaseBeam {
    public static final float RADIUS = 1.8f;
    public static final float RANGE = 24.0f;
    private Vec3 dir;
    private Vec3 up;
    private Vec3 side;

    public Excalibur(EntityType<? extends Excalibur> type, Level level) {
        super(type, level);
    }

    public Excalibur(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseBeam>)((EntityType)FateEntities.EXCALIBUR.get()), level, shooter);
        Vec3 dir = shooter.getLookAngle();
        Vec3 off = new Vec3(dir.x, 0.0, dir.z).normalize().scale((double)shooter.getBbWidth() * 0.5);
        this.setPos(this.getX() + off.x, this.getY(), this.getZ() + off.z);
    }

    public float radius() {
        return 1.8f;
    }

    public float getRange() {
        return 24.0f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return 24;
    }

    public boolean canStartDamage() {
        return this.livingTicks > 2 && this.livingTicks + 2 < this.livingTickMax();
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.livingTicks <= this.livingTickMax() - 15) {
                for (int i = 0; i < 2; ++i) {
                    AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.9607843f, 0.9607843f, 0.019607844f, 0.6f)).addData((AdvancedParticleData)new ScaleData(2.0f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.007, this.random.nextGaussian() * 0.007 + 0.003, this.random.nextGaussian() * 0.007)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), this.hitVec.x(), this.hitVec.y() - 0.15, this.hitVec.z());
                }
            }
            Vec3 pos = this.position();
            for (int i = 0; i < 4; ++i) {
                double upScale = this.random.nextDouble() * 2.0 - 1.0 + 0.3;
                double sideScale = this.random.nextDouble() * 2.2 - 1.1;
                double lenScale = this.random.nextDouble();
                Vec3 ppos = pos.add(this.up.scale(upScale)).add(this.side.scale(sideScale)).add(this.dir.scale(lenScale));
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.9607843f, 0.9607843f, 0.019607844f, 1.0f)).addData((AdvancedParticleData)new ScaleData(0.15f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, this.random.nextGaussian() * 0.01, this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), ppos.x(), ppos.y(), ppos.z());
            }
            if (this.tickCount % 3 == 1) {
                ShakeHandler.shakeScreen(this.position(), this.getRange() + 4.0f, 3, 1.5f);
            }
        } else if (this.livingTicks == 1) {
            this.playSound((SoundEvent)FateSounds.ENTITY_EXCALIBUR_SHOOT.get(), 0.8f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.4f);
        }
    }

    public HitResult getHitRay() {
        HitResult res = super.getHitRay();
        this.dir = res.getLocation().subtract(this.position());
        this.up = this.calculateViewVector(this.getXRot() - 90.0f, this.getYRot()).scale((double)this.radius());
        this.side = this.dir.cross(this.up).normalize().scale((double)this.radius());
        return res;
    }

    public void onImpact(EntityHitResult result) {
        Utils.runWithInvulTimer(this.getOwner(), result.getEntity(), e -> e.hurt(FateDamageTypes.indirect(FateDamageTypes.EXCALIBUR, (Entity)this, this.getOwner()), Utils.magicDamage(this.getOwner()) + CommonConfig.excaliburDamage), 4);
    }
}

