/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.misc;

import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.misc.BaseProjectile;
import io.github.flemmli97.fateubw.common.entity.servant.Cuchulainn;
import io.github.flemmli97.fateubw.common.entity.utils.EntityTrailHandler;
import io.github.flemmli97.fateubw.common.particles.trail.TrailPositions;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.utils.Utils;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class GaeBolg
extends BaseProjectile {
    private Entity target;
    private final EntityTrailHandler trailHandler = new EntityTrailHandler((Entity)this, 8);

    public GaeBolg(EntityType<? extends GaeBolg> type, Level level) {
        super(type, level);
    }

    public GaeBolg(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)FateEntities.GAEBOLG.get()), level, shooter);
    }

    public int livingTickMax() {
        return 80;
    }

    public void setTarget(Entity target) {
        this.target = target;
    }

    public void tick() {
        if (this.firstTick) {
            this.trailHandler.tick();
        }
        super.tick();
        if (!this.level().isClientSide && this.target != null) {
            int changeFreq;
            Vec3 dist = this.target.position().add(0.0, (double)this.target.getBbHeight() * 0.5, 0.0).subtract(this.position());
            int n = dist.lengthSqr() > 36.0 ? 6 : (changeFreq = dist.lengthSqr() > 9.0 ? 4 : 2);
            if (this.tickCount % changeFreq == 0) {
                this.homeTarget(dist);
            }
        }
        this.trailHandler.tick();
    }

    protected void homeTarget(Vec3 dist) {
        Vec3 delta = this.getDeltaMovement();
        Vec3 motion = dist.normalize().scale(delta.length());
        this.setDeltaMovement(motion);
        double f = Math.sqrt(GaeBolg.horizontalMag((Vec3)motion));
        this.setYRot((float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)motion.y, (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    protected float motionReduction(boolean inWater) {
        return 1.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult res) {
        block7: {
            LivingEntity living;
            block8: {
                float f;
                if (this.target != null && res.getEntity() != this.target) {
                    return false;
                }
                Entity entity = res.getEntity();
                if (entity instanceof LivingEntity) {
                    living = (LivingEntity)entity;
                    f = living.getHealth();
                } else {
                    f = 0.0f;
                }
                float health = f;
                res.getEntity().hurt(FateDamageTypes.indirect(FateDamageTypes.GAE_BOLG, (Entity)this, this.getOwner()), Utils.magicDamage(this.getOwner()) + CommonConfig.gaeBolgDmg + health * 0.1f);
                Entity entity2 = res.getEntity();
                if (!(entity2 instanceof LivingEntity)) break block7;
                living = (LivingEntity)entity2;
                entity2 = res.getEntity();
                if (!(entity2 instanceof Player)) break block8;
                Player player = (Player)entity2;
                if (player.getAbilities().invulnerable) break block7;
            }
            for (MobEffectInstance effect : CommonConfig.gaeBolgEffect.potions()) {
                living.addEffect(effect);
            }
        }
        this.discard();
        return true;
    }

    public void moveEntity() {
        if (this.level().isClientSide) {
            this.doCollision();
        }
        super.moveEntity();
    }

    protected void onBlockHit(BlockHitResult hit) {
        if (this.tickCount < 40) {
            Vec3 mot = this.getDeltaMovement();
            Direction dir = hit.getDirection();
            Vec3 newMot = switch (dir) {
                case Direction.DOWN, Direction.UP -> new Vec3(mot.x(), -mot.y(), mot.z());
                case Direction.WEST, Direction.EAST -> new Vec3(-mot.x(), mot.y(), mot.z());
                default -> new Vec3(mot.x(), mot.y(), -mot.z());
            };
            this.setPos(hit.getLocation().add((double)dir.getStepX() * 0.5, (double)dir.getStepY() * 0.5, (double)dir.getStepZ() * 0.5));
            this.setDeltaMovement(newMot);
            return;
        }
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    public void remove(Entity.RemovalReason removalReason) {
        if (!this.level().isClientSide) {
            Entity entity = this.getOwner();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.isCreative()) {
                    ItemEntity gaeBolg = new ItemEntity(this.level(), this.getOwner().getX(), this.getOwner().getY(), this.getOwner().getZ(), new ItemStack((ItemLike)FateItems.GAEBOLG.get()));
                    gaeBolg.setPickUpDelay(0);
                    player.level().addFreshEntity((Entity)gaeBolg);
                    player.playSound(SoundEvents.ITEM_PICKUP, 0.8f, 1.0f);
                }
            } else if (this.getOwner() instanceof Cuchulainn) {
                ((Cuchulainn)this.getOwner()).retrieveGaeBolg();
            }
        }
        super.remove(removalReason);
    }

    protected float getGravityVelocity() {
        return 0.01f;
    }

    public TrailPositions trailPositions() {
        return this.trailHandler.getPositions();
    }
}

