/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.misc;

import io.github.flemmli97.fateubw.common.config.CommonConfig;
import io.github.flemmli97.fateubw.common.entity.misc.BaseBeam;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class MagicBeam
extends BaseBeam {
    protected static final EntityDataAccessor<Integer> SHOOT_TIME = SynchedEntityData.defineId(MagicBeam.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> PREPARING = SynchedEntityData.defineId(MagicBeam.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Float> SPAWN_ROT_Y = SynchedEntityData.defineId(MagicBeam.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Float> SPAWN_ROT_X = SynchedEntityData.defineId(MagicBeam.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private LivingEntity target;
    private float damageMultiplier = 1.0f;
    private boolean setSpawnRot;
    private int preparationTick;

    public MagicBeam(EntityType<? extends MagicBeam> type, Level level) {
        super(type, level);
    }

    public MagicBeam(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseBeam>)((EntityType)FateEntities.MAGIC_BEAM.get()), level, shooter);
        this.entityData.set(SHOOT_TIME, (Object)(this.random.nextInt(10) + 6));
    }

    public MagicBeam(Level level, LivingEntity shootingEntity, @Nullable LivingEntity target) {
        this(level, shootingEntity);
        this.target = target;
    }

    public void setDamageMultiplier(float multiplier) {
        this.damageMultiplier = multiplier;
    }

    public float radius() {
        return 0.3f;
    }

    public float getRange() {
        return 20.0f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT_TIME, (Object)20);
        builder.define(PREPARING, (Object)true);
        builder.define(SPAWN_ROT_Y, (Object)Float.valueOf(0.0f));
        builder.define(SPAWN_ROT_X, (Object)Float.valueOf(0.0f));
    }

    public boolean preparing() {
        return (Boolean)this.entityData.get(PREPARING);
    }

    public float getSpawnRotY() {
        return ((Float)this.entityData.get(SPAWN_ROT_Y)).floatValue();
    }

    public float getSpawnRotX() {
        return ((Float)this.entityData.get(SPAWN_ROT_X)).floatValue();
    }

    public void setRotationToDir(double x, double y, double z, float inaccuracy) {
        super.setRotationToDir(x, y, z, inaccuracy);
        if (!this.setSpawnRot) {
            this.setSpawnRot = true;
            this.entityData.set(SPAWN_ROT_Y, (Object)Float.valueOf(this.getYRot()));
            this.entityData.set(SPAWN_ROT_X, (Object)Float.valueOf(this.getXRot()));
        }
    }

    public int livingTickMax() {
        return 14;
    }

    public boolean canStartDamage() {
        return (this.livingTicks - 1) % 20 == 2;
    }

    public void tick() {
        if (this.level().isClientSide) {
            AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.8039216f, 0.050980393f, 0.8039216f, 1.0f)).addData((AdvancedParticleData)new ScaleData(0.15f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, this.random.nextGaussian() * 0.01, this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), this.getRandomX(2.0), this.getRandomY(), this.getRandomZ(2.0));
        } else if (!this.setSpawnRot) {
            this.setSpawnRot = true;
            this.entityData.set(SPAWN_ROT_Y, (Object)Float.valueOf(this.getYRot()));
            this.entityData.set(SPAWN_ROT_X, (Object)Float.valueOf(this.getXRot()));
        }
        if (this.preparing()) {
            ++this.preparationTick;
            this.updatePreparation();
        } else {
            Entity thrower;
            if (!(this.level().isClientSide || (thrower = this.getOwner()) != null && thrower.isAlive())) {
                this.remove(Entity.RemovalReason.KILLED);
                return;
            }
            super.tick();
        }
    }

    private void updatePreparation() {
        ++this.preparationTick;
        if (this.preparing() && this.preparationTick >= (Integer)this.entityData.get(SHOOT_TIME)) {
            this.entityData.set(PREPARING, (Object)false);
            if (this.target != null) {
                this.setRotationTo(this.target.getX(), this.target.getY() + (double)this.target.getBbHeight() * 0.5, this.target.getZ(), 0.05f);
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("DamageMultiplier", this.damageMultiplier);
        compound.putBoolean("Preparing", this.preparing());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.damageMultiplier = compound.getFloat("DamageMultieier");
        this.entityData.set(PREPARING, (Object)compound.getBoolean("Preparing"));
    }

    public void onImpact(EntityHitResult result) {
        Utils.runWithInvulTimer(this.getOwner(), result.getEntity(), target -> target.hurt(FateDamageTypes.indirect(FateDamageTypes.MAGIC_BEAM, (Entity)this, this.getOwner()), (Utils.magicDamage(this.getOwner()) + CommonConfig.magicBeam) * this.damageMultiplier), 2);
    }

    public boolean shouldRender3d(Entity entity, int state) {
        return true;
    }
}

