/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.misc;

import io.github.flemmli97.fateubw.common.entity.misc.BaseProjectile;
import io.github.flemmli97.fateubw.common.registry.FateDamageTypes;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MagicShot
extends BaseProjectile {
    private static final EntityDataAccessor<Integer> TYPE_DATA = SynchedEntityData.defineId(MagicShot.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private ColorType colorType = ColorType.PURPLE;

    public MagicShot(EntityType<? extends MagicShot> type, Level level) {
        super(type, level);
    }

    public MagicShot(Level level, LivingEntity shootingEntity) {
        super((EntityType<? extends BaseProjectile>)((EntityType)FateEntities.MAGIC_SHOT.get()), level, shootingEntity);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE_DATA, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        int id;
        super.onSyncedDataUpdated(key);
        if (key == TYPE_DATA && (id = ((Integer)this.entityData.get(TYPE_DATA)).intValue()) >= 0 && id < ColorType.values().length) {
            this.colorType = ColorType.values()[id];
        }
    }

    public void setType(ColorType type) {
        this.colorType = type;
        this.entityData.set(TYPE_DATA, (Object)this.colorType.ordinal());
    }

    public int livingTickMax() {
        return 100;
    }

    public float radius() {
        return 1.0f;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            Vector3f color = this.colorType.particleColor;
            Vec3 delta = this.getDeltaMovement().scale(0.5);
            for (int i = 0; i < 8; ++i) {
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)FateParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(color.x(), color.y(), color.z(), 0.5f)).addData((AdvancedParticleData)new ScaleData(0.5f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, Math.abs(this.random.nextGaussian() * 0.03), this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.level(), this.getX() + this.random.nextGaussian() * delta.x(), this.getY() + 0.35 + this.random.nextGaussian() * delta.y(), this.getZ() + this.random.nextGaussian() * delta.z());
            }
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected float motionReduction(boolean inWater) {
        return 1.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        this.discard();
        return result.getEntity().hurt(FateDamageTypes.indirect(FateDamageTypes.MAGIC_SHOT, (Entity)this, this.getOwner()), Utils.magicDamage(this.getOwner()));
    }

    protected void onBlockHit(BlockHitResult blockRayTraceResult) {
        this.discard();
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Color", this.colorType.ordinal());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setType(ColorType.values()[compound.getInt("Color")]);
    }

    public static enum ColorType {
        PURPLE(new Vector3f(0.4117647f, 0.19215687f, 0.54901963f));

        public final Vector3f particleColor;

        private ColorType(Vector3f particleColor) {
            this.particleColor = particleColor;
        }
    }
}

