/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.misc;

import io.github.flemmli97.fateubw.common.entity.misc.BaseProjectile;
import io.github.flemmli97.fateubw.common.registry.FateEntities;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.joml.Vector3f;

public class StarfishShot
extends BaseProjectile {
    public StarfishShot(EntityType<? extends StarfishShot> type, Level level) {
        super(type, level);
    }

    public StarfishShot(Level level, LivingEntity shootingEntity) {
        super((EntityType<? extends BaseProjectile>)((EntityType)FateEntities.STARFISH_SHOT.get()), level, shootingEntity);
    }

    public int livingTickMax() {
        return 100;
    }

    public float radius() {
        return 1.0f;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.12941177f, 0.3764706f, 0.12941177f), 1.5f), this.getX(), this.getY(0.5), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected float getGravityVelocity() {
        return 0.1f;
    }

    protected float motionReduction(boolean inWater) {
        return 1.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        LivingEntity living;
        LivingEntity owner;
        Entity entity = this.getOwner();
        LivingEntity livingEntity = owner = entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
        if (owner instanceof Mob) {
            Mob mob = (Mob)owner;
            if (result.getEntity() != mob.getTarget()) {
                return false;
            }
        }
        this.discard();
        float damage = owner != null ? (float)owner.getAttributeValue(Attributes.ATTACK_DAMAGE) : 1.0f;
        return result.getEntity().hurt(this.damageSources().mobProjectile((Entity)this, owner), damage);
    }

    protected void onBlockHit(BlockHitResult blockRayTraceResult) {
        this.discard();
    }
}

