/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.fateubw.common.entity.servant;

import io.github.flemmli97.fateubw.common.entity.BaseServant;
import io.github.flemmli97.fateubw.common.entity.HeldEquipmentHandler;
import io.github.flemmli97.fateubw.common.entity.ai.behaviour.BehaviourUtils;
import io.github.flemmli97.fateubw.common.entity.misc.ArcherArrow;
import io.github.flemmli97.fateubw.common.entity.misc.CaladBolg;
import io.github.flemmli97.fateubw.common.particles.trail.TrailInfo;
import io.github.flemmli97.fateubw.common.particles.trail.TrailParticleData;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailHolderProvider;
import io.github.flemmli97.fateubw.common.particles.trail.provider.entity.EntityWeaponTrailProvider;
import io.github.flemmli97.fateubw.common.registry.FateAttributes;
import io.github.flemmli97.fateubw.common.registry.FateItems;
import io.github.flemmli97.fateubw.common.registry.FateParticles;
import io.github.flemmli97.fateubw.common.utils.Utils;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.LeapInDirection;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.joml.Vector4f;

public class Emiya
extends BaseServant {
    public static final String LEFT_TRAIL_END = "left_trail_end";
    public static final String RIGHT_TRAIL_START = "right_trail_start";
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String DUAL_SLASH_1 = BUILDER.add("dual_slash_1", AnimationsBuilder.definition((double)1.12).marker("attack_left", new double[]{0.6}).marker("attack_right", new double[]{1.0}).marker("step", new double[]{0.32, 0.72}).marker("weapon_swing_start", new double[]{0.4}).marker("left_trail_end", new double[]{0.64}).marker("right_trail_start", new double[]{0.8}).marker("weapon_swing_end", new double[]{1.04}));
    public static final String DUAL_SLASH_2 = BUILDER.add("dual_slash_2", AnimationsBuilder.definition((double)0.68).marker("attack_left", new double[]{0.56}).marker("attack_right", new double[]{0.56}));
    public static final String DUAL_SLASH_3 = BUILDER.add("dual_slash_3", AnimationsBuilder.definition((double)0.72).marker("attack_left", new double[]{0.52}).marker("attack_right", new double[]{0.52}).marker("step", new double[]{0.4}).marker("weapon_swing_start", new double[]{0.4}).marker("left_trail_end", new double[]{0.64}).marker("right_trail_start", new double[]{0.4}).marker("weapon_swing_end", new double[]{0.64}));
    public static final String DUAL_SLASH_4 = BUILDER.add("dual_slash_4", AnimationsBuilder.definition((double)0.68).marker("attack_left", new double[]{0.52}).marker("attack_right", new double[]{0.52}).marker("step", new double[]{0.32}).marker("weapon_swing_start", new double[]{0.4}).marker("left_trail_end", new double[]{0.6}).marker("right_trail_start", new double[]{0.4}).marker("weapon_swing_end", new double[]{0.6}));
    public static final String DUAL_SLASH_5 = BUILDER.add("dual_slash_5", AnimationsBuilder.definition((double)0.96).marker("attack_left", new double[]{0.52}).marker("attack_right", new double[]{0.52}).marker("leap", new double[]{0.32}).marker("weapon_swing_start", new double[]{0.4}).marker("left_trail_end", new double[]{0.64}).marker("right_trail_start", new double[]{0.4}).marker("weapon_swing_end", new double[]{0.64}));
    public static final String DUAL_SLASH_6 = BUILDER.add("dual_slash_6", AnimationsBuilder.definition((double)1.32).marker("attack_left", new double[]{0.68, 1.2}).marker("attack_right", new double[]{0.56, 1.2}).marker("attack_end", new double[]{1.2}).marker("weapon_swing_start", new double[]{0.4, 1.04}).marker("left_trail_end", new double[]{0.76, 1.24}).marker("right_trail_start", new double[]{0.48, 1.04}).marker("weapon_swing_end", new double[]{0.76, 1.24}));
    public static final String BOW_1 = BUILDER.add("bow_1", AnimationsBuilder.definition((double)1.2).marker("use_start", new double[]{0.24}).marker("use_end", new double[]{1.0}).marker("shoot", new double[]{1.0}));
    public static final String BOW_2 = BUILDER.add("bow_2", AnimationsBuilder.definition((double)1.6).marker("use_start", new double[]{0.24}).marker("use_end", new double[]{1.4}).marker("shoot", new double[]{1.0, 1.2, 1.4}));
    public static final String BOW_AIR = BUILDER.add("bow_air", AnimationsBuilder.definition((double)1.72).marker("use_start", new double[]{0.48}).marker("use_end", new double[]{1.08}).marker("shoot", new double[]{1.08}).marker("float_start", new double[]{0.6}).marker("float_end", new double[]{1.2}).marker("jump", new double[]{0.2}));
    public static final String CALADBOLG = BUILDER.add("caladbolg", AnimationsBuilder.definition((double)2.52).marker("use_start", new double[]{0.24}).marker("shoot", new double[]{2.24}));
    public static final String SUMMON = BUILDER.add("summon", AnimationsBuilder.definition((double)2.0));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Emiya> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    public final HeldEquipmentHandler heldEquipmentHandler = new HeldEquipmentHandler((LivingEntity)this, ItemStack.EMPTY, new ItemStack((ItemLike)FateItems.EMIYAS_BOW.get()));
    private final Vector4f summonColor = new Vector4f(0.8352941f, 0.0f, 0.023529412f, 0.7f);
    private boolean leftHandAttackFlag;

    public Emiya(EntityType<? extends Emiya> entityType, Level level) {
        super(entityType, level);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)FateItems.KANSHOU.get()));
    }

    @Override
    public boolean hasOwnWeapon() {
        return this.getMainHandItem().is((Item)FateItems.KANSHOU.get());
    }

    @Override
    public HeldEquipmentHandler getEquipmentHandler() {
        return this.heldEquipmentHandler;
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{DUAL_SLASH_1}).play(BehaviourUtils.cooldownedPlay(true, 16, 28)).condition(BehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(8).start(BehaviourUtils.of(AnimationPlayHolder.builder((String)DUAL_SLASH_1).start(DUAL_SLASH_4, 2, 0.32f, 1).build())).play(BehaviourUtils.cooldownedPlay(true, 16, 28)).condition(BehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(4).start(new String[]{DUAL_SLASH_2}).play(BehaviourUtils.cooldownedPlay(true, 16, 28)).condition(BehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(8).start(new String[]{DUAL_SLASH_3}).play(BehaviourUtils.cooldownedPlay(true, 16, 28)).condition(BehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(8).start(new String[]{DUAL_SLASH_5}).play(BehaviourUtils.cooldownedPlay(true, 16, 28)).condition(BehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(8).start(new String[]{DUAL_SLASH_6}).play(BehaviourUtils.cooldownedPlay(true, 16, 28)).condition(BehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.timedMoveAttack()}).end(6).start(new String[]{BOW_1}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(12.0), 16, 28)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(14.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(9).start(new String[]{BOW_1}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(12.0), 16, 28)).prepare(new ExtendedBehaviour[]{new LeapInDirection().shouldLeap((owner, target) -> owner.distanceToSqr((Entity)target) < 49.0).horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((Vec3)owner.position(), (Vec3)target.position()).scale((double)1.3f))}).end(7).start(new String[]{BOW_1}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(12.0), 16, 28)).condition(BehaviourUtils.ifFurtherThan(11.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(14.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(6).start(new String[]{BOW_2}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(12.0), 16, 28)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(14.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(7).start(new String[]{BOW_2}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(12.0), 16, 28)).prepare(new ExtendedBehaviour[]{new LeapInDirection().shouldLeap((owner, target) -> owner.distanceToSqr((Entity)target) < 49.0).horizontalDirection((owner, target) -> LeapInDirection.createBackwardsVec((Vec3)owner.position(), (Vec3)target.position()).scale((double)1.3f))}).end(7).start(new String[]{BOW_2}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(12.0), 16, 28)).condition(BehaviourUtils.ifFurtherThan(11.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(14.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(5).start(new String[]{BOW_AIR}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(12.0), 16, 28)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(10.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(7).start(new String[]{BOW_AIR}).play(BehaviourUtils.cooldownedPlay(BehaviourUtils.ifCloserThan(12.0), 16, 28)).condition(BehaviourUtils.ifFurtherThan(11.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(10.0).speedMod(1.2f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(9).start(new String[]{CALADBOLG}).play(BehaviourUtils.cooldownedPlay(false, 20, 30)).condition(BaseServant::canUseNobelPhantasm).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(8.0).max(16.0).speedMod(1.3f)}).prepareOptional(new ExtendedBehaviour[]{BehaviourUtils.moveAttack()}).end(45).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseServant> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(4, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), BehaviourUtils.moveTo()}).add(6, new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget(), BehaviourUtils.moveTo()}).build();
    }

    public void baseTick() {
        super.baseTick();
        if (this.level().isClientSide) {
            AnimationState anim = this.getAnimationHandler().getAnimation();
            if (anim != null) {
                if (anim.isAt("weapon_swing_start")) {
                    this.level().addParticle((ParticleOptions)new TrailParticleData((ParticleType<TrailParticleData>)((ParticleType)FateParticles.TRAIL.get()), TrailInfo.builder(new EntityWeaponTrailProvider.EntityTrailData(this.getId(), anim.getID(), true, 3, LEFT_TRAIL_END)).setColor(0.09803922f, 0.09803922f, 0.29411766f, 0.6f).setColor2(0.09803922f, 0.09803922f, 0.29411766f, 0.2f).setType(TrailInfo.Visual.TEXTURE, 0).build()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                }
                if (anim.isAt(RIGHT_TRAIL_START)) {
                    this.level().addParticle((ParticleOptions)new TrailParticleData((ParticleType<TrailParticleData>)((ParticleType)FateParticles.TRAIL.get()), TrailInfo.builder(EntityWeaponTrailProvider.EntityTrailData.create(this, anim.getID(), false)).setColor(0.09803922f, 0.09803922f, 0.29411766f, 0.6f).setColor2(0.09803922f, 0.09803922f, 0.29411766f, 0.2f).setType(TrailInfo.Visual.TEXTURE, 0).build()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                }
            }
        } else {
            this.heldEquipmentHandler.setInUse(this.getAnimationHandler().isCurrent(new String[]{BOW_1, BOW_2, BOW_AIR, CALADBOLG}));
        }
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{CALADBOLG})) {
            LivingEntity target;
            if (!this.getAnimationHandler().getAnimation().isPast("shoot") && (target = this.getTarget()) != null) {
                return target.getEyePosition().subtract(this.getEyePosition());
            }
            return null;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{CALADBOLG})) {
            LivingEntity target = this.getTarget();
            if (anim.isAt("use_start")) {
                this.startUsingItem(this.bowHand());
            }
            if (anim.isAt("shoot") && (target == null || this.getSensing().hasLineOfSight((Entity)target))) {
                this.caladBolg(target);
            }
            if (anim.isAt("use_end")) {
                this.stopUsingItem();
            }
        } else if (anim.is(new String[]{BOW_1, BOW_2})) {
            LivingEntity target = this.getTarget();
            if (anim.isAt("use_start")) {
                this.startUsingItem(this.bowHand());
            }
            if (anim.isAt("shoot") && (target == null || this.getSensing().hasLineOfSight((Entity)target))) {
                this.attackWithRangedAttack(target);
            }
            if (anim.isAt("use_end")) {
                this.stopUsingItem();
            }
        } else if (anim.is(new String[]{BOW_AIR})) {
            LivingEntity target = this.getTarget();
            if (anim.isAt("jump")) {
                Vec3 dir = target != null ? target.position().subtract(this.position()) : this.getViewVector(1.0f);
                dir = new Vec3(dir.x(), 0.0, dir.z()).normalize().scale(-1.2).add(0.0, 1.3, 0.0);
                this.setDeltaMovement(dir);
            }
            if (anim.isAt("use_start")) {
                this.startUsingItem(this.bowHand());
            }
            if (anim.isAt("use_end")) {
                this.stopUsingItem();
            }
            if (anim.isPast("float_start") && !anim.isPast("float_end")) {
                Vec3 delta = this.getDeltaMovement().scale(0.6);
                this.setDeltaMovement(new Vec3(delta.x(), Math.max(0.0, delta.y()), delta.z()));
            }
            if (anim.isAt("shoot") && (target == null || this.getSensing().hasLineOfSight((Entity)target))) {
                this.attackWithRangedAttackBarrage(target);
            }
            this.fallDistance = 0.0f;
        } else {
            if (anim.isAt("leap")) {
                LivingEntity target = this.getTarget();
                Vec3 dir = target != null ? target.position().subtract(this.position()) : this.position().add(this.getViewVector(1.0f));
                dir = new Vec3(dir.x(), 0.0, dir.z()).normalize().add(0.0, 0.24, 0.0);
                this.setDeltaMovement(dir);
            }
            if (anim.isAt("step")) {
                Vec3 dir = Utils.fromRelativeVector((Entity)this, new Vec3(0.0, 0.0, 1.0)).scale(0.35);
                this.setDeltaMovement(this.getDeltaMovement().add(dir));
            }
            if (anim.isAt("attack_left")) {
                this.leftHandAttackFlag = true;
                this.mobAttack(anim, this.getTarget(), this::doHurtTarget);
                this.setTargetPosition((TargetPosition)null);
                this.leftHandAttackFlag = false;
            }
            if (anim.isAt("attack_right")) {
                this.mobAttack(anim, this.getTarget(), this::doHurtTarget);
                this.setTargetPosition((TargetPosition)null);
            }
            super.handleAttack(anim);
        }
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double height = this.getBbHeight();
        double width = this.getBbWidth();
        double length = 1.0f * this.getScale();
        if (anim.is(new String[]{DUAL_SLASH_1})) {
            return new AABB(-(width += 0.7 * (double)this.getScale()) * (this.leftHandAttackFlag ? 0.3 : 0.7), -0.03, 0.0, width * (this.leftHandAttackFlag ? 0.7 : 0.3), height + 0.03, length += 0.5 * (double)this.getScale());
        }
        if (anim.is(new String[]{DUAL_SLASH_2})) {
            width += 0.5 * (double)this.getScale();
            length += (double)(1.0f * this.getScale());
        }
        if (anim.is(new String[]{DUAL_SLASH_3})) {
            width += 0.6 * (double)this.getScale();
            length += 0.8 * (double)this.getScale();
        }
        if (anim.is(new String[]{DUAL_SLASH_4})) {
            width += 1.2 * (double)this.getScale();
            length += 0.6 * (double)this.getScale();
        }
        if (anim.is(new String[]{DUAL_SLASH_5})) {
            width += 1.4 * (double)this.getScale();
            length += 0.6 * (double)this.getScale();
        }
        if (anim.is(new String[]{DUAL_SLASH_6})) {
            width = anim.isAt("attack_end") ? (width += 0.6 * (double)this.getScale()) : (width += 1.4 * (double)this.getScale());
            length += 0.8 * (double)this.getScale();
        }
        return new AABB(-width * 0.5, -0.03, 0.0, width * 0.5, height + 0.03, length);
    }

    public AnimationHandler<Emiya> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean hurt(DamageSource damageSource, float damage) {
        return !this.getAnimationHandler().isCurrent(new String[]{CALADBOLG}) && super.hurt(damageSource, damage);
    }

    @Override
    public void regenMana(Entity source) {
        if (source != this) {
            double amount = this.getAttributeValue(FateAttributes.MANA_LEECH.asHolder());
            this.regenMana(amount * 0.5);
            return;
        }
        super.regenMana(source);
    }

    @Override
    public boolean nobelPhantasmCheck() {
        return this.healthBelow(0.75f) && super.nobelPhantasmCheck();
    }

    public void attackWithRangedAttack(LivingEntity target) {
        ItemStack stack = this.getItemInHand(this.bowHand());
        if (!this.level().isClientSide) {
            ArcherArrow arrow = new ArcherArrow(this.level(), (LivingEntity)this, stack.isEmpty() ? null : stack);
            if (target != null) {
                double dX = target.getX() - this.getX();
                double dY = target.getY(0.3333333333333333) - arrow.getY();
                double dZ = target.getZ() - this.getZ();
                double l = Math.sqrt(dX * dX + dZ * dZ);
                arrow.shoot(dX, dY + l * 0.13, dZ, 2.2f, 2.0f);
            } else {
                Vec3 look = this.getViewVector(1.0f);
                arrow.shoot(look.x(), look.y(), look.z(), 2.2f, 2.0f);
            }
            arrow.setCritArrow(true);
            double mod = this.getAnimationHandler().isCurrent(new String[]{BOW_2}) ? 0.5 : 0.6;
            arrow.setBaseDamage(arrow.getBaseDamage() + this.getAttributeValue(Attributes.ATTACK_DAMAGE) * mod);
            this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)arrow);
        }
    }

    public void attackWithRangedAttackBarrage(LivingEntity target) {
        if (this.level().isClientSide) {
            return;
        }
        ItemStack stack = this.getItemInHand(this.bowHand());
        for (int i = 0; i < 8; ++i) {
            ArcherArrow arrow = new ArcherArrow(this.level(), (LivingEntity)this, stack);
            if (target != null) {
                double dX = target.getX() - this.getX();
                double dY = target.getY(0.33) - arrow.getY();
                double dZ = target.getZ() - this.getZ();
                double l = Math.sqrt(dX * dX + dZ * dZ);
                arrow.shoot(dX, dY + l * 0.13, dZ, 2.2f, 11.0f);
            } else {
                Vec3 look = this.getViewVector(1.0f);
                arrow.shoot(look.x(), look.y(), look.z(), 2.2f, 11.0f);
            }
            arrow.setCritArrow(true);
            arrow.setBaseDamage(arrow.getBaseDamage() + this.getAttributeValue(Attributes.ATTACK_DAMAGE) * 0.33);
            this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)arrow);
        }
        this.applyManaLeechDebuff(40, 0.3);
    }

    public void caladBolg(LivingEntity target) {
        if (!this.attemptUseNobelPhantasm()) {
            return;
        }
        CaladBolg bolg = new CaladBolg(this.level(), (LivingEntity)this);
        if (target != null) {
            bolg.shootAtEntity((Entity)target, 2.0f, 0.0f);
        } else {
            bolg.shoot((Entity)this, this.getXRot(), this.getYRot(), 0.0f, 2.0f, 0.0f);
        }
        this.level().addFreshEntity((Entity)bolg);
        this.revealServant();
    }

    protected boolean hasBow() {
        return this.getMainHandItem().getItem() instanceof BowItem || this.getOffhandItem().getItem() instanceof BowItem;
    }

    protected InteractionHand bowHand() {
        return this.getMainHandItem().getItem() instanceof BowItem ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    @Override
    public boolean flipAnimation() {
        return this.getAnimationHandler().isCurrent(new String[]{BOW_1, BOW_AIR, CALADBOLG}) && this.getMainHandItem().getItem() instanceof BowItem;
    }

    @Override
    protected String getSummonAnimation() {
        return SUMMON;
    }

    @Override
    public Vector4f summonColor() {
        return this.summonColor;
    }

    @Override
    public EntityWeaponTrailHolderProvider.WeaponTrail weaponTrailEdge(boolean left) {
        return new EntityWeaponTrailHolderProvider.WeaponTrail(new Vector4f(0.0f, 0.0f, -0.2f, 1.0f), new Vector4f(0.0f, 0.0f, -0.6f, 1.0f));
    }
}

